/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.MockConnectorFactory;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.UseTask;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.security.DenyAllAccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.testing.TestingConnectorContext;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestUseTask {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private CatalogManager catalogManager;
    private TransactionManager transactionManager;
    private MetadataManager metadata;

    @BeforeClass
    public void setUp() {
        this.catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)this.catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testUse() {
        Use use = new Use(Optional.of(new Identifier("test_catalog")), new Identifier("test_schema"));
        String sqlString = "USE test_catalog.test_schema";
        AllowAllAccessControl accessControl = new AllowAllAccessControl();
        this.executeUse(use, sqlString, SessionTestUtils.TEST_SESSION, (AccessControl)accessControl);
    }

    @Test(expectedExceptions={SemanticException.class}, expectedExceptionsMessageRegExp="Catalog must be specified when session catalog is not set")
    public void testUseNoCatalog() {
        Use use = new Use(Optional.empty(), new Identifier("test_schema"));
        String sqlString = "USE test_schema";
        Session session = TestingSession.testSessionBuilder().setCatalog(null).setSchema(null).build();
        AllowAllAccessControl accessControl = new AllowAllAccessControl();
        this.executeUse(use, sqlString, session, (AccessControl)accessControl);
    }

    @Test(expectedExceptions={SemanticException.class}, expectedExceptionsMessageRegExp="Catalog does not exist: invalid_catalog")
    public void testUseInvalidCatalog() {
        Use use = new Use(Optional.of(new Identifier("invalid_catalog")), new Identifier("test_schema"));
        String sqlString = "USE invalid_catalog.test_schema";
        AllowAllAccessControl accessControl = new AllowAllAccessControl();
        this.executeUse(use, sqlString, SessionTestUtils.TEST_SESSION, (AccessControl)accessControl);
    }

    @Test(expectedExceptions={SemanticException.class}, expectedExceptionsMessageRegExp="Schema does not exist: test_catalog.invalid_schema")
    public void testUseInvalidSchema() {
        Use use = new Use(Optional.of(new Identifier("test_catalog")), new Identifier("invalid_schema"));
        String sqlString = "USE test_catalog.invalid_schema";
        Session session = TestingSession.testSessionBuilder().setSchema("invalid_schema").build();
        AllowAllAccessControl accessControl = new AllowAllAccessControl();
        this.executeUse(use, sqlString, session, (AccessControl)accessControl);
    }

    @Test(expectedExceptions={AccessDeniedException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot access catalog test_catalog")
    public void testUseAccessDenied() {
        Use use = new Use(Optional.of(new Identifier("test_catalog")), new Identifier("test_schema"));
        String sqlString = "USE test_catalog.test_schema";
        Session session = TestingSession.testSessionBuilder().setIdentity(new Identity("user", Optional.empty())).build();
        DenyAllAccessControl accessControl = new DenyAllAccessControl();
        this.executeUse(use, sqlString, session, (AccessControl)accessControl);
    }

    private void executeUse(Use use, String sqlString, Session session, AccessControl accessControl) {
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema")).build();
        this.catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)this.catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager);
        Connector testConnector = mockConnectorFactory.create("test", (Map<String, String>)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        String catalogName = "test_catalog";
        ConnectorId connectorId = new ConnectorId(catalogName);
        this.catalogManager.registerCatalog(new Catalog(catalogName, connectorId, testConnector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), testConnector, ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId), testConnector));
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, session, false, this.transactionManager, this.executor, this.metadata);
        UseTask useTask = new UseTask();
        useTask.execute(use, this.transactionManager, (Metadata)this.metadata, accessControl, stateMachine, Collections.emptyList(), sqlString);
    }
}

