/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.CompressionCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.spi.page.PageCompressor;
import com.facebook.presto.spi.page.PageDecompressor;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.spiller.SpillCipher;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import java.nio.ByteBuffer;
import java.util.Optional;

public class TestingPagesSerdeFactory
extends PagesSerdeFactory {
    public TestingPagesSerdeFactory(CompressionCodec compressionCodec) {
        super((BlockEncodingSerde)new BlockEncodingManager(), compressionCodec);
    }

    public static PagesSerde testingPagesSerde() {
        return TestingPagesSerdeFactory.testingPagesSerde(false);
    }

    public static PagesSerde testingPagesSerde(boolean checksumEnabled) {
        return new SynchronizedPagesSerde((BlockEncodingSerde)new BlockEncodingManager(), Optional.of(new PageCompressor(){
            Compressor compressor = new Lz4Compressor();

            public int maxCompressedLength(int uncompressedSize) {
                return this.compressor.maxCompressedLength(uncompressedSize);
            }

            public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                return this.compressor.compress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
            }

            public void compress(ByteBuffer input, ByteBuffer output) {
                this.compressor.compress(input, output);
            }
        }), Optional.of(new PageDecompressor(){
            Decompressor decompressor = new Lz4Decompressor();

            public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                return this.decompressor.decompress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
            }

            public void decompress(ByteBuffer input, ByteBuffer output) {
                this.decompressor.decompress(input, output);
            }
        }), Optional.empty(), checksumEnabled);
    }

    private static class SynchronizedPagesSerde
    extends PagesSerde {
        public SynchronizedPagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<PageCompressor> compressor, Optional<PageDecompressor> decompressor, Optional<SpillCipher> spillCipher, boolean checksumEnabled) {
            super(blockEncodingSerde, compressor, decompressor, spillCipher, checksumEnabled);
        }

        public synchronized SerializedPage serialize(Page page) {
            return super.serialize(page);
        }

        public synchronized Page deserialize(SerializedPage serializedPage) {
            return super.deserialize(serializedPage);
        }
    }
}

