/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.scheduler.AdaptivePhasedExecutionPolicy;
import com.facebook.presto.execution.scheduler.AllAtOnceExecutionSchedule;
import com.facebook.presto.execution.scheduler.FixedCountScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.PhasedExecutionSchedule;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.facebook.presto.execution.scheduler.StageLinkage;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.NoOpFailureDetector;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.ExchangeEncoding;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tracing.TracingConfig;
import com.facebook.presto.util.FinalizerService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestAdaptivePhasedExecutionPolicy {
    private static final ConnectorTransactionHandle TRANSACTION_HANDLE = TestingTransactionHandle.create();
    private static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("test");
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"testAdaptivePhasedExecutionPolicy-%s"));

    @AfterClass
    public void tearDownExecutor() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testCreateExecutionSchedule() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)SessionPropertyManager.createTestingSessionPropertyManager((SystemSessionProperties)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig().setMaxStageCountForEagerScheduling(5), new FunctionsConfig(), new NodeMemoryConfig(), new WarningCollectorConfig(), new NodeSchedulerConfig(), new NodeSpillConfig(), new TracingConfig(), new CompilerConfig(), new HistoryBasedOptimizationConfig()))).build();
        AdaptivePhasedExecutionPolicy policy = new AdaptivePhasedExecutionPolicy();
        Collection<StageExecutionAndScheduler> schedulers = this.getStageExecutionAndSchedulers(4);
        Assert.assertTrue((boolean)(policy.createExecutionSchedule(session, schedulers) instanceof AllAtOnceExecutionSchedule));
        schedulers = this.getStageExecutionAndSchedulers(5);
        Assert.assertTrue((boolean)(policy.createExecutionSchedule(session, schedulers) instanceof AllAtOnceExecutionSchedule));
        schedulers = this.getStageExecutionAndSchedulers(6);
        Assert.assertTrue((boolean)(policy.createExecutionSchedule(session, schedulers) instanceof PhasedExecutionSchedule));
    }

    private Collection<StageExecutionAndScheduler> getStageExecutionAndSchedulers(int count) {
        PlanNode node = this.getTableScanNode();
        ImmutableList exchanges = (ImmutableList)IntStream.rangeClosed(1, count - 1).mapToObj(stage -> this.getStageExecutionAndScheduler(stage, TestAdaptivePhasedExecutionPolicy.getRemoteSourcePlanNode(new PlanFragmentId(stage)))).collect(ImmutableList.toImmutableList());
        return ImmutableList.builder().add((Object)this.getStageExecutionAndScheduler(0, node)).addAll((Iterable)exchanges).build();
    }

    private StageExecutionAndScheduler getStageExecutionAndScheduler(int stage, PlanNode fragementNode) {
        PlanFragmentId fragmentId = new PlanFragmentId(stage);
        StageId stageId = new StageId(new QueryId("query"), stage);
        SqlStageExecution stageExecution = SqlStageExecution.createSqlStageExecution((StageExecutionId)new StageExecutionId(stageId, stage), (PlanFragment)TestAdaptivePhasedExecutionPolicy.createPlanFragment(fragmentId, fragementNode), (RemoteTaskFactory)new MockRemoteTaskFactory(MoreExecutors.directExecutor(), this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)new NodeTaskMap(new FinalizerService()), (ExecutorService)MoreExecutors.newDirectExecutorService(), (FailureDetector)new NoOpFailureDetector(), (SplitSchedulerStats)new SplitSchedulerStats(), (TableWriteInfo)new TableWriteInfo(Optional.empty(), Optional.empty()));
        StageLinkage stageLinkage = new StageLinkage(fragmentId, (id, tasks, noMoreExchangeLocations) -> {}, (Set)ImmutableSet.of());
        FixedCountScheduler stageScheduler = new FixedCountScheduler(stageExecution, (List)ImmutableList.of());
        StageExecutionAndScheduler scheduler = new StageExecutionAndScheduler(stageExecution, stageLinkage, (StageScheduler)stageScheduler);
        return scheduler;
    }

    private static PlanFragment createPlanFragment(PlanFragmentId fragmentId, PlanNode remoteSourcePlanNode) {
        return new PlanFragment(fragmentId, remoteSourcePlanNode, (Set)ImmutableSet.copyOf((Collection)remoteSourcePlanNode.getOutputVariables()), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)remoteSourcePlanNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), remoteSourcePlanNode.getOutputVariables()), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
    }

    private PlanNode getTableScanNode() {
        return new TableScanNode(Optional.empty(), TABLE_SCAN_NODE_ID, new TableHandle(CONNECTOR_ID, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), TRANSACTION_HANDLE, Optional.empty()), (List)ImmutableList.of(), (Map)ImmutableMap.of());
    }

    private static PlanNode getRemoteSourcePlanNode(PlanFragmentId fragmentId) {
        RemoteSourceNode planNode = new RemoteSourceNode(Optional.empty(), new PlanNodeId("exchange"), (List)ImmutableList.of((Object)new PlanFragmentId(fragmentId.getId() - 1)), (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR)), false, Optional.empty(), ExchangeNode.Type.REPARTITION, ExchangeEncoding.COLUMNAR);
        return planNode;
    }
}

