/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.scheduler.ConsistentHashingNodeProvider;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.HostAddress;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConsistentHashingNodeProvider {
    @Test
    public void testDistribution() {
        List<InternalNode> nodes = this.createTestNodes();
        ConsistentHashingNodeProvider nodeProvider = ConsistentHashingNodeProvider.create(nodes, (int)100);
        Random random = new Random();
        HashMap<HostAddress, Integer> result = new HashMap<HostAddress, Integer>();
        for (int i = 0; i < 1000000; ++i) {
            List candidates = nodeProvider.get(String.format("split%d", random.nextInt()), 2);
            Assert.assertNotEquals(candidates.get(0), candidates.get(1));
            result.merge((HostAddress)candidates.get(0), 1, Integer::sum);
        }
        Assert.assertEquals((int)result.size(), (int)nodes.size());
        Assert.assertTrue((boolean)result.values().stream().allMatch(count -> count >= 80000 && count <= 120000));
    }

    @Test
    public void testMultipleCandidates() {
        List<InternalNode> nodes = this.createTestNodes();
        ConsistentHashingNodeProvider nodeProvider = ConsistentHashingNodeProvider.create(nodes, (int)1);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeProvider.get("split1", 10)), (Set)((Set)nodes.stream().map(InternalNode::getHostAndPort).collect(ImmutableSet.toImmutableSet())));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeProvider.get("split1", 11)), (Set)((Set)nodes.stream().map(InternalNode::getHostAndPort).collect(ImmutableSet.toImmutableSet())));
        ConsistentHashingNodeProvider nodeProviderWithWeight = ConsistentHashingNodeProvider.create(nodes, (int)100);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeProviderWithWeight.get("split1", 10)), (Set)((Set)nodes.stream().map(InternalNode::getHostAndPort).collect(ImmutableSet.toImmutableSet())));
    }

    private List<InternalNode> createTestNodes() {
        return (List)IntStream.range(0, 10).mapToObj(i -> new InternalNode(String.format("node%d", i), URI.create(String.format("http://127.0.0.%d:100", i)), NodeVersion.UNKNOWN, false)).collect(ImmutableList.toImmutableList());
    }
}

