/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.group.DynamicBucketNodeMap;
import com.facebook.presto.execution.scheduler.group.DynamicLifespanScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicLifespanScheduler {
    private static final int BUCKET_COUNT = 10;
    private static final int TASK_COUNT = 2;
    private static final InternalNode node1 = TestDynamicLifespanScheduler.getInternalNode("1");
    private static final InternalNode node2 = TestDynamicLifespanScheduler.getInternalNode("2");
    private static final InternalNode node3 = TestDynamicLifespanScheduler.getInternalNode("3");

    @Test
    public void testSchedule() {
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getLifespanScheduler();
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
            sourceScheduler.getLastStartedLifespans().clear();
        }
    }

    @Test
    public void testRetry() {
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getLifespanScheduler();
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        lifespanScheduler.onLifespanExecutionFinished((Iterable)ImmutableList.of((Object)sourceScheduler.getLastStartedLifespans().get(1)));
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        lifespanScheduler.onTaskFailed(0, (List)ImmutableList.of((Object)sourceScheduler));
        Assert.assertEquals((int)sourceScheduler.getLastRewoundLifespans().size(), (int)1);
        sourceScheduler.getLastRewoundLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)1);
            sourceScheduler.getLastStartedLifespans().clear();
        }
    }

    @Test(timeOut=10000L)
    public void testRetryLastLifespan() {
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getLifespanScheduler();
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        for (int i = 0; i < 4; ++i) {
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            sourceScheduler.getLastStartedLifespans().clear();
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        }
        lifespanScheduler.onLifespanExecutionFinished((Iterable)ImmutableList.of((Object)sourceScheduler.getLastStartedLifespans().get(1)));
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        lifespanScheduler.onTaskFailed(0, (List)ImmutableList.of((Object)sourceScheduler));
        Assert.assertEquals((int)sourceScheduler.getLastRewoundLifespans().size(), (int)1);
        sourceScheduler.getLastRewoundLifespans().clear();
        lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)1);
        lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
    }

    @Test
    public void testAffinitySchedule() {
        DynamicBucketNodeMap bucketNodeMap = new DynamicBucketNodeMap(split -> ((TestSplit)split.getConnectorSplit()).getBucketNumber(), 10, (List)ImmutableList.of((Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2));
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getAffinityLifespanScheduler((BucketNodeMap)bucketNodeMap);
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
            sourceScheduler.getLastStartedLifespans().clear();
        }
    }

    @Test
    public void testAffinityRetry() {
        DynamicBucketNodeMap bucketNodeMap = new DynamicBucketNodeMap(split -> ((TestSplit)split.getConnectorSplit()).getBucketNumber(), 10, (List)ImmutableList.of((Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2));
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getAffinityLifespanScheduler((BucketNodeMap)bucketNodeMap);
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        lifespanScheduler.onLifespanExecutionFinished((Iterable)ImmutableList.of((Object)sourceScheduler.getLastStartedLifespans().get(1)));
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        lifespanScheduler.onTaskFailed(0, (List)ImmutableList.of((Object)sourceScheduler));
        Assert.assertEquals((int)sourceScheduler.getLastRewoundLifespans().size(), (int)1);
        sourceScheduler.getLastRewoundLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)1);
            sourceScheduler.getLastStartedLifespans().clear();
        }
    }

    @Test
    public void testAffinityScheduleLocality() {
        DynamicBucketNodeMap bucketNodeMap = new DynamicBucketNodeMap(split -> ((TestSplit)split.getConnectorSplit()).getBucketNumber(), 10, (List)ImmutableList.of((Object)node1, (Object)node3, (Object)node1, (Object)node3, (Object)node1, (Object)node3, (Object)node1, (Object)node3, (Object)node1, (Object)node3));
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getAffinityLifespanScheduler((BucketNodeMap)bucketNodeMap);
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(0).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(1).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(2).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(3).get(), (Object)node3);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(4).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(5).get(), (Object)node3);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(6).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(7).get(), (Object)node3);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(8).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(9).get(), (Object)node3);
        lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
            sourceScheduler.getLastStartedLifespans().clear();
        }
        Assert.assertEquals(bucketNodeMap.getAssignedNode(0).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(1).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(2).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(3).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(4).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(5).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(6).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(7).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(8).get(), (Object)node1);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(9).get(), (Object)node2);
    }

    @Test
    public void testAffinityScheduleFailedLocality() {
        DynamicBucketNodeMap bucketNodeMap = new DynamicBucketNodeMap(split -> ((TestSplit)split.getConnectorSplit()).getBucketNumber(), 10, (List)ImmutableList.of((Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2, (Object)node1, (Object)node2));
        LifespanScheduler lifespanScheduler = TestDynamicLifespanScheduler.getAffinityLifespanScheduler((BucketNodeMap)bucketNodeMap);
        TestingSourceScheduler sourceScheduler = new TestingSourceScheduler();
        lifespanScheduler.scheduleInitial((SourceScheduler)sourceScheduler);
        lifespanScheduler.onLifespanExecutionFinished((Iterable)ImmutableList.of((Object)sourceScheduler.getLastStartedLifespans().get(1)));
        Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)2);
        sourceScheduler.getLastStartedLifespans().clear();
        lifespanScheduler.onTaskFailed(0, (List)ImmutableList.of((Object)sourceScheduler));
        Assert.assertEquals((int)sourceScheduler.getLastRewoundLifespans().size(), (int)1);
        sourceScheduler.getLastRewoundLifespans().clear();
        while (!lifespanScheduler.allLifespanExecutionFinished()) {
            lifespanScheduler.schedule((SourceScheduler)sourceScheduler);
            lifespanScheduler.onLifespanExecutionFinished(sourceScheduler.getLastStartedLifespans());
            Assert.assertEquals((int)sourceScheduler.getLastStartedLifespans().size(), (int)1);
            sourceScheduler.getLastStartedLifespans().clear();
        }
        Assert.assertEquals(bucketNodeMap.getAssignedNode(0).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(1).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(2).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(3).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(4).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(5).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(6).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(7).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(8).get(), (Object)node2);
        Assert.assertEquals(bucketNodeMap.getAssignedNode(9).get(), (Object)node2);
    }

    private static LifespanScheduler getAffinityLifespanScheduler(BucketNodeMap bucketNodeMap) {
        return new DynamicLifespanScheduler(bucketNodeMap, (List)ImmutableList.of((Object)node1, (Object)node2), (List)IntStream.range(0, 10).mapToObj(TestPartitionHandle::new).collect(ImmutableList.toImmutableList()), OptionalInt.of(1));
    }

    private static LifespanScheduler getLifespanScheduler() {
        return new DynamicLifespanScheduler((BucketNodeMap)new DynamicBucketNodeMap(split -> ((TestSplit)split.getConnectorSplit()).getBucketNumber(), 10), (List)ImmutableList.of((Object)TestDynamicLifespanScheduler.getInternalNode("1"), (Object)TestDynamicLifespanScheduler.getInternalNode("2")), (List)IntStream.range(0, 10).mapToObj(TestPartitionHandle::new).collect(ImmutableList.toImmutableList()), OptionalInt.of(1));
    }

    private static InternalNode getInternalNode(String id) {
        return new InternalNode(id, URI.create(id), new NodeVersion("test"), false);
    }

    public class TestingSourceScheduler
    implements SourceScheduler {
        private final List<Lifespan> lastStartedLifespans = new ArrayList<Lifespan>();
        private final List<Lifespan> lastRewoundLifespans = new ArrayList<Lifespan>();

        public ScheduleResult schedule() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public PlanNodeId getPlanNodeId() {
            throw new UnsupportedOperationException();
        }

        public void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            this.lastStartedLifespans.add(lifespan);
        }

        public void rewindLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            this.lastRewoundLifespans.add(lifespan);
        }

        public List<Lifespan> drainCompletelyScheduledLifespans() {
            throw new UnsupportedOperationException();
        }

        public void notifyAllLifespansFinishedExecution() {
            throw new UnsupportedOperationException();
        }

        public List<Lifespan> getLastStartedLifespans() {
            return this.lastStartedLifespans;
        }

        public List<Lifespan> getLastRewoundLifespans() {
            return this.lastRewoundLifespans;
        }
    }

    private static class TestSplit
    implements ConnectorSplit {
        private final int bucketNumber;

        private TestSplit(int bucketNumber) {
            this.bucketNumber = bucketNumber;
        }

        public int getBucketNumber() {
            return this.bucketNumber;
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestPartitionHandle
    extends ConnectorPartitionHandle {
        private final int bucket;

        public TestPartitionHandle(int bucket) {
            this.bucket = bucket;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestPartitionHandle)) {
                return false;
            }
            TestPartitionHandle that = (TestPartitionHandle)((Object)o);
            return this.bucket == that.bucket;
        }

        public int hashCode() {
            return Objects.hash(this.bucket);
        }
    }
}

