/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesSpatialIndexFactory;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SpatialJoinOperator;
import com.facebook.presto.operator.StandardJoinFilterFunction;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSpatialJoinOperator {
    private static final KdbTree KDB_TREE = KdbTree.buildKdbTree((int)2, (List)ImmutableList.of((Object)new Rectangle(-2.0, -2.0, -2.0, -2.0), (Object)new Rectangle(0.0, 0.0, 0.0, 0.0), (Object)new Rectangle(-1.0, -2.0, 4.0, 3.0), (Object)new Rectangle(6.0, 1.0, 6.0, 1.0), (Object)new Rectangle(3.0, 9.0, 3.0, 9.0), (Object)new Rectangle(15.0, 15.0, 15.0, 15.0)));
    private static final String KDB_TREE_JSON = KdbTreeUtils.toJson((KdbTree)KDB_TREE);
    private static final Slice POLYGON_A = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0 0, -0.5 2.5, 0 5, 2.5 5.5, 5 5, 5.5 2.5, 5 0, 2.5 -0.5, 0 0))"));
    private static final Slice POLYGON_B = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((4 4, 3.5 7, 4 10, 7 10.5, 10 10, 10.5 7, 10 4, 7 3.5, 4 4))"));
    private static final Slice POLYGON_C = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((15 15, 15 14, 14 14, 14 15, 15 15))"));
    private static final Slice POLYGON_D = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((18 18, 18 19, 19 19, 19 18, 18 18))"));
    private static final Slice POINT_X = GeoFunctions.stPoint((double)1.0, (double)1.0);
    private static final Slice POINT_Y = GeoFunctions.stPoint((double)4.5, (double)4.5);
    private static final Slice POINT_Z = GeoFunctions.stPoint((double)6.0, (double)6.0);
    private static final Slice POINT_W = GeoFunctions.stPoint((double)20.0, (double)20.0);
    private static final Slice POINT_V = GeoFunctions.stPoint((double)15.0, (double)15.0);
    private static final Slice MULTIPOINT_U = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"MULTIPOINT (15 15)"));
    private static final Slice MULTIPOINT_T = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"MULTIPOINT (14.5 14.5, 16 16)"));
    private static final Slice POINT_S = GeoFunctions.stPoint((double)18.0, (double)18.0);
    private static final Slice MULTIPOINT_R = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"MULTIPOINT (15 15, 19 19)"));
    private static final Slice POINT_Q = GeoFunctions.stPoint((double)28.0, (double)28.0);
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeMethod
    public void setUp() {
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.daemonThreadsNamed((String)"test-executor-%s"), new ThreadPoolExecutor.DiscardPolicy());
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSpatialJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POLYGON_A, "A").row(null, "null").pageBreak().row(POLYGON_B, "B").row(POLYGON_C, "C").row(POLYGON_D, "D");
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POINT_X, "x").row(null, "null").row(POINT_Y, "y").pageBreak().row(POINT_Z, "z").pageBreak().row(POINT_W, "w").row(POINT_V, "v").row(MULTIPOINT_U, "u").pageBreak().row(MULTIPOINT_T, "t").row(POINT_S, "s").row(MULTIPOINT_R, "r").row(POINT_Q, "q");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).row(new Object[]{"v", "C"}).row(new Object[]{"u", "C"}).row(new Object[]{"t", "C"}).row(new Object[]{"s", "D"}).row(new Object[]{"r", "C"}).row(new Object[]{"r", "D"}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testSpatialLeftJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POLYGON_A, "A").row(null, "null").pageBreak().row(POLYGON_B, "B").row(POLYGON_C, "C").row(POLYGON_D, "D");
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POINT_X, "x").row(null, "null").row(POINT_Y, "y").pageBreak().row(POINT_Z, "z").pageBreak().row(POINT_W, "w").row(POINT_V, "v").row(MULTIPOINT_U, "u").pageBreak().row(MULTIPOINT_T, "t").row(POINT_S, "s").row(MULTIPOINT_R, "r").row(POINT_Q, "q");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"null", null}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).row(new Object[]{"w", null}).row(new Object[]{"v", "C"}).row(new Object[]{"u", "C"}).row(new Object[]{"t", "C"}).row(new Object[]{"s", "D"}).row(new Object[]{"r", "C"}).row(new Object[]{"r", "D"}).row(new Object[]{"q", null}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.LEFT, buildPages, probePages, expected);
    }

    private void assertSpatialJoin(TaskContext taskContext, SpatialJoinNode.Type joinType, RowPagesBuilder buildPages, RowPagesBuilder probePages, MaterializedResult expected) {
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.intersects(probe), Optional.empty(), Optional.empty(), buildPages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), joinType, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)joinOperatorFactory, driverContext, probePages.build(), expected);
    }

    @Test
    public void testEmptyBuild() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POINT_X, "x").row(null, "null").row(POINT_Y, "y").pageBreak().row(POINT_Z, "z").pageBreak().row(POINT_W, "w");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testEmptyBuildLeftJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POINT_X, "x").row(null, "null").row(POINT_Y, "y").pageBreak().row(POINT_Z, "z").pageBreak().row(POINT_W, "w");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", null}).row(new Object[]{"null", null}).row(new Object[]{"y", null}).row(new Object[]{"z", null}).row(new Object[]{"w", null}).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.LEFT, buildPages, probePages, expected);
    }

    @Test
    public void testEmptyProbe() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POLYGON_A, "A").row(null, "null").pageBreak().row(POLYGON_B, "B");
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).build();
        this.assertSpatialJoin(taskContext, SpatialJoinNode.Type.INNER, buildPages, probePages, expected);
    }

    @Test
    public void testYield() {
        int i;
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        AtomicInteger filterFunctionCalls = new AtomicInteger();
        TestInternalJoinFilterFunction filterFunction = new TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            filterFunctionCalls.incrementAndGet();
            driverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(POLYGON_A, "A").pageBreak().row(POLYGON_B, "B");
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.contains(probe), Optional.empty(), Optional.of(filterFunction), buildPages);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR));
        for (i = 0; i < 10; ++i) {
            probePages.row(GeoFunctions.stPoint((double)(1.0 + 0.1 * (double)i), (double)(1.0 + 0.1 * (double)i)), "x" + i);
        }
        for (i = 0; i < 10; ++i) {
            probePages.row(GeoFunctions.stPoint((double)(4.5 + 0.01 * (double)i), (double)(4.5 + 0.01 * (double)i)), "y" + i);
        }
        for (i = 0; i < 10; ++i) {
            probePages.row(GeoFunctions.stPoint((double)(6.0 + 0.1 * (double)i), (double)(6.0 + 0.1 * (double)i)), "z" + i);
        }
        List<Page> probeInput = probePages.build();
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(probeInput.get(0));
        operator.finish();
        for (int i2 = 0; i2 < 40; ++i2) {
            driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
            Assert.assertNull((Object)operator.getOutput());
            Assert.assertEquals((int)filterFunctionCalls.get(), (int)(i2 + 1), (String)"Expected join to stop processing (yield) after calling filter function once");
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)40);
    }

    @Test
    public void testDistanceQuery() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE)).row(GeoFunctions.stPoint((double)0.0, (double)0.0), "0_0", 1.5).row(null, "null", 1.5).row(GeoFunctions.stPoint((double)1.0, (double)0.0), "1_0", 1.5).pageBreak().row(GeoFunctions.stPoint((double)3.0, (double)0.0), "3_0", 1.5).pageBreak().row(GeoFunctions.stPoint((double)10.0, (double)0.0), "10_0", 1.5);
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.distance(probe) <= r.getAsDouble(), Optional.of(2), Optional.empty(), buildPages);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR)).row(GeoFunctions.stPoint((double)0.0, (double)1.0), "0_1").row(null, "null").row(GeoFunctions.stPoint((double)1.0, (double)1.0), "1_1").pageBreak().row(GeoFunctions.stPoint((double)3.0, (double)1.0), "3_1").pageBreak().row(GeoFunctions.stPoint((double)10.0, (double)1.0), "10_1");
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.empty(), pagesSpatialIndexFactory);
        joinOperatorFactory.duplicate().noMoreOperators();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"0_1", "0_0"}).row(new Object[]{"0_1", "1_0"}).row(new Object[]{"1_1", "0_0"}).row(new Object[]{"1_1", "1_0"}).row(new Object[]{"3_1", "3_0"}).row(new Object[]{"10_1", "10_0"}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)joinOperatorFactory, driverContext, probePages.build(), expected);
    }

    @Test
    public void testDistributedSpatialJoin() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, true).addDriverContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER));
        this.addGeometryPartitionRows(buildPages, POLYGON_A, "A");
        buildPages.row(null, "null", null);
        buildPages.pageBreak();
        this.addGeometryPartitionRows(buildPages, POLYGON_B, "B");
        this.addGeometryPartitionRows(buildPages, POLYGON_C, "C");
        this.addGeometryPartitionRows(buildPages, POLYGON_D, "D");
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER));
        this.addGeometryPartitionRows(probePages, POINT_X, "x");
        probePages.row(null, "null", null);
        this.addGeometryPartitionRows(probePages, POINT_Y, "y");
        probePages.pageBreak();
        this.addGeometryPartitionRows(probePages, POINT_Z, "z");
        this.addGeometryPartitionRows(probePages, POINT_W, "w");
        this.addGeometryPartitionRows(probePages, POINT_V, "v");
        this.addGeometryPartitionRows(probePages, MULTIPOINT_U, "u");
        probePages.pageBreak();
        this.addGeometryPartitionRows(probePages, MULTIPOINT_T, "t");
        this.addGeometryPartitionRows(probePages, POINT_S, "s");
        this.addGeometryPartitionRows(probePages, MULTIPOINT_R, "r");
        this.addGeometryPartitionRows(probePages, POINT_Q, "q");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"x", "A"}).row(new Object[]{"y", "A"}).row(new Object[]{"y", "B"}).row(new Object[]{"z", "B"}).row(new Object[]{"v", "C"}).row(new Object[]{"u", "C"}).row(new Object[]{"t", "C"}).row(new Object[]{"s", "D"}).row(new Object[]{"r", "C"}).row(new Object[]{"r", "D"}).build();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.intersects(probe), Optional.empty(), Optional.of(2), Optional.of(KDB_TREE_JSON), Optional.empty(), buildPages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, probePages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.of(2), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)joinOperatorFactory, driverContext, probePages.build(), expected);
    }

    @Test
    public void testDistributedSpatialSelfJoin() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, true).addDriverContext();
        RowPagesBuilder pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)GeometryType.GEOMETRY, (Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER));
        this.addGeometryPartitionRows(pages, POLYGON_A, "A");
        pages.row(null, "null", null);
        pages.pageBreak();
        this.addGeometryPartitionRows(pages, POLYGON_B, "B");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)).row(new Object[]{"A", "A"}).row(new Object[]{"A", "B"}).row(new Object[]{"B", "A"}).row(new Object[]{"B", "B"}).build();
        PagesSpatialIndexFactory pagesSpatialIndexFactory = this.buildIndex(driverContext, (build, probe, r) -> build.intersects(probe), Optional.empty(), Optional.of(2), Optional.of(KDB_TREE_JSON), Optional.empty(), pages);
        SpatialJoinOperator.SpatialJoinOperatorFactory joinOperatorFactory = new SpatialJoinOperator.SpatialJoinOperatorFactory(2, new PlanNodeId("test"), SpatialJoinNode.Type.INNER, pages.getTypes(), Ints.asList((int[])new int[]{1}), 0, Optional.of(2), pagesSpatialIndexFactory);
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)joinOperatorFactory, driverContext, pages.build(), expected);
    }

    private void addGeometryPartitionRows(RowPagesBuilder pageBuilder, Slice geometry, String geometryName) {
        Block partitionIndices = GeoFunctions.spatialPartitions((Object)KDB_TREE, (Slice)geometry);
        for (int position = 0; position < partitionIndices.getPositionCount(); ++position) {
            int partitionIndex = partitionIndices.getInt(position);
            pageBuilder.row(geometry, geometryName, partitionIndex);
        }
    }

    private PagesSpatialIndexFactory buildIndex(DriverContext driverContext, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Integer> radiusChannel, Optional<InternalJoinFilterFunction> filterFunction, RowPagesBuilder buildPages) {
        return this.buildIndex(driverContext, spatialRelationshipTest, radiusChannel, Optional.empty(), Optional.empty(), filterFunction, buildPages);
    }

    private PagesSpatialIndexFactory buildIndex(DriverContext driverContext, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, Optional<String> kdbTreeJson, Optional<InternalJoinFilterFunction> filterFunction, RowPagesBuilder buildPages) {
        Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = filterFunction.map(function -> (session, addresses, pages) -> new StandardJoinFilterFunction(function, addresses, pages));
        ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("test"), buildPages.build());
        SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory buildOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(1, new PlanNodeId("test"), buildPages.getTypes(), Ints.asList((int[])new int[]{1}), 0, radiusChannel, partitionChannel, spatialRelationshipTest, kdbTreeJson, filterFunctionFactory, 10000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false));
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)valuesOperatorFactory.createOperator(driverContext), (Operator[])new Operator[]{buildOperatorFactory.createOperator(driverContext)});
        PagesSpatialIndexFactory pagesSpatialIndexFactory = buildOperatorFactory.getPagesSpatialIndexFactory();
        ListenableFuture pagesSpatialIndex = pagesSpatialIndexFactory.createPagesSpatialIndex();
        while (!pagesSpatialIndex.isDone()) {
            driver.process();
        }
        pagesSpatialIndexFactory.probeOperatorFinished();
        TestSpatialJoinOperator.runDriverInThread(this.executor, driver);
        return pagesSpatialIndexFactory;
    }

    private static void runDriverInThread(ExecutorService executor, Driver driver) {
        executor.execute(() -> {
            if (!driver.isFinished()) {
                try {
                    driver.process();
                }
                catch (PrestoException e) {
                    driver.getDriverContext().failed((Throwable)e);
                    throw e;
                }
                TestSpatialJoinOperator.runDriverInThread(executor, driver);
            }
        });
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static class TestInternalJoinFilterFunction
    implements InternalJoinFilterFunction {
        private final Lambda lambda;

        private TestInternalJoinFilterFunction(Lambda lambda) {
            this.lambda = lambda;
        }

        public boolean filter(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
            return this.lambda.filter(leftPosition, leftPage, rightPosition, rightPage);
        }

        public static interface Lambda {
            public boolean filter(int var1, Page var2, int var3, Page var4);
        }
    }
}

