/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.testing.TestingSession;
import io.airlift.units.DataSize;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryTracking {
    private static final DataSize queryMaxMemory = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final DataSize queryMaxTotalMemory = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final DataSize queryMaxRevocableMemory = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private static final DataSize memoryPoolSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final DataSize maxSpillSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final DataSize queryMaxSpillSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(maxSpillSize);
    private QueryContext queryContext;
    private TaskContext taskContext;
    private PipelineContext pipelineContext;
    private DriverContext driverContext;
    private OperatorContext operatorContext;
    private MemoryPool memoryPool;
    private ExecutorService notificationExecutor;
    private ScheduledExecutorService yieldExecutor;

    @BeforeClass
    public void setUp() {
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.queryContext = null;
        this.taskContext = null;
        this.pipelineContext = null;
        this.driverContext = null;
        this.operatorContext = null;
        this.memoryPool = null;
    }

    @BeforeMethod
    public void setUpTest() {
        this.memoryPool = new MemoryPool(new MemoryPoolId("test"), memoryPoolSize);
        this.queryContext = new QueryContext(new QueryId("test_query"), queryMaxMemory, queryMaxTotalMemory, queryMaxMemory, queryMaxRevocableMemory, this.memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.notificationExecutor, this.yieldExecutor, queryMaxSpillSize, spillSpaceTracker, JsonCodec.listJsonCodec(TaskMemoryReservationSummary.class));
        this.taskContext = this.queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0, 0, 0), (Executor)this.notificationExecutor), TestingSession.testSessionBuilder().build(), Optional.of(TaskTestUtils.PLAN_FRAGMENT.getRoot()), true, true, true, true, false);
        this.pipelineContext = this.taskContext.addPipelineContext(0, true, true, false);
        this.driverContext = this.pipelineContext.addDriverContext();
        this.operatorContext = this.driverContext.addOperatorContext(1, new PlanNodeId("a"), "test-operator");
    }

    @Test
    public void testOperatorAllocations() {
        MemoryTrackingContext operatorMemoryContext = this.operatorContext.getOperatorMemoryContext();
        LocalMemoryContext systemMemory = this.operatorContext.localSystemMemoryContext();
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext revocableMemory = this.operatorContext.localRevocableMemoryContext();
        userMemory.setBytes(100L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 0L, 0L);
        systemMemory.setBytes(1000000L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 1000000L, 0L);
        systemMemory.setBytes(2000000L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 2000000L, 0L);
        userMemory.setBytes(500L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 500L, 2000000L, 0L);
        userMemory.setBytes(userMemory.getBytes() - 500L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 2000000L, 0L);
        revocableMemory.setBytes(300L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 2000000L, 300L);
        this.assertAllocationFails(ignored -> userMemory.setBytes(userMemory.getBytes() - 500L), "bytes cannot be negative");
        this.operatorContext.destroy();
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 0L, 0L);
    }

    @Test
    public void testLocalTotalMemoryLimitExceeded() {
        LocalMemoryContext systemMemoryContext = this.operatorContext.localSystemMemoryContext();
        systemMemoryContext.setBytes(100L);
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 100L, 0L);
        systemMemoryContext.setBytes(queryMaxTotalMemory.toBytes());
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, queryMaxTotalMemory.toBytes(), 0L);
        try {
            systemMemoryContext.setBytes(queryMaxTotalMemory.toBytes() + 1L);
            Assert.fail((String)"allocation should hit the per-node total memory limit");
        }
        catch (ExceededMemoryLimitException e) {
            Assert.assertEquals((String)e.getMessage(), (String)String.format("Query exceeded per-node total memory limit of %1$s [Allocated: %1$s, Delta: 1B (test-operator), Top Consumers: {test-operator=%1$s}]", queryMaxTotalMemory));
        }
    }

    @Test
    public void testLocalRevocableMemoryLimitExceeded() {
        LocalMemoryContext revocableMemoryContext = this.operatorContext.localRevocableMemoryContext();
        revocableMemoryContext.setBytes(100L);
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 0L, 100L);
        revocableMemoryContext.setBytes(queryMaxRevocableMemory.toBytes());
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 0L, queryMaxRevocableMemory.toBytes());
        try {
            revocableMemoryContext.setBytes(queryMaxRevocableMemory.toBytes() + 1L);
            Assert.fail((String)"allocation should hit the per-node revocable memory limit");
        }
        catch (ExceededMemoryLimitException e) {
            Assert.assertEquals((String)e.getMessage(), (String)String.format("Query exceeded per-node revocable memory limit of %1$s [Allocated: %1$s, Delta: 1B (test-operator)]", queryMaxRevocableMemory));
        }
    }

    @Test
    public void testLocalSystemAllocations() {
        long pipelineLocalAllocation = 1000000L;
        long taskLocalAllocation = 10000000L;
        LocalMemoryContext pipelineLocalSystemMemoryContext = this.pipelineContext.localSystemMemoryContext();
        pipelineLocalSystemMemoryContext.setBytes(pipelineLocalAllocation);
        this.assertLocalMemoryAllocations(this.pipelineContext.getPipelineMemoryContext(), pipelineLocalAllocation, 0L, pipelineLocalAllocation);
        LocalMemoryContext taskLocalSystemMemoryContext = this.taskContext.localSystemMemoryContext();
        taskLocalSystemMemoryContext.setBytes(taskLocalAllocation);
        this.assertLocalMemoryAllocations(this.taskContext.getTaskMemoryContext(), pipelineLocalAllocation + taskLocalAllocation, 0L, taskLocalAllocation);
        Assert.assertEquals((long)this.pipelineContext.getPipelineStats().getSystemMemoryReservationInBytes(), (long)pipelineLocalAllocation, (String)"task level allocations should not be visible at the pipeline level");
        pipelineLocalSystemMemoryContext.setBytes(pipelineLocalSystemMemoryContext.getBytes() - pipelineLocalAllocation);
        this.assertLocalMemoryAllocations(this.pipelineContext.getPipelineMemoryContext(), taskLocalAllocation, 0L, 0L);
        taskLocalSystemMemoryContext.setBytes(taskLocalSystemMemoryContext.getBytes() - taskLocalAllocation);
        this.assertLocalMemoryAllocations(this.taskContext.getTaskMemoryContext(), 0L, 0L, 0L);
    }

    @Test
    public void testStats() {
        LocalMemoryContext systemMemory = this.operatorContext.localSystemMemoryContext();
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        userMemory.setBytes(100000000L);
        systemMemory.setBytes(200000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 200000000L);
        userMemory.setBytes(600000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 600000000L, 0L, 200000000L);
        userMemory.setBytes(userMemory.getBytes() - 300000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 300000000L, 0L, 200000000L);
        userMemory.setBytes(userMemory.getBytes() - 300000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 0L, 200000000L);
        this.operatorContext.destroy();
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 0L, 0L);
    }

    @Test
    public void testRevocableMemoryAllocations() {
        LocalMemoryContext systemMemory = this.operatorContext.localSystemMemoryContext();
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext revocableMemory = this.operatorContext.localRevocableMemoryContext();
        revocableMemory.setBytes(100000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 100000000L, 0L);
        userMemory.setBytes(100000000L);
        systemMemory.setBytes(100000000L);
        revocableMemory.setBytes(200000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 200000000L, 100000000L);
    }

    @Test
    public void testTrySetBytes() {
        LocalMemoryContext localMemoryContext = this.operatorContext.localUserMemoryContext();
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(100000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(200000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 200000000L, 0L, 0L);
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(100000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
        Assert.assertFalse((boolean)localMemoryContext.trySetBytes(this.memoryPool.getMaxBytes() + 1L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
    }

    @Test
    public void testTrySetZeroBytesFullPool() {
        LocalMemoryContext localMemoryContext = this.operatorContext.localUserMemoryContext();
        this.memoryPool.reserve(new QueryId("test_query"), "test", this.memoryPool.getFreeBytes());
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(localMemoryContext.getBytes()));
    }

    @Test
    public void testDestroy() {
        LocalMemoryContext newLocalSystemMemoryContext = this.operatorContext.localSystemMemoryContext();
        LocalMemoryContext newLocalUserMemoryContext = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext newLocalRevocableMemoryContext = this.operatorContext.localRevocableMemoryContext();
        newLocalSystemMemoryContext.setBytes(100000L);
        newLocalRevocableMemoryContext.setBytes(200000L);
        newLocalUserMemoryContext.setBytes(400000L);
        Assert.assertEquals((long)this.operatorContext.getOperatorMemoryContext().getSystemMemory(), (long)100000L);
        Assert.assertEquals((long)this.operatorContext.getOperatorMemoryContext().getUserMemory(), (long)400000L);
        this.operatorContext.destroy();
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 0L, 0L);
    }

    @Test
    public void testCumulativeUserMemoryEstimation() {
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        long userMemoryBytes = 100000000L;
        userMemory.setBytes(userMemoryBytes);
        long startTime = System.nanoTime();
        double cumulativeUserMemory = this.taskContext.getTaskStats().getCumulativeUserMemory();
        long endTime = System.nanoTime();
        double elapsedTimeInMillis = (double)(endTime - startTime) / 1000000.0;
        long averageMemoryForLastPeriod = userMemoryBytes / 2L;
        Assert.assertTrue((cumulativeUserMemory < elapsedTimeInMillis * (double)averageMemoryForLastPeriod ? 1 : 0) != 0);
    }

    @Test
    public void testCumulativeTotalMemoryEstimation() {
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext systemMemory = this.operatorContext.localSystemMemoryContext();
        long userMemoryBytes = 100000000L;
        long systemMemoryBytes = 40000000L;
        userMemory.setBytes(userMemoryBytes);
        systemMemory.setBytes(systemMemoryBytes);
        long startTime = System.nanoTime();
        double cumulativeTotalMemory = this.taskContext.getTaskStats().getCumulativeTotalMemory();
        long endTime = System.nanoTime();
        double elapsedTimeInMillis = (double)(endTime - startTime) / 1000000.0;
        long averageMemoryForLastPeriod = (userMemoryBytes + systemMemoryBytes) / 2L;
        Assert.assertTrue((cumulativeTotalMemory < elapsedTimeInMillis * (double)averageMemoryForLastPeriod ? 1 : 0) != 0);
    }

    private void assertStats(OperatorStats operatorStats, DriverStats driverStats, PipelineStats pipelineStats, TaskStats taskStats, long expectedUserMemory, long expectedRevocableMemory, long expectedSystemMemory) {
        Assert.assertEquals((long)operatorStats.getUserMemoryReservationInBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)driverStats.getUserMemoryReservationInBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)pipelineStats.getUserMemoryReservationInBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)taskStats.getUserMemoryReservationInBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)operatorStats.getSystemMemoryReservationInBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)driverStats.getSystemMemoryReservationInBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)pipelineStats.getSystemMemoryReservationInBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)taskStats.getSystemMemoryReservationInBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)operatorStats.getRevocableMemoryReservationInBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)driverStats.getRevocableMemoryReservationInBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)pipelineStats.getRevocableMemoryReservationInBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)taskStats.getRevocableMemoryReservationInBytes(), (long)expectedRevocableMemory);
    }

    private void assertAllocationFails(Consumer<Void> allocationFunction, String expectedPattern) {
        try {
            allocationFunction.accept(null);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)Pattern.matches(expectedPattern, e.getMessage()), (String)("\nExpected (re) :" + expectedPattern + "\nActual :" + e.getMessage()));
        }
    }

    private void assertOperatorMemoryAllocations(MemoryTrackingContext memoryTrackingContext, long expectedUserMemory, long expectedSystemMemory, long expectedRevocableMemory) {
        Assert.assertEquals((long)memoryTrackingContext.getUserMemory(), (long)expectedUserMemory, (String)"User memory verification failed");
        Assert.assertEquals((long)this.memoryPool.getReservedBytes(), (long)(expectedUserMemory + expectedSystemMemory), (String)"Memory pool verification failed");
        Assert.assertEquals((long)memoryTrackingContext.getSystemMemory(), (long)expectedSystemMemory, (String)"System memory verification failed");
        Assert.assertEquals((long)memoryTrackingContext.getRevocableMemory(), (long)expectedRevocableMemory, (String)"Revocable memory verification failed");
    }

    private void assertLocalMemoryAllocations(MemoryTrackingContext memoryTrackingContext, long expectedPoolMemory, long expectedContextUserMemory, long expectedContextSystemMemory) {
        Assert.assertEquals((long)memoryTrackingContext.getUserMemory(), (long)expectedContextUserMemory, (String)"User memory verification failed");
        Assert.assertEquals((long)this.memoryPool.getReservedBytes(), (long)expectedPoolMemory, (String)"Memory pool verification failed");
        Assert.assertEquals((long)memoryTrackingContext.localSystemMemoryContext().getBytes(), (long)expectedContextSystemMemory, (String)"Local system memory verification failed");
    }
}

