/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeMemoryConfig {
    private static final DataSize DEFAULT_MAX_QUERY_BROADCAST_MEMORY = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE);
    private static final DataSize DEFAULT_MAX_QUERY_MEMORY_PER_NODE = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE);
    private static final DataSize DEFAULT_SOFT_MAX_QUERY_MEMORY_PER_NODE = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE);
    private static final DataSize DEFAULT_MAX_QUERY_TOTAL_MEMORY_PER_NODE = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.2, DataSize.Unit.BYTE);
    private static final DataSize DEFAULT_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.2, DataSize.Unit.BYTE);
    private static final DataSize DEFAULT_HEAP_HEADROOM = new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_MAX_QUERY_BROADCAST_MEMORY = new DataSize((double)(DEFAULT_MAX_QUERY_BROADCAST_MEMORY.toBytes() * 2L), DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_MAX_QUERY_MEMORY_PER_NODE = new DataSize((double)(DEFAULT_MAX_QUERY_MEMORY_PER_NODE.toBytes() * 2L), DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_SOFT_MAX_QUERY_MEMORY_PER_NODE = new DataSize((double)(DEFAULT_SOFT_MAX_QUERY_MEMORY_PER_NODE.toBytes() * 2L), DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_MAX_QUERY_TOTAL_MEMORY_PER_NODE = new DataSize((double)(DEFAULT_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toBytes() * 2L), DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE = new DataSize((double)(DEFAULT_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toBytes() * 2L), DataSize.Unit.BYTE);
    private static final DataSize OVERRIDE_HEAP_HEADROOM = new DataSize((double)DEFAULT_HEAP_HEADROOM.toBytes() * 0.5, DataSize.Unit.BYTE);

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryBroadcastMemory(DEFAULT_MAX_QUERY_BROADCAST_MEMORY).setMaxQueryMemoryPerNode(DEFAULT_MAX_QUERY_MEMORY_PER_NODE).setSoftMaxQueryMemoryPerNode(DEFAULT_SOFT_MAX_QUERY_MEMORY_PER_NODE).setMaxQueryTotalMemoryPerNode(DEFAULT_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setSoftMaxQueryTotalMemoryPerNode(DEFAULT_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setHeapHeadroom(DEFAULT_HEAP_HEADROOM).setReservedPoolEnabled(true).setVerboseExceededMemoryLimitErrorsEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)OVERRIDE_MAX_QUERY_MEMORY_PER_NODE.toString()).put((Object)"query.max-broadcast-memory", (Object)OVERRIDE_MAX_QUERY_BROADCAST_MEMORY.toString()).put((Object)"query.soft-max-memory-per-node", (Object)OVERRIDE_SOFT_MAX_QUERY_MEMORY_PER_NODE.toString()).put((Object)"query.max-total-memory-per-node", (Object)OVERRIDE_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toString()).put((Object)"query.soft-max-total-memory-per-node", (Object)OVERRIDE_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toString()).put((Object)"memory.heap-headroom-per-node", (Object)OVERRIDE_HEAP_HEADROOM.toString()).put((Object)"experimental.reserved-pool-enabled", (Object)"false").put((Object)"memory.verbose-exceeded-memory-limit-errors-enabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryBroadcastMemory(OVERRIDE_MAX_QUERY_BROADCAST_MEMORY).setMaxQueryMemoryPerNode(OVERRIDE_MAX_QUERY_MEMORY_PER_NODE).setSoftMaxQueryMemoryPerNode(OVERRIDE_SOFT_MAX_QUERY_MEMORY_PER_NODE).setMaxQueryTotalMemoryPerNode(OVERRIDE_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setSoftMaxQueryTotalMemoryPerNode(OVERRIDE_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setHeapHeadroom(OVERRIDE_HEAP_HEADROOM).setReservedPoolEnabled(false).setVerboseExceededMemoryLimitErrorsEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testOutOfRangeBroadcastMemoryLimit() {
        DataSize invalidBroadcastMemory = new DataSize((double)(OVERRIDE_MAX_QUERY_MEMORY_PER_NODE.toBytes() * 2L), DataSize.Unit.BYTE);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)OVERRIDE_MAX_QUERY_MEMORY_PER_NODE.toString()).put((Object)"query.max-broadcast-memory", (Object)invalidBroadcastMemory.toString()).put((Object)"query.soft-max-memory-per-node", (Object)OVERRIDE_SOFT_MAX_QUERY_MEMORY_PER_NODE.toString()).put((Object)"query.max-total-memory-per-node", (Object)OVERRIDE_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toString()).put((Object)"query.soft-max-total-memory-per-node", (Object)OVERRIDE_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE.toString()).put((Object)"memory.heap-headroom-per-node", (Object)OVERRIDE_HEAP_HEADROOM.toString()).put((Object)"experimental.reserved-pool-enabled", (Object)"false").put((Object)"memory.verbose-exceeded-memory-limit-errors-enabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(OVERRIDE_MAX_QUERY_MEMORY_PER_NODE).setMaxQueryBroadcastMemory(OVERRIDE_MAX_QUERY_MEMORY_PER_NODE).setSoftMaxQueryMemoryPerNode(OVERRIDE_SOFT_MAX_QUERY_MEMORY_PER_NODE).setMaxQueryTotalMemoryPerNode(OVERRIDE_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setSoftMaxQueryTotalMemoryPerNode(OVERRIDE_SOFT_MAX_QUERY_TOTAL_MEMORY_PER_NODE).setHeapHeadroom(OVERRIDE_HEAP_HEADROOM).setReservedPoolEnabled(false).setVerboseExceededMemoryLimitErrorsEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidValues() {
        NodeMemoryConfig config = new NodeMemoryConfig();
        config.setMaxQueryTotalMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        config.setHeapHeadroom(new DataSize(3.1, DataSize.Unit.GIGABYTE));
        LocalMemoryManager.validateHeapHeadroom((NodeMemoryConfig)config, (long)new DataSize(4.0, DataSize.Unit.GIGABYTE).toBytes());
    }
}

