/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQualifiedTablePrefix {
    private static final JsonCodec<QualifiedTablePrefix> CODEC = JsonCodec.jsonCodec(QualifiedTablePrefix.class);

    @Test
    public void testCatalog() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertFalse((boolean)tableName.hasSchemaName());
        Assert.assertFalse((boolean)tableName.hasTableName());
    }

    @Test
    public void testSchema() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertTrue((boolean)tableName.hasSchemaName());
        Assert.assertEquals((String)"schema", (String)((String)tableName.getSchemaName().get()));
        Assert.assertFalse((boolean)tableName.hasTableName());
    }

    @Test
    public void testTable() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema", "table");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertTrue((boolean)tableName.hasSchemaName());
        Assert.assertEquals((String)"schema", (String)((String)tableName.getSchemaName().get()));
        Assert.assertTrue((boolean)tableName.hasTableName());
        Assert.assertEquals((String)"table", (String)((String)tableName.getTableName().get()));
    }

    @Test
    public void testBadTable() {
        try {
            new QualifiedTablePrefix("catalog", null, "table");
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundTrip() {
        QualifiedTablePrefix table = new QualifiedTablePrefix("abc", "xyz", "fgh");
        Assert.assertEquals((Object)CODEC.fromJson(CODEC.toJson((Object)table)), (Object)table);
    }
}

