/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public final class GenericLongFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(GenericLongFunction.class, (String)"apply", (Class[])new Class[]{LongUnaryOperator.class, Long.TYPE});
    private final LongUnaryOperator longUnaryOperator;

    GenericLongFunction(String suffix, LongUnaryOperator longUnaryOperator) {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)("generic_long_" + Objects.requireNonNull(suffix, "suffix is null"))), FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), TypeSignature.parseTypeSignature((String)"bigint"), Collections.singletonList(TypeSignature.parseTypeSignature((String)"bigint")), false));
        this.longUnaryOperator = longUnaryOperator;
    }

    public final SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.HIDDEN;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "generic long function for test";
    }

    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.longUnaryOperator);
        return new BuiltInScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    public static long apply(LongUnaryOperator longUnaryOperator, long value) {
        return longUnaryOperator.applyAsLong(value);
    }
}

