/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriverStats {
    public static final DriverStats EXPECTED = new DriverStats(Lifespan.driverGroup((int)21), 1L, 2L, 3L, new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 6L, 7L, 8L, new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(12.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), 123L, 13L, 14L, new Duration(15.0, TimeUnit.NANOSECONDS), 16L, 17L, 18L, 19L, 20L, (List)ImmutableList.of((Object)TestOperatorStats.NON_MERGEABLE));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DriverStats.class);
        String json = codec.toJson((Object)EXPECTED);
        DriverStats actual = (DriverStats)codec.fromJson(json);
        TestDriverStats.assertExpectedDriverStats(actual);
    }

    public static void assertExpectedDriverStats(DriverStats actual) {
        Assert.assertEquals((Object)actual.getLifespan(), (Object)Lifespan.driverGroup((int)21));
        Assert.assertEquals((long)actual.getCreateTimeInMillis(), (long)new DateTime(1L, DateTimeZone.UTC).getMillis());
        Assert.assertEquals((long)actual.getStartTimeInMillis(), (long)new DateTime(2L, DateTimeZone.UTC).getMillis());
        Assert.assertEquals((long)actual.getEndTimeInMillis(), (long)new DateTime(3L, DateTimeZone.UTC).getMillis());
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)6L);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)7L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)8L);
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getTotalAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)13L);
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)14L);
        Assert.assertEquals((Object)actual.getRawInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getProcessedInputDataSizeInBytes(), (long)16L);
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)17L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)19L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)20L);
        Assert.assertEquals((int)actual.getOperatorStats().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorStats().get(0));
    }
}

