/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicFilterStats {
    private void assertDynamicFilterStatsEquals(DynamicFilterStats d1, DynamicFilterStats d2) {
        Assert.assertEquals((boolean)d1.empty(), (boolean)d2.empty());
        Assert.assertEquals((Set)d1.getProducerNodeIds(), (Set)d2.getProducerNodeIds());
    }

    @Test
    public void testCtor() {
        PlanNodeId[] planNodes = new PlanNodeId[]{new PlanNodeId("1"), new PlanNodeId("2")};
        HashSet<PlanNodeId> planNodeSet = new HashSet<PlanNodeId>(Arrays.asList(planNodes));
        DynamicFilterStats nonEmptyStats = new DynamicFilterStats(planNodeSet);
        Assert.assertFalse((boolean)nonEmptyStats.empty());
        Assert.assertEquals((Set)nonEmptyStats.getProducerNodeIds(), planNodeSet);
        this.assertDynamicFilterStatsEquals(nonEmptyStats, nonEmptyStats);
        PlanNodeId[] emptyPlanNodes = new PlanNodeId[]{};
        HashSet<PlanNodeId> emptyPlanNodeSet = new HashSet<PlanNodeId>(Arrays.asList(emptyPlanNodes));
        DynamicFilterStats emptyStats = new DynamicFilterStats(emptyPlanNodeSet);
        Assert.assertTrue((boolean)emptyStats.empty());
        Assert.assertTrue((boolean)emptyStats.getProducerNodeIds().isEmpty());
        this.assertDynamicFilterStatsEquals(emptyStats, emptyStats);
    }

    @Test
    public void testCopy() {
        PlanNodeId[] planNodes = new PlanNodeId[]{new PlanNodeId("1"), new PlanNodeId("2")};
        HashSet<PlanNodeId> planNodeSet = new HashSet<PlanNodeId>(Arrays.asList(planNodes));
        DynamicFilterStats stats = new DynamicFilterStats(planNodeSet);
        DynamicFilterStats statsCopy = DynamicFilterStats.copyOf((DynamicFilterStats)stats);
        this.assertDynamicFilterStatsEquals(stats, statsCopy);
        Assert.assertFalse((boolean)statsCopy.empty());
        Assert.assertEquals((Set)statsCopy.getProducerNodeIds(), planNodeSet);
        PlanNodeId[] emptyPlanNodes = new PlanNodeId[]{};
        HashSet<PlanNodeId> emptyPlanNodeSet = new HashSet<PlanNodeId>(Arrays.asList(emptyPlanNodes));
        DynamicFilterStats emptyStats = new DynamicFilterStats(emptyPlanNodeSet);
        DynamicFilterStats emptyStatsCopy = DynamicFilterStats.copyOf((DynamicFilterStats)emptyStats);
        this.assertDynamicFilterStatsEquals(emptyStats, emptyStatsCopy);
        Assert.assertTrue((boolean)emptyStatsCopy.empty());
        Assert.assertTrue((boolean)emptyStatsCopy.getProducerNodeIds().isEmpty());
    }

    @Test
    public void testMergeWith() {
        PlanNodeId[] planNodes1 = new PlanNodeId[]{new PlanNodeId("1"), new PlanNodeId("2")};
        HashSet<PlanNodeId> planNodeSet1 = new HashSet<PlanNodeId>(Arrays.asList(planNodes1));
        DynamicFilterStats stats1 = new DynamicFilterStats(planNodeSet1);
        Assert.assertEquals((Set)stats1.getProducerNodeIds(), planNodeSet1);
        PlanNodeId[] planNodes2 = new PlanNodeId[]{new PlanNodeId("2"), new PlanNodeId("3")};
        HashSet<PlanNodeId> planNodeSet2 = new HashSet<PlanNodeId>(Arrays.asList(planNodes2));
        DynamicFilterStats stats2 = new DynamicFilterStats(planNodeSet2);
        Assert.assertEquals((Set)stats2.getProducerNodeIds(), planNodeSet2);
        stats2.mergeWith(stats1);
        Assert.assertEquals((Set)stats1.getProducerNodeIds(), planNodeSet1);
        ImmutableSet expectedMergeNodeSet = ImmutableSet.of((Object)new PlanNodeId("1"), (Object)new PlanNodeId("2"), (Object)new PlanNodeId("3"));
        Assert.assertEquals((Set)stats2.getProducerNodeIds(), (Set)expectedMergeNodeSet);
        Assert.assertFalse((boolean)stats2.empty());
        PlanNodeId[] emptyPlanNodes = new PlanNodeId[]{};
        HashSet<PlanNodeId> emptyPlanNodeSet = new HashSet<PlanNodeId>(Arrays.asList(emptyPlanNodes));
        DynamicFilterStats emptyStats1 = new DynamicFilterStats(emptyPlanNodeSet);
        DynamicFilterStats emptyStats2 = new DynamicFilterStats(emptyPlanNodeSet);
        emptyStats2.mergeWith(emptyStats1);
        Assert.assertTrue((boolean)emptyStats2.empty());
        Assert.assertTrue((boolean)emptyStats1.empty());
        Assert.assertTrue((boolean)emptyStats1.getProducerNodeIds().isEmpty());
        Assert.assertTrue((boolean)emptyStats2.getProducerNodeIds().isEmpty());
    }

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DynamicFilterStats.class);
        PlanNodeId[] planNodes = new PlanNodeId[]{new PlanNodeId("1"), new PlanNodeId("b")};
        DynamicFilterStats expect = new DynamicFilterStats(new HashSet<PlanNodeId>(Arrays.asList(planNodes)));
        String json = codec.toJson((Object)expect);
        DynamicFilterStats actual = (DynamicFilterStats)codec.fromJson(json);
        this.assertDynamicFilterStatsEquals(actual, expect);
    }
}

