/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DummySpillerFactory;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashAggregationOperatorInSegmentedAggregationMode {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final JavaAggregationFunctionImplementation COUNT = FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("count", (List)ImmutableList.of()));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
    private HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0, (Object)1), (List)ImmutableList.of((Object)0), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)COUNT, (List)ImmutableList.of((Object)2), Optional.empty())), Optional.empty(), Optional.empty(), 4, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), false, Optional.empty(), new DataSize(16.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), (SpillerFactory)new DummySpillerFactory(), this.joinCompiler, false);

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSegmentedAggregationSinglePage() {
        int numberOfRows = 10;
        LongArrayBlock sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L, 3L});
        LongArrayBlock groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 2L, 1L, 2L, 2L, 1L, 2L, 1L});
        LongArrayBlock countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L});
        Page inputPage = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        DriverContext driverContext = this.createDriverContext();
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        expectedBuilder.row(new Object[]{1L, 1L, 3L});
        expectedBuilder.row(new Object[]{2L, 1L, 1L});
        expectedBuilder.row(new Object[]{2L, 2L, 2L});
        expectedBuilder.row(new Object[]{3L, 1L, 2L});
        expectedBuilder.row(new Object[]{3L, 2L, 2L});
        MaterializedResult expected = expectedBuilder.build();
        List<Page> outputPages = OperatorAssertion.toPages((OperatorFactory)this.operatorFactory, driverContext, (List<Page>)ImmutableList.of((Object)inputPage));
        Assert.assertEquals((int)outputPages.size(), (int)2);
        OperatorAssertion.assertPagesEqualIgnoreOrder(driverContext, outputPages, expected, true, Optional.empty());
    }

    @Test
    public void testSegmentedAggregationSingleSegment() {
        int numberOfRows = 5;
        LongArrayBlock sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 1L, 1L});
        LongArrayBlock groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        LongArrayBlock countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage1 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 1L, 1L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage2 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 1L, 1L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage3 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        DriverContext driverContext = this.createDriverContext();
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        expectedBuilder.row(new Object[]{1L, 1L, 9L});
        expectedBuilder.row(new Object[]{1L, 2L, 6L});
        MaterializedResult expected = expectedBuilder.build();
        List<Page> outputPages = OperatorAssertion.toPages((OperatorFactory)this.operatorFactory, driverContext, (List<Page>)ImmutableList.of((Object)inputPage1, (Object)inputPage2, (Object)inputPage3));
        Assert.assertEquals((int)outputPages.size(), (int)1);
        OperatorAssertion.assertPagesEqualIgnoreOrder(driverContext, outputPages, expected, true, Optional.empty());
    }

    @Test
    public void testSegmentedAggregationMultiplePages() {
        int numberOfRows = 5;
        LongArrayBlock sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 1L, 1L, 2L, 2L});
        LongArrayBlock groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        LongArrayBlock countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage1 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{2L, 2L, 2L, 2L, 2L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage2 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{2L, 2L, 3L, 3L, 4L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage3 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{5L, 5L, 5L, 5L, 5L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage4 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        sortedBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{5L, 6L, 7L, 8L, 8L});
        groupingBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 1L, 2L, 1L});
        countBlock = new LongArrayBlock(numberOfRows, Optional.of(new boolean[numberOfRows]), new long[]{1L, 2L, 3L, 4L, 5L});
        Page inputPage5 = new Page(new Block[]{sortedBlock, groupingBlock, countBlock});
        DriverContext driverContext = this.createDriverContext();
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        expectedBuilder.row(new Object[]{1L, 1L, 2L});
        expectedBuilder.row(new Object[]{1L, 2L, 1L});
        expectedBuilder.row(new Object[]{2L, 1L, 5L});
        expectedBuilder.row(new Object[]{2L, 2L, 4L});
        expectedBuilder.row(new Object[]{3L, 1L, 1L});
        expectedBuilder.row(new Object[]{3L, 2L, 1L});
        expectedBuilder.row(new Object[]{4L, 1L, 1L});
        expectedBuilder.row(new Object[]{5L, 1L, 4L});
        expectedBuilder.row(new Object[]{5L, 2L, 2L});
        expectedBuilder.row(new Object[]{6L, 2L, 1L});
        expectedBuilder.row(new Object[]{7L, 1L, 1L});
        expectedBuilder.row(new Object[]{8L, 1L, 1L});
        expectedBuilder.row(new Object[]{8L, 2L, 1L});
        MaterializedResult expected = expectedBuilder.build();
        List<Page> outputPages = OperatorAssertion.toPages((OperatorFactory)this.operatorFactory, driverContext, (List<Page>)ImmutableList.of((Object)inputPage1, (Object)inputPage2, (Object)inputPage3, (Object)inputPage4, (Object)inputPage5));
        Assert.assertEquals((int)outputPages.size(), (int)5);
        OperatorAssertion.assertPagesEqualIgnoreOrder(driverContext, outputPages, expected, true, Optional.empty());
    }

    private DriverContext createDriverContext() {
        return this.createDriverContext(Integer.MAX_VALUE);
    }

    private DriverContext createDriverContext(long memoryLimit) {
        return TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(DataSize.succinctBytes((long)memoryLimit)).build().addPipelineContext(0, true, true, false).addDriverContext();
    }
}

