/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperatorStats {
    private static final SplitOperatorInfo NON_MERGEABLE_INFO = new SplitOperatorInfo((Object)"some_info");
    private static final PartitionedOutputInfo MERGEABLE_INFO = new PartitionedOutputInfo(1L, 2L, 1024L);
    private static final String TEST_METRIC_NAME = "test_metric";
    private static final RuntimeMetric TEST_RUNTIME_METRIC_1 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 10L, 2L, 9L, 1L);
    private static final RuntimeMetric TEST_RUNTIME_METRIC_2 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 5L, 2L, 3L, 2L);
    private static final DynamicFilterStats TEST_DYNAMIC_FILTER_STATS_1 = new DynamicFilterStats(new HashSet<PlanNodeId>(Arrays.asList(new PlanNodeId("1"), new PlanNodeId("2"))));
    private static final DynamicFilterStats TEST_DYNAMIC_FILTER_STATS_2 = new DynamicFilterStats(new HashSet<PlanNodeId>(Arrays.asList(new PlanNodeId("2"), new PlanNodeId("3"))));
    public static final OperatorStats NON_MERGEABLE = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), 234L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), 123L, 5L, 10L, 6L, 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), 234L, 12L, 13L, 14L, new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), 345L, Long.MAX_VALUE, 20L, 21L, 22L, 23L, 24L, 25L, Optional.empty(), (OperatorInfo)NON_MERGEABLE_INFO, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_1))), TEST_DYNAMIC_FILTER_STATS_1, 0L, 0L, 0L, 0L);
    public static final OperatorStats MERGEABLE = new OperatorStats(0, 10, 1, 41, new PlanNodeId("test"), "test", 1L, 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), 234L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), 123L, 5L, 10L, 6L, 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), 234L, 12L, 13L, 14L, new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), 345L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, Optional.empty(), (OperatorInfo)MERGEABLE_INFO, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_2))), TEST_DYNAMIC_FILTER_STATS_2, 0L, 0L, 0L, 0L);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)NON_MERGEABLE);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    private static void assertRuntimeMetricEquals(RuntimeMetric m1, RuntimeMetric m2) {
        Assert.assertEquals((String)m1.getName(), (String)m2.getName());
        Assert.assertEquals((long)m1.getSum(), (long)m2.getSum());
        Assert.assertEquals((long)m1.getCount(), (long)m2.getCount());
        Assert.assertEquals((long)m1.getMax(), (long)m2.getMax());
        Assert.assertEquals((long)m1.getMin(), (long)m2.getMin());
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)1L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)2L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)5L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)6L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)7L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)8.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)9L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)234L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)12L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)13L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)14L);
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)16L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)345L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)20L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)21L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)25L);
        Assert.assertEquals(actual.getInfo().getClass(), SplitOperatorInfo.class);
        Assert.assertEquals((Object)((SplitOperatorInfo)actual.getInfo()).getSplitInfo(), (Object)NON_MERGEABLE_INFO.getSplitInfo());
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), TEST_RUNTIME_METRIC_1);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testAddMixedStartingWithMergeable() {
        OperatorStats actual = (OperatorStats)OperatorStats.merge((List)ImmutableList.of((Object)MERGEABLE, (Object)NON_MERGEABLE, (Object)NON_MERGEABLE)).get();
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)369L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)15L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)702L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)36L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)42L);
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)1035L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)60L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)63L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)75L);
        Assert.assertNotNull((Object)actual.getInfo());
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_2, (RuntimeMetric)TEST_RUNTIME_METRIC_1);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_1);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        DynamicFilterStats expectedDynamicFilterStats = DynamicFilterStats.copyOf((DynamicFilterStats)TEST_DYNAMIC_FILTER_STATS_1);
        expectedDynamicFilterStats.mergeWith(TEST_DYNAMIC_FILTER_STATS_2);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)expectedDynamicFilterStats.getProducerNodeIds());
    }

    @Test
    public void testSingleNonMergeable() {
        OperatorStats actual = (OperatorStats)OperatorStats.merge((List)ImmutableList.of((Object)NON_MERGEABLE)).get();
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)1L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)2L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)5L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)6L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)7L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)8.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)9L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)234L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)12L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)13L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)14L);
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(100.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)16L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)345L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)20L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)21L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)25L);
        Assert.assertNotNull((Object)actual.getInfo());
        RuntimeMetric expectedMetric = TEST_RUNTIME_METRIC_1;
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        DynamicFilterStats expectedDynamicFilterStats = TEST_DYNAMIC_FILTER_STATS_1;
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testAddMixedStartingWithNonMergeable() {
        OperatorStats actual = (OperatorStats)OperatorStats.merge((List)ImmutableList.of((Object)NON_MERGEABLE, (Object)MERGEABLE, (Object)MERGEABLE)).get();
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)369L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)15L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)702L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)36L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)42L);
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)1035L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)60L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)63L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)75L);
        Assert.assertNull((Object)actual.getInfo());
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_1, (RuntimeMetric)TEST_RUNTIME_METRIC_2);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_2);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        DynamicFilterStats expectedDynamicFilterStats = DynamicFilterStats.copyOf((DynamicFilterStats)TEST_DYNAMIC_FILTER_STATS_1);
        expectedDynamicFilterStats.mergeWith(TEST_DYNAMIC_FILTER_STATS_2);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testAddNonMergeable() {
        OperatorStats actual = (OperatorStats)OperatorStats.merge((List)ImmutableList.of((Object)NON_MERGEABLE, (Object)NON_MERGEABLE, (Object)NON_MERGEABLE)).get();
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)369L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)15L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)702L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)36L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)42L);
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)1035L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)60L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)63L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)75L);
        Assert.assertNull((Object)actual.getInfo());
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_1, (RuntimeMetric)TEST_RUNTIME_METRIC_1);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_1);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_1.getProducerNodeIds());
    }

    @Test
    public void testMergeWithMergeableInfo() {
        OperatorStats actual = (OperatorStats)OperatorStats.merge((List)ImmutableList.of((Object)MERGEABLE, (Object)MERGEABLE, (Object)MERGEABLE)).get();
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getStageExecutionId(), (int)10);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getAddInputAllocationInBytes(), (long)369L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)15L);
        Assert.assertEquals((long)actual.getInputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((double)actual.getSumSquaredInputPositions(), (double)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getGetOutputAllocationInBytes(), (long)702L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)36L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)42L);
        Assert.assertEquals((Object)actual.getAdditionalCpu(), (Object)new Duration(300.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishAllocationInBytes(), (long)1035L);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)57L);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)60L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)63L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)22L);
        Assert.assertEquals((long)actual.getPeakSystemMemoryReservationInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryReservationInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getSpilledDataSizeInBytes(), (long)75L);
        Assert.assertEquals(actual.getInfo().getClass(), PartitionedOutputInfo.class);
        Assert.assertEquals((long)((PartitionedOutputInfo)actual.getInfo()).getPagesAdded(), (long)(3L * MERGEABLE_INFO.getPagesAdded()));
        RuntimeMetric expectedMetric = RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_2, (RuntimeMetric)TEST_RUNTIME_METRIC_2);
        expectedMetric.mergeWith(TEST_RUNTIME_METRIC_2);
        TestOperatorStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), expectedMetric);
        Assert.assertEquals((Set)actual.getDynamicFilterStats().getProducerNodeIds(), (Set)TEST_DYNAMIC_FILTER_STATS_2.getProducerNodeIds());
    }

    @Test
    public void testMergeEmptyCollection() {
        Optional merged = OperatorStats.merge((List)ImmutableList.of());
        Assert.assertFalse((boolean)merged.isPresent());
    }
}

