/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PageSinkCommitStrategy;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TableFinishInfo;
import com.facebook.presto.operator.TableFinishOperator;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTableFinishOperator {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final JavaAggregationFunctionImplementation LONG_MAX = FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private static final JsonCodec<TableCommitContext> TABLE_COMMIT_CONTEXT_CODEC = JsonCodec.jsonCodec(TableCommitContext.class);
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test
    public void testStatisticsAggregation() throws Exception {
        TestingTableFinisher tableFinisher = new TestingTableFinisher();
        TestingPageSinkCommitter pageSinkCommitter = new TestingPageSinkCommitter();
        ColumnStatisticMetadata statisticMetadata = ColumnStatisticType.MAX_VALUE.getColumnStatisticMetadata("column");
        StatisticAggregationsDescriptor descriptor = new StatisticAggregationsDescriptor((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)statisticMetadata, (Object)0));
        Session session = TestingSession.testSessionBuilder().setSystemProperty("statistics_cpu_timer_enabled", "true").build();
        TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(0, new PlanNodeId("node"), (TableFinishOperator.TableFinisher)tableFinisher, (TableFinishOperator.PageSinkCommitter)pageSinkCommitter, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_MAX, (List)ImmutableList.of((Object)3), Optional.empty())), true), descriptor, session, TABLE_COMMIT_CONTEXT_CODEC, false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.scheduledExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
        TableFinishOperator operator = (TableFinishOperator)operatorFactory.createOperator(driverContext);
        ImmutableList inputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        byte[] tableCommitContextForStatsPage = TestTableFinishOperator.getTableCommitContextBytes(Lifespan.taskWide(), 0, 0, PageSinkCommitStrategy.NO_COMMIT, false);
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, tableCommitContextForStatsPage, 6).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, tableCommitContextForStatsPage, 7).build().get(0));
        byte[] tableCommitContextForFragmentsPage = TestTableFinishOperator.getTableCommitContextBytes(Lifespan.taskWide(), 0, 0, PageSinkCommitStrategy.NO_COMMIT, true);
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(4, new byte[]{1}, tableCommitContextForFragmentsPage, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(5, new byte[]{2}, tableCommitContextForFragmentsPage, null).build().get(0));
        Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertNull((Object)operator.getOutput());
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(9).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertTrue((boolean)operator.isFinished());
        operator.close();
        Assert.assertEquals(tableFinisher.getFragments(), (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])new byte[]{1}), (Object)Slices.wrappedBuffer((byte[])new byte[]{2})));
        Assert.assertEquals((int)tableFinisher.getComputedStatistics().size(), (int)1);
        Assert.assertEquals((int)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().size(), (int)1);
        Block expectedStatisticsBlock = new LongArrayBlockBuilder(null, 1).writeLong(7L).closeEntry().build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, (Block)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().get(statisticMetadata), expectedStatisticsBlock);
        TableFinishInfo tableFinishInfo = operator.getInfo();
        Assertions.assertThat((double)tableFinishInfo.getStatisticsWallTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assertions.assertThat((double)tableFinishInfo.getStatisticsCpuTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assert.assertTrue((boolean)pageSinkCommitter.getCommittedFragments().isEmpty());
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    @Test
    public void testTableWriteCommit() throws Exception {
        TestingTableFinisher tableFinisher = new TestingTableFinisher();
        TestingPageSinkCommitter pageSinkCommitter = new TestingPageSinkCommitter();
        ColumnStatisticMetadata statisticMetadata = ColumnStatisticType.MAX_VALUE.getColumnStatisticMetadata("column");
        StatisticAggregationsDescriptor descriptor = new StatisticAggregationsDescriptor((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)statisticMetadata, (Object)0));
        Session session = TestingSession.testSessionBuilder().setSystemProperty("statistics_cpu_timer_enabled", "true").build();
        TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(0, new PlanNodeId("node"), (TableFinishOperator.TableFinisher)tableFinisher, (TableFinishOperator.PageSinkCommitter)pageSinkCommitter, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_MAX, (List)ImmutableList.of((Object)3), Optional.empty())), true), descriptor, session, TABLE_COMMIT_CONTEXT_CODEC, false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.scheduledExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
        TableFinishOperator operator = (TableFinishOperator)operatorFactory.createOperator(driverContext);
        ImmutableList inputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.taskWide(), 0, 0, PageSinkCommitStrategy.NO_COMMIT, false), 1).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(3, new byte[]{2}, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.taskWide(), 0, 0, PageSinkCommitStrategy.NO_COMMIT, true), null).build().get(0));
        Assert.assertTrue((boolean)pageSinkCommitter.getCommittedFragments().isEmpty());
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.driverGroup((int)1), 1, 1, PageSinkCommitStrategy.NO_COMMIT, false), 4).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(6, new byte[]{5}, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.driverGroup((int)1), 1, 1, PageSinkCommitStrategy.NO_COMMIT, true), null).build().get(0));
        Assert.assertTrue((boolean)pageSinkCommitter.getCommittedFragments().isEmpty());
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.driverGroup((int)2), 2, 2, PageSinkCommitStrategy.LIFESPAN_COMMIT, false), 100).build().get(0));
        Assert.assertTrue((boolean)pageSinkCommitter.getCommittedFragments().isEmpty());
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.driverGroup((int)2), 2, 3, PageSinkCommitStrategy.LIFESPAN_COMMIT, false), 9).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(11, new byte[]{10}, TestTableFinishOperator.getTableCommitContextBytes(Lifespan.driverGroup((int)2), 2, 3, PageSinkCommitStrategy.LIFESPAN_COMMIT, true), null).build().get(0));
        Assert.assertEquals((Collection)((Collection)Iterables.getOnlyElement(pageSinkCommitter.getCommittedFragments())), (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])new byte[]{10})));
        Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertNull((Object)operator.getOutput());
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(20).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertTrue((boolean)operator.isFinished());
        operator.close();
        Assert.assertEquals(tableFinisher.getFragments(), (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])new byte[]{2}), (Object)Slices.wrappedBuffer((byte[])new byte[]{5}), (Object)Slices.wrappedBuffer((byte[])new byte[]{10})));
        Assert.assertEquals((int)tableFinisher.getComputedStatistics().size(), (int)1);
        Assert.assertEquals((int)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().size(), (int)1);
        Block expectedStatisticsBlock = new LongArrayBlockBuilder(null, 1).writeLong(9L).closeEntry().build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, (Block)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().get(statisticMetadata), expectedStatisticsBlock);
        TableFinishInfo tableFinishInfo = operator.getInfo();
        Assertions.assertThat((double)tableFinishInfo.getStatisticsWallTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assertions.assertThat((double)tableFinishInfo.getStatisticsCpuTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    private static byte[] getTableCommitContextBytes(Lifespan lifespan, int stageId, int taskId, PageSinkCommitStrategy pageSinkCommitStrategy, boolean lastPage) {
        return TABLE_COMMIT_CONTEXT_CODEC.toJsonBytes((Object)new TableCommitContext(lifespan, new TaskId("query", stageId, 0, taskId, 0), pageSinkCommitStrategy, lastPage));
    }

    private static class TestingTableFinisher
    implements TableFinishOperator.TableFinisher {
        private boolean finished;
        private Collection<Slice> fragments;
        private Collection<ComputedStatistics> computedStatistics;

        private TestingTableFinisher() {
        }

        public Optional<ConnectorOutputMetadata> finishTable(Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
            this.finished = true;
            this.fragments = fragments;
            this.computedStatistics = computedStatistics;
            return Optional.empty();
        }

        public Collection<Slice> getFragments() {
            return this.fragments;
        }

        public Collection<ComputedStatistics> getComputedStatistics() {
            return this.computedStatistics;
        }
    }

    private static class TestingPageSinkCommitter
    implements TableFinishOperator.PageSinkCommitter {
        private List<Collection<Slice>> fragmentsList = new ArrayList<Collection<Slice>>();

        private TestingPageSinkCommitter() {
        }

        public ListenableFuture<Void> commitAsync(Collection<Slice> fragments) {
            this.fragmentsList.add(fragments);
            return Futures.immediateFuture(null);
        }

        public List<Collection<Slice>> getCommittedFragments() {
            return this.fragmentsList;
        }
    }
}

