/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestDoubleRegrAggregationFunction;
import com.google.common.base.Preconditions;

public class TestDoubleRegrAvgxAggregation
extends AbstractTestDoubleRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_avgx";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double expected = 0.0;
        for (int i = start; i < start + length; ++i) {
            expected += (double)(i + 2);
        }
        return expected / (double)length;
    }

    @Override
    protected void testNonTrivialAggregation(Double[] y, Double[] x) {
        double expected = 0.0;
        for (int i = 0; i < x.length; ++i) {
            expected += x[i].doubleValue();
        }
        Preconditions.checkArgument((Double.isFinite(expected /= (double)x.length) && expected != 0.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }
}

