/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.type.BigintOperators;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOptimizedTypedSet {
    private static final int POSITIONS_PER_PAGE = 100;
    private static final MethodHandle BIGINT_DISTINCT_METHOD_HANDLE = MethodHandleUtil.methodHandle(BigintOperators.BigintDistinctFromOperator.class, (String)"isDistinctFrom", (Class[])new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE});

    @Test
    public void testConstructor() {
        for (int i = -2; i <= -1; ++i) {
            try {
                new OptimizedTypedSet((Type)BigintType.BIGINT, Optional.of(BIGINT_DISTINCT_METHOD_HANDLE), 2, i);
                Assert.fail((String)"Should throw exception if expectedSize < 0");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            new OptimizedTypedSet(null, Optional.of(BIGINT_DISTINCT_METHOD_HANDLE), -1, 1);
            Assert.fail((String)"Should throw exception if expectedBlockCount is negative");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            new OptimizedTypedSet(null, Optional.of(BIGINT_DISTINCT_METHOD_HANDLE), 2, 1);
            Assert.fail((String)"Should throw exception if type is null");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testUnionWithDistinctValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 101);
        Block block = BlockAssertions.createLongSequenceBlock(0, 50);
        this.testUnion(typedSet, block, block);
        block = BlockAssertions.createLongSequenceBlock(0, 100);
        this.testUnion(typedSet, BlockAssertions.createLongSequenceBlock(50, 100), block);
        Block blockWithNull = block.appendNull();
        this.testUnion(typedSet, blockWithNull, blockWithNull);
    }

    @Test
    public void testUnionWithRepeatingValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        Block block = BlockAssertions.createLongRepeatBlock(0, 100);
        Block expectedBlock = BlockAssertions.createLongRepeatBlock(0, 1);
        this.testUnion(typedSet, block, expectedBlock);
        Block blockWithNull = block.appendNull();
        expectedBlock = expectedBlock.appendNull();
        this.testUnion(typedSet, blockWithNull, expectedBlock);
    }

    @Test
    public void testIntersectWithEmptySet() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        this.testIntersect(typedSet, BlockAssertions.createLongSequenceBlock(0, 99).appendNull(), BlockAssertions.createEmptyBlock((Type)BigintType.BIGINT));
    }

    @Test
    public void testIntersectWithDistinctValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        Block block = BlockAssertions.createLongSequenceBlock(0, 99).appendNull();
        typedSet.union(block);
        this.testIntersect(typedSet, block, block);
        block = BlockAssertions.createLongSequenceBlock(0, 49).appendNull();
        this.testIntersect(typedSet, block, block);
        block = BlockAssertions.createLongSequenceBlock(0, 1).appendNull();
        this.testIntersect(typedSet, block, block);
    }

    @Test
    public void testIntersectWithNonDistinctValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        Block block = BlockAssertions.createLongSequenceBlock(0, 99).appendNull();
        typedSet.union(block);
        block = BlockAssertions.createLongRepeatBlock(0, 99).appendNull();
        this.testIntersect(typedSet, block, BlockAssertions.createLongSequenceBlock(0, 1).appendNull());
        block = BlockAssertions.createLongSequenceBlock(0, 0).appendNull();
        this.testIntersect(typedSet, block, block);
        block = BlockAssertions.createLongSequenceBlock(0, 0);
        this.testIntersect(typedSet, block, block);
    }

    @Test
    public void testExceptWithDistinctValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        Block block = BlockAssertions.createLongSequenceBlock(0, 99).appendNull();
        typedSet.union(block);
        this.testExcept(typedSet, block, BlockAssertions.createEmptyBlock((Type)BigintType.BIGINT));
        this.testExcept(typedSet, block, block);
    }

    @Test
    public void testExceptWithRepeatingValues() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 100);
        Block block = BlockAssertions.createLongRepeatBlock(0, 99).appendNull();
        this.testExcept(typedSet, block, BlockAssertions.createLongSequenceBlock(0, 1).appendNull());
    }

    @Test
    public void testMultipleOperations() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 101);
        Block block = BlockAssertions.createLongSequenceBlock(0, 50).appendNull();
        this.testUnion(typedSet, block, block);
        this.testIntersect(typedSet, block, block);
        block = BlockAssertions.createLongSequenceBlock(50, 100);
        this.testExcept(typedSet, block.appendNull(), block);
        this.testExcept(typedSet, BlockAssertions.createLongSequenceBlock(0, 100), BlockAssertions.createLongSequenceBlock(0, 50));
        this.testUnion(typedSet, block, BlockAssertions.createLongSequenceBlock(0, 100));
        this.testIntersect(typedSet, BlockAssertions.createEmptyBlock((Type)BigintType.BIGINT).appendNull(), BlockAssertions.createEmptyBlock((Type)BigintType.BIGINT));
    }

    @Test
    public void testNulls() {
        OptimizedTypedSet typedSet = new OptimizedTypedSet((Type)BigintType.BIGINT, BIGINT_DISTINCT_METHOD_HANDLE, 101);
        Block emptyBlock = BlockAssertions.createLongSequenceBlock(0, 0);
        this.testUnion(typedSet, emptyBlock, emptyBlock);
        Block singleNullBlock = emptyBlock.appendNull();
        this.testUnion(typedSet, singleNullBlock, singleNullBlock);
        this.testIntersect(typedSet, singleNullBlock, singleNullBlock);
        this.testIntersect(typedSet, emptyBlock, emptyBlock);
        this.testExcept(typedSet, singleNullBlock, singleNullBlock);
        this.testIntersect(typedSet, emptyBlock, emptyBlock);
        Block zero = BlockAssertions.createLongSequenceBlock(0, 0);
        Block zeroAndNull = zero.appendNull();
        this.testUnion(typedSet, zero, zero);
        this.testUnion(typedSet, singleNullBlock, zeroAndNull);
        this.testIntersect(typedSet, zero, zero);
        this.testExcept(typedSet, singleNullBlock, singleNullBlock);
        this.testUnion(typedSet, zero, zeroAndNull);
    }

    private void testUnion(OptimizedTypedSet typedSet, Block block, Block expectedBlock) {
        typedSet.union(block);
        Block resultBlock = typedSet.getBlock();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, resultBlock, expectedBlock);
    }

    private void testIntersect(OptimizedTypedSet typedSet, Block block, Block expectedBlock) {
        typedSet.intersect(block);
        Block resultBlock = typedSet.getBlock();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, resultBlock, expectedBlock);
    }

    private void testExcept(OptimizedTypedSet typedSet, Block block, Block expectedBlock) {
        typedSet.except(block);
        Block resultBlock = typedSet.getBlock();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, resultBlock, expectedBlock);
    }
}

