/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.differentialentropy.EntropyCalculations;
import org.testng.Assert;

abstract class AbstractTestReservoirAggregation
extends AbstractTestAggregationFunction {
    protected static final int MAX_SAMPLES = 500;

    AbstractTestReservoirAggregation() {
    }

    @Override
    protected String getFunctionName() {
        return "differential_entropy";
    }

    @Override
    public Double getExpectedValue(int start, int length) {
        Assert.assertTrue((2 * length < 500 ? 1 : 0) != 0);
        double[] samples = new double[2 * length];
        for (int i = 0; i < length; ++i) {
            samples[i] = start + i;
            samples[i + length] = start + i;
        }
        return EntropyCalculations.calculateFromSamplesUsingVasicek((double[])samples);
    }
}

