/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.AbstractTestNoisySfmAggregation;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.type.IntegerOperators;
import java.util.Objects;
import java.util.function.BiFunction;
import org.testng.annotations.Test;

public class TestNoisyApproximateSetSfmFromIndexAndZerosAggregation
extends AbstractTestNoisySfmAggregation {
    @Override
    protected String getFunctionName() {
        return "noisy_approx_set_sfm_from_index_and_zeros";
    }

    @Override
    protected long getCardinalityFromResult(Object result) {
        return this.getSketchFromResult(result).cardinality();
    }

    private boolean sketchSizesMatch(Object a, Object b) {
        SfmSketch sketchA = this.getSketchFromResult(a);
        SfmSketch sketchB = this.getSketchFromResult(b);
        return sketchA.getBitmap().length() == sketchB.getBitmap().length();
    }

    public static Block createLongSequenceIndexBlock(int start, int end, int indexBits) {
        int shift = 64 - indexBits;
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            long h = IntegerOperators.xxHash64((long)i);
            BigintType.BIGINT.writeLong(builder, h >>> shift);
        }
        return builder.build();
    }

    public static Block createLongSequenceZerosBlock(int start, int end, int indexBits, int precision) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(end - start);
        precision = Math.min(precision - 1, 64 - indexBits);
        for (int i = start; i < end; ++i) {
            long h = IntegerOperators.xxHash64((long)i);
            BigintType.BIGINT.writeLong(builder, (long)Math.min(Long.numberOfTrailingZeros(h), precision));
        }
        return builder.build();
    }

    protected void assertFunction(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, int precision, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        assert (valuesBlock1.getPositionCount() == valuesBlock2.getPositionCount());
        AggregationTestUtils.assertAggregation(TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType1, valueType2, DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}), assertion, null, new Page(new Block[]{valuesBlock1, valuesBlock2, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock1.getPositionCount()), BlockAssertions.createLongRepeatBlock(numberOfBuckets, valuesBlock1.getPositionCount()), BlockAssertions.createLongRepeatBlock(precision, valuesBlock1.getPositionCount())}), expected);
    }

    protected void assertFunction(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        assert (valuesBlock1.getPositionCount() == valuesBlock2.getPositionCount());
        AggregationTestUtils.assertAggregation(TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType1, valueType2, DoubleType.DOUBLE, BigintType.BIGINT}), assertion, null, new Page(new Block[]{valuesBlock1, valuesBlock2, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock1.getPositionCount()), BlockAssertions.createLongRepeatBlock(numberOfBuckets, valuesBlock1.getPositionCount())}), expected);
    }

    protected void assertFunction(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        assert (valuesBlock1.getPositionCount() == valuesBlock2.getPositionCount());
        AggregationTestUtils.assertAggregation(TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType1, valueType2, DoubleType.DOUBLE}), assertion, null, new Page(new Block[]{valuesBlock1, valuesBlock2, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock1.getPositionCount())}), expected);
    }

    protected void assertEquivalence(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, Object expected) {
        this.assertFunction(valuesBlock1, valueType1, valuesBlock2, valueType2, epsilon, numberOfBuckets, Objects::equals, expected);
    }

    protected void assertCardinality(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, int precision, Object expected, long delta) {
        this.assertFunction(valuesBlock1, valueType1, valuesBlock2, valueType2, epsilon, numberOfBuckets, precision, (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), expected);
    }

    protected void assertCardinality(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, Object expected, long delta) {
        this.assertFunction(valuesBlock1, valueType1, valuesBlock2, valueType2, epsilon, numberOfBuckets, (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), expected);
    }

    private void assertSketchSize(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, int precision, SqlVarbinary expected) {
        this.assertFunction(valuesBlock1, valueType1, valuesBlock2, valueType2, epsilon, numberOfBuckets, precision, this::sketchSizesMatch, expected);
    }

    private void assertSketchSize(Block valuesBlock1, Type valueType1, Block valuesBlock2, Type valueType2, double epsilon, int numberOfBuckets, SqlVarbinary expected) {
        this.assertFunction(valuesBlock1, valueType1, valuesBlock2, valueType2, epsilon, numberOfBuckets, this::sketchSizesMatch, expected);
    }

    @Test
    public void testSfmEquivalence() {
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createLongSketch(8192, 24, 1, 100000));
        Block indexValuesBlock = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceIndexBlock(1, 100000, 13);
        Block zerosValuesBlock = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceZerosBlock(1, 100000, 13, 24);
        this.assertEquivalence(indexValuesBlock, (Type)BigintType.BIGINT, zerosValuesBlock, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, refSketch);
    }

    @Test
    public void testNonPrivateInteger() {
        Block indexValuesBlockBits13 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceIndexBlock(1, 100000, 13);
        Block zerosValuesBlockBits13 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceZerosBlock(1, 100000, 13, 24);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createLongSketch(8192, 24, 1, 100000));
        this.assertCardinality(indexValuesBlockBits13, (Type)BigintType.BIGINT, zerosValuesBlockBits13, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, refSketch, 0L);
        this.assertSketchSize(indexValuesBlockBits13, (Type)BigintType.BIGINT, zerosValuesBlockBits13, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 8192, refSketch);
        Block indexValuesBlockBits11 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceIndexBlock(1, 100000, 11);
        Block zerosValuesBlockBits11 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceZerosBlock(1, 100000, 11, 32);
        refSketch = this.toSqlVarbinary(this.createLongSketch(2048, 32, 1, 100000));
        this.assertCardinality(indexValuesBlockBits11, (Type)BigintType.BIGINT, zerosValuesBlockBits11, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 2048, 32, refSketch, 0L);
        this.assertSketchSize(indexValuesBlockBits11, (Type)BigintType.BIGINT, zerosValuesBlockBits11, (Type)BigintType.BIGINT, Double.POSITIVE_INFINITY, 2048, 32, refSketch);
    }

    @Test
    public void testPrivateInteger() {
        Block indexValuesBlockBits13 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceIndexBlock(1, 100000, 13);
        Block zerosValuesBlockBits13 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceZerosBlock(1, 100000, 13, 24);
        SqlVarbinary refSketch = this.toSqlVarbinary(this.createLongSketch(8192, 24, 1, 100000));
        this.assertCardinality(indexValuesBlockBits13, (Type)BigintType.BIGINT, zerosValuesBlockBits13, (Type)BigintType.BIGINT, 8.0, 8192, refSketch, 50000L);
        this.assertSketchSize(indexValuesBlockBits13, (Type)BigintType.BIGINT, zerosValuesBlockBits13, (Type)BigintType.BIGINT, 8.0, 8192, refSketch);
        Block indexValuesBlockBits11 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceIndexBlock(1, 100000, 11);
        Block zerosValuesBlockBits11 = TestNoisyApproximateSetSfmFromIndexAndZerosAggregation.createLongSequenceZerosBlock(1, 100000, 11, 32);
        refSketch = this.toSqlVarbinary(this.createLongSketch(2048, 32, 1, 100000));
        this.assertCardinality(indexValuesBlockBits11, (Type)BigintType.BIGINT, zerosValuesBlockBits11, (Type)BigintType.BIGINT, 8.0, 2048, 32, refSketch, 50000L);
        this.assertSketchSize(indexValuesBlockBits11, (Type)BigintType.BIGINT, zerosValuesBlockBits11, (Type)BigintType.BIGINT, 8.0, 2048, 32, refSketch);
    }
}

