/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.TestNoisyAggregationUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNoisyAvgGaussianRealAggregation
extends AbstractTestFunctions {
    private static final String FUNCTION_NAME = "noisy_avg_gaussian";
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testNoisyAvgGaussianRealDefinitions() {
        this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testNoisyAvgGaussianRealInvalidNoiseScale() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, true);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale) with noiseScale < 0 which means errors", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(-123.0, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealZeroNoiseScale() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, true);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealZeroNoiseScaleWithNull() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, true);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale) with noiseScale=0 and 1 null row which means no noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealSomeNoiseScale() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, true);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.notEqualDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale) with noiseScale > 0 which means some noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(1.0, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealSomeNoiseScaleWithinSomeStd() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE});
        int numRows = 1000;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, true);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.withinSomeStdAssertion, "Test noisy_avg_gaussian(real, noiseScale) within some std from mean", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(1.0, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealNoiseScaleVsNormalAvg() {
        int numRows = 10;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("real");
        String query1 = String.format("SELECT AVG(%s) FROM %s", columnName, data);
        String query2 = String.format("SELECT %s(%s, %f) FROM %s", FUNCTION_NAME, columnName, 0.0, data);
        List<MaterializedRow> actualRows = this.runQuery(query1);
        double result1 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        actualRows = this.runQuery(query2);
        double result2 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        Assert.assertEquals((double)result2, (double)result1);
    }

    @Test
    public void testNoisyAvgGaussianRealClippingZeroNoiseScale() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 4.7;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper) with noiseScale=0 which means no noise, and clipping", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testNoisyAvgGaussianRealClippingInvalidBound() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, false);
        double lower = 2.0;
        double upper = -8.0;
        double expected = 4.5;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper) with clipping lower > upper ", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealClippingZeroNoiseScaleWithNull() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 5.0;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper) with noiseScale=0 which means no noise, and clipping, with null values", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealClippingSomeNoiseScale() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 5.0;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.notEqualDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper) with noiseScale > 0 which means some noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(1.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealClippingSomeNoiseScaleWithinSomeStd() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, false);
        double lower = 2.0;
        double upper = 8.0;
        double expected = 5.0;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.withinSomeStdAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper) within some std from mean", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(1.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealClippingRandomSeed() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1.0, false);
        double lower = 2.0;
        double upper = 5.0;
        double expected = 14.2961467597545;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, lower, upper, randomSeed)", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(lower, numRows), BlockAssertions.createRLEBlock(upper, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealZeroNoiseScaleZeroRandomSeed() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, false);
        double expected = TestNoisyAggregationUtils.avg(values);
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(double, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(0L, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealSomeNoiseScaleFixedRandomSeed() {
        JavaAggregationFunctionImplementation noisyAvgGaussian = this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Double> values = TestNoisyAggregationUtils.createTestValues(numRows, true, 1.0, false);
        double expected = 15.4961467597545;
        AggregationTestUtils.assertAggregation(noisyAvgGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_avg_gaussian(real, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBlockOfReals(this.doubleListToFloatList(values)), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), expected);
    }

    @Test
    public void testNoisyAvgGaussianRealNoInputRowsWithoutGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("real");
        String query = "SELECT noisy_avg_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false";
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)1);
        Assert.assertNull((Object)actualRows.get(0).getField(0));
    }

    @Test
    public void testNoisyAvgGaussianRealNoInputRowsWithGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("real");
        String query = "SELECT noisy_avg_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false GROUP BY " + columnName;
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    private List<MaterializedRow> runQuery(String query) {
        LocalQueryRunner runner = new LocalQueryRunner(this.session);
        MaterializedResult actualResults = runner.execute(query).toTestTypes();
        return actualResults.getMaterializedRows();
    }

    private List<Float> doubleListToFloatList(List<Double> values) {
        return values.stream().map(f -> f == null ? null : Float.valueOf(f.floatValue())).collect(Collectors.toList());
    }

    private JavaAggregationFunctionImplementation getFunction(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(FUNCTION_NAME, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

