/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation.sketch;

import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.Bitmap;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.RandomizationStrategy;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.TestingDeterministicRandomizationStrategy;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.BitSet;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBitmap {
    private static final byte[] BYTE_STRING_A = new byte[]{44, -25, -97, 103, -34, 109, -83, -81, 105, 0, -36, -67, -42, 99, 43, -96, -34, -73, 31, 50, -18, -72, 73, -79, 74, 92, -15, -30, 61, -10, 17, 58, 24, -88, -104, 64, -99, 3, 85, 32, 71, -10, 113, -126, -23, -101, 80, -7, -12, -43, -125, -63, 68, 93, -123, 26, 80, 86, 60, -1, 64, -14, -100, 24, 86, -113, -76, 20, -62, -49, 25, -1, -59, 11, -8, -18, 43, 106, -23, -35, 33, -55, 62, 77, -67, -11, 95, -72, -109, 17, -96, -76, -96, -82, 17, -98, 79, -123, 52, 41};
    private static final byte[] BYTE_STRING_B = new byte[]{-74, -71, 15, -96, 63, 53, 85, 95, -17, 109, 15, -41, 72, 3, -59, 74, -52, 123, 103, -110, -83, -128, 97, -5, -117, 61, -106, -17, -17, -106, 97, -85, 51, -101, -103, -82, 69, 103, 5, 4, -59, 21, -62, 101, -104, -43, 25, -103, -32, -20, 123, -37, -84, -55, -63, 31, -92, 13, -83, 31, -78, -8, 49, 124, 12, -52, -91, -41, 30, -105, 33, 42, -120, 67, -113, -115, -28, -101, 24, -77, -69, -71, -79, -1, 71, 88, 4, -21, -32, 43, 45, 100, 42, 37, 80, 49, -12, 39, -48, -4};

    private TestBitmap() {
    }

    @Test
    public static void testRoundTripFullLength() {
        Bitmap bitmap = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_A);
        Assert.assertEquals((byte[])bitmap.toBytes(), (byte[])BYTE_STRING_A);
    }

    @Test
    public static void testRoundTripTruncated() {
        byte[] bytes = Arrays.copyOf(BYTE_STRING_A, 100);
        bytes[95] = 0;
        bytes[96] = 0;
        bytes[97] = 0;
        bytes[98] = 0;
        bytes[99] = 0;
        byte[] expectedBytes = Arrays.copyOf(bytes, 95);
        Assert.assertEquals((byte[])Bitmap.fromBytes((int)800, (byte[])bytes).toBytes(), (byte[])expectedBytes);
    }

    @Test
    public static void testSetBit() {
        Bitmap bitmap = new Bitmap(24);
        bitmap.setBit(0, true);
        bitmap.setBit(1, true);
        bitmap.setBit(8, true);
        bitmap.setBit(10, true);
        bitmap.setBit(16, true);
        bitmap.setBit(18, true);
        bitmap.setBit(20, true);
        bitmap.setBit(22, true);
        byte[] bytes = bitmap.toBytes();
        Assert.assertEquals((int)bytes[0], (int)3);
        Assert.assertEquals((int)bytes[1], (int)5);
        Assert.assertEquals((int)bytes[2], (int)85);
        for (int i = 10; i < 24; ++i) {
            bitmap.setBit(i, false);
        }
        bytes = bitmap.toBytes();
        Assert.assertEquals((int)bytes.length, (int)2);
        Assert.assertEquals((int)bytes[0], (int)3);
        Assert.assertEquals((int)bytes[1], (int)1);
    }

    @Test
    public static void testGetBit() {
        Bitmap bitmap = new Bitmap(4096);
        for (int i = 0; i < 4096; ++i) {
            bitmap.setBit(i, true);
            Assert.assertTrue((boolean)bitmap.getBit(i));
            bitmap.setBit(i, false);
            Assert.assertFalse((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public void testGetBitCount() {
        int length = 1024;
        Bitmap bitmap = new Bitmap(length);
        Assert.assertEquals((int)bitmap.getBitCount(), (int)0);
        for (int i = 0; i < length; ++i) {
            bitmap.setBit(i, true);
            Assert.assertEquals((int)bitmap.getBitCount(), (int)(i + 1));
        }
    }

    @Test
    public static void testFlipBit() {
        Bitmap bitmap = new Bitmap(4096);
        for (int i = 0; i < 4096; ++i) {
            bitmap.flipBit(i);
            Assert.assertTrue((boolean)bitmap.getBit(i));
            bitmap.flipBit(i);
            Assert.assertFalse((boolean)bitmap.getBit(i));
            bitmap.flipBit(i);
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public static void testByteLength() {
        for (int length : new int[]{8, 800}) {
            Bitmap bitmap = new Bitmap(length);
            for (int i = 0; i < length; ++i) {
                bitmap.setBit(i, true);
                Assert.assertEquals((int)bitmap.byteLength(), (int)bitmap.toBytes().length);
            }
        }
    }

    @Test
    public static void testLength() {
        for (int i = 1; i <= 10; ++i) {
            Bitmap bitmap = new Bitmap(i * 8);
            Assert.assertEquals((int)bitmap.length(), (int)(i * 8));
        }
    }

    @Test
    public static void testRandomFlips() {
        int i;
        Bitmap bitmap = new Bitmap(16);
        TestingDeterministicRandomizationStrategy randomizationStrategy = new TestingDeterministicRandomizationStrategy();
        bitmap.flipBit(0, 0.75, (RandomizationStrategy)randomizationStrategy);
        Assert.assertTrue((boolean)bitmap.getBit(0));
        bitmap.flipBit(0, 0.75, (RandomizationStrategy)randomizationStrategy);
        Assert.assertFalse((boolean)bitmap.getBit(0));
        bitmap.flipBit(0, 0.25, (RandomizationStrategy)randomizationStrategy);
        Assert.assertFalse((boolean)bitmap.getBit(0));
        bitmap.flipAll(0.75, (RandomizationStrategy)randomizationStrategy);
        for (i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
        bitmap.flipAll(0.25, (RandomizationStrategy)randomizationStrategy);
        for (i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public static void testClone() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_A);
        Bitmap bitmapB = bitmapA.clone();
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapA.getBit(i), (boolean)bitmapB.getBit(i));
        }
        bitmapA.flipBit(0);
        Assert.assertEquals((boolean)bitmapA.getBit(0), (!bitmapB.getBit(0) ? 1 : 0) != 0);
    }

    @Test
    public static void testOr() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_A);
        Bitmap bitmapB = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_B);
        Bitmap bitmapC = bitmapA.clone();
        bitmapC.or(bitmapB);
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapC.getBit(i), (boolean)(bitmapA.getBit(i) | bitmapB.getBit(i)));
        }
    }

    @Test
    public static void testXor() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_A);
        Bitmap bitmapB = Bitmap.fromBytes((int)800, (byte[])BYTE_STRING_B);
        Bitmap bitmapC = bitmapA.clone();
        bitmapC.xor(bitmapB);
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapC.getBit(i), (boolean)(bitmapA.getBit(i) ^ bitmapB.getBit(i)));
        }
    }

    @Test
    public static void testRetainedSize() {
        int instanceSizes = ClassLayout.parseClass(Bitmap.class).instanceSize() + ClassLayout.parseClass(BitSet.class).instanceSize();
        Bitmap bitmap = new Bitmap(1024);
        Assert.assertEquals((long)bitmap.getRetainedSizeInBytes(), (long)((long)instanceSizes + SizeOf.sizeOfLongArray((int)16)));
    }
}

