/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.CompressionCodec;
import com.facebook.presto.Session;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.repartition.OptimizedPartitionedOutputOperator;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOptimizedPartitionedOutputOperator {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-EXECUTOR-%s"));
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"test-%s"));
    private static final DataSize MAX_MEMORY = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final PagesSerde PAGES_SERDE = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager(), CompressionCodec.NONE).createPagesSerde();
    private static final int PARTITION_COUNT = 16;
    private static final int PAGE_COUNT = 50;
    private static final int POSITION_COUNT = 100;
    private static final Random RANDOM = new Random(0L);
    private static final Block NULL_BLOCK = new RunLengthEncodedBlock(BigintType.BIGINT.createBlockBuilder(null, 1).appendNull().build(), 100);
    private static final Block TESTING_BLOCK = BlockAssertions.createLongSequenceBlock(0, 100);
    private static final Block TESTING_DICTIONARY_BLOCK = BlockAssertions.createLongDictionaryBlock(0, 100);
    private static final Block TESTING_RLE_BLOCK = BlockAssertions.createRLEBlock(new Random(0L).nextLong(), 100);
    private static final Page TESTING_PAGE = new Page(new Block[]{TESTING_BLOCK});
    private static final Page TESTING_PAGE_WITH_DICTIONARY_BLOCK = new Page(new Block[]{TESTING_DICTIONARY_BLOCK});
    private static final Page TESTING_PAGE_WITH_RLE_BLOCK = new Page(new Block[]{TESTING_RLE_BLOCK});
    private static final Page TESTING_PAGE_WITH_NULL_BLOCK = new Page(100, new Block[]{TESTING_BLOCK, NULL_BLOCK});
    private static final Page TESTING_PAGE_WITH_NULL_AND_DICTIONARY_BLOCK = new Page(100, new Block[]{TESTING_DICTIONARY_BLOCK, NULL_BLOCK});
    private static final Page TESTING_PAGE_WITH_NULL_AND_RLE_BLOCK = new Page(100, new Block[]{TESTING_RLE_BLOCK, NULL_BLOCK});
    private static final double OUTPUT_SIZE_ESTIMATION_ERROR_ALLOWANCE = 1.2;

    @Test
    public void testPartitionedSinglePagePrimitiveTypes() {
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RealType.REAL));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)17)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testPartitionedSinglePageForArray() {
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)))));
    }

    @Test
    public void testPartitionedSinglePageForMap() {
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testPartitionedSinglePageForRow() {
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19))))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)))))));
        this.testPartitionedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)))))));
    }

    @Test
    public void testPartitionedMultiplePagesPrimitiveTypes() {
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RealType.REAL));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)17)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testPartitionedMultiplePagesForArray() {
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)))));
    }

    @Test
    public void testPartitionedMultiplePagesForMap() {
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testPartitionedMultiplePagesForRow() {
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19))))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)))))));
        this.testPartitionedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)))))));
    }

    @Test
    public void testReplicatedSinglePagePrimitiveTypes() {
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)17)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testReplicatedSinglePageForArray() {
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)))));
    }

    @Test
    public void testReplicatedSinglePageForMap() {
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testReplicatedSinglePageForRow() {
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19))))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)))))));
        this.testReplicatedSinglePage((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)))))));
    }

    @Test
    public void testReplicatedMultiplePagesPrimitiveTypes() {
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)17)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testReplicatedMultiplePagesForArray() {
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)))));
    }

    @Test
    public void testReplicatedMultiplePagesForMap() {
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)BlockAssertions.createMapType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testReplicatedMultiplePagesForRow() {
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19))))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)))))));
        this.testReplicatedMultiplePages((List<Type>)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)))))));
    }

    @Test
    public void testEmptyPage() {
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), true, false);
        Page page = PageAssertions.createPageWithRandomData((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 0, true, false, 0.0f, 0.0f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
    }

    @Test
    public void testPageWithNoBlocks() {
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock((List<Type>)ImmutableList.of(), false, false);
        Page page = PageAssertions.createPageWithRandomData((List<Type>)ImmutableList.of(), 1, false, false, 0.0f, 0.0f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartitionedForZeroBlocks(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
    }

    @Test
    public void testPageWithBlocksOfDifferentPositionCounts() {
        Block[] blocks = new Block[]{BlockAssertions.createRandomLongsBlock(100, 0.0f), BlockAssertions.wrapBlock(BlockAssertions.createRandomStringBlock(10, 0.2f, 10), 100, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))), BlockAssertions.wrapBlock(BlockAssertions.createRandomStringBlock(100, 0.2f, 10), 100, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))), BlockAssertions.wrapBlock(BlockAssertions.createRandomStringBlock(1000, 0.2f, 10), 100, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)))};
        Page page = new Page(blocks);
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        this.testPartitioned((List<Type>)types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned((List<Type>)types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    @Test
    public void testPageWithVariableWidthBlocksOfSliceViews() {
        Block[] blocks = new Block[]{BlockAssertions.createRandomLongsBlock(100, 0.0f), TestOptimizedPartitionedOutputOperator.createVariableWidthBlockOverSliceView(100)};
        Page page = new Page(blocks);
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        this.testPartitioned((List<Type>)types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned((List<Type>)types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    private void testPartitionedSinglePage(List<Type> targetTypes) {
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(targetTypes, true, false);
        Page page = PageAssertions.createPageWithRandomData(targetTypes, 100, true, false, 0.2f, 0.2f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
        page = PageAssertions.createPageWithRandomData(targetTypes, 100, true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
        page = PageAssertions.createPageWithRandomData(targetTypes, 100, true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    private void testPartitionedMultiplePages(List<Type> targetTypes) {
        int i;
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(targetTypes, true, false);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (i = 0; i < 50; ++i) {
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, false, (List<BlockAssertions.Encoding>)ImmutableList.of()));
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        }
        this.testPartitioned(types, pages, new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned(types, pages, new DataSize(1.0, DataSize.Unit.KILOBYTE));
        pages.clear();
        for (i = 0; i < 16; ++i) {
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, false, (List<BlockAssertions.Encoding>)ImmutableList.of()));
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, false, 0.2f, 0.2f, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        }
        this.testPartitioned(types, pages, new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testPartitioned(types, pages, new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    private void testReplicatedSinglePage(List<Type> targetTypes) {
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(targetTypes, true, true);
        Page page = PageAssertions.createPageWithRandomData(targetTypes, 100, true, true, 0.2f, 0.2f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testReplicated(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testReplicated(types, (List<Page>)ImmutableList.of((Object)page), new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    private void testReplicatedMultiplePages(List<Type> targetTypes) {
        List<Type> types = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(targetTypes, true, true);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < 50; ++i) {
            pages.add(PageAssertions.createPageWithRandomData(targetTypes, 100 + RANDOM.nextInt(100), true, true, 0.2f, 0.2f, false, (List<BlockAssertions.Encoding>)ImmutableList.of()));
        }
        this.testReplicated(types, pages, new DataSize(128.0, DataSize.Unit.MEGABYTE));
        this.testReplicated(types, pages, new DataSize(1.0, DataSize.Unit.KILOBYTE));
    }

    private void testPartitionedForZeroBlocks(List<Type> types, List<Page> pages, DataSize maxMemory) {
        this.testPartitioned(types, pages, maxMemory, (List<Integer>)ImmutableList.of(), (HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of(), new int[0]));
    }

    private void testPartitioned(List<Type> types, List<Page> pages, DataSize maxMemory) {
        this.testPartitioned(types, pages, maxMemory, (List<Integer>)ImmutableList.of((Object)0), (HashGenerator)new PrecomputedHashGenerator(0));
    }

    private void testPartitioned(List<Type> types, List<Page> pages, DataSize maxMemory, List<Integer> partitionChannel, HashGenerator hashGenerator) {
        TestingPartitionedOutputBuffer outputBuffer = this.createPartitionedOutputBuffer();
        LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator(hashGenerator, 16);
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator(types, partitionChannel, (PartitionFunction)partitionFunction, outputBuffer, OptionalInt.empty(), maxMemory);
        HashMap<Integer, List> expectedPageList = new HashMap<Integer, List>();
        for (Page page : pages) {
            HashMap<Integer, List> positionsByPartition = new HashMap<Integer, List>();
            for (int i = 0; i < page.getPositionCount(); ++i) {
                int partitionNumber = partitionFunction.getPartition(page, i);
                positionsByPartition.computeIfAbsent(partitionNumber, k -> new ArrayList()).add(i);
            }
            for (Map.Entry entry : positionsByPartition.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                expectedPageList.computeIfAbsent((Integer)entry.getKey(), k -> new ArrayList()).add(this.copyPositions(page, (List)entry.getValue()));
            }
            operator.addInput(page);
        }
        operator.finish();
        Map expectedPages = Maps.transformValues(expectedPageList, outputPages -> PageAssertions.mergePages(types, outputPages));
        Map actualPages = Maps.transformValues(outputBuffer.getPages(), outputPages -> PageAssertions.mergePages(types, outputPages));
        Assert.assertEquals((int)actualPages.size(), (int)expectedPages.size());
        Assert.assertEquals(actualPages.keySet(), expectedPages.keySet());
        for (Map.Entry entry : expectedPages.entrySet()) {
            int key = (Integer)entry.getKey();
            PageAssertions.assertPageEquals(types, (Page)actualPages.get(key), (Page)entry.getValue());
        }
    }

    private void testReplicated(List<Type> types, List<Page> pages, DataSize maxMemory) {
        TestingPartitionedOutputBuffer outputBuffer = this.createPartitionedOutputBuffer();
        LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new PrecomputedHashGenerator(0), 16);
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator(types, (List<Integer>)ImmutableList.of((Object)0), (PartitionFunction)partitionFunction, outputBuffer, OptionalInt.of(types.size() - 1), maxMemory);
        for (Page page : pages) {
            operator.addInput(page);
        }
        operator.finish();
        Map<Integer, List<Page>> actualPageLists = outputBuffer.getPages();
        Assert.assertEquals((int)actualPageLists.size(), (int)16);
        Page expectedPage = PageAssertions.mergePages(types, pages);
        actualPageLists.values().forEach(pageList -> PageAssertions.assertPageEquals(types, PageAssertions.mergePages(types, pageList), expectedPage));
    }

    @Test
    public void testOutputForSimplePage() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), false);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 50L * TESTING_PAGE.getLogicalSizeInBytes(), 50 * TESTING_PAGE.getPositionCount());
    }

    @Test
    public void testOutputSizeForPageWithDictionary() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), false);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE_WITH_DICTIONARY_BLOCK);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 50L * TESTING_PAGE_WITH_DICTIONARY_BLOCK.getLogicalSizeInBytes(), 50 * TESTING_PAGE_WITH_DICTIONARY_BLOCK.getPositionCount());
    }

    @Test
    public void testOutputForPageWithRunLength() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), false);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE_WITH_RLE_BLOCK);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 50L * TESTING_PAGE_WITH_RLE_BLOCK.getLogicalSizeInBytes(), 50 * TESTING_PAGE_WITH_RLE_BLOCK.getPositionCount());
    }

    @Test
    public void testOutputForSimplePageReplicated() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), true);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE_WITH_NULL_BLOCK);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 800L * TESTING_PAGE.getLogicalSizeInBytes(), 800 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount());
    }

    @Test
    public void testOutputForPageWithDictionaryReplicated() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), true);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE_WITH_NULL_AND_DICTIONARY_BLOCK);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 800L * TESTING_PAGE_WITH_DICTIONARY_BLOCK.getLogicalSizeInBytes(), 800 * TESTING_PAGE_WITH_DICTIONARY_BLOCK.getPositionCount());
    }

    @Test
    public void testOutputForPageWithRunLengthReplicated() {
        OptimizedPartitionedOutputOperator operator = this.createOptimizedPartitionedOutputOperator((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), true);
        TestOptimizedPartitionedOutputOperator.processPages(operator, TESTING_PAGE_WITH_NULL_AND_RLE_BLOCK);
        TestOptimizedPartitionedOutputOperator.verifyOutputSizes(operator, 800L * TESTING_PAGE_WITH_RLE_BLOCK.getLogicalSizeInBytes(), 800 * TESTING_PAGE_WITH_NULL_AND_RLE_BLOCK.getPositionCount());
    }

    private static void processPages(OptimizedPartitionedOutputOperator operator, Page testingPageWithRleBlock) {
        for (int i = 0; i < 50; ++i) {
            operator.addInput(testingPageWithRleBlock);
        }
        operator.finish();
    }

    private static void verifyOutputSizes(OptimizedPartitionedOutputOperator operator, long expectedSizeInBytes, long expectedPositionCount) {
        OperatorContext operatorContext = operator.getOperatorContext();
        Assertions.assertBetweenInclusive((Comparable)Long.valueOf(operatorContext.getOutputDataSize().getTotalCount()), (Comparable)Long.valueOf((long)((double)expectedSizeInBytes / 1.2)), (Comparable)Long.valueOf((long)((double)expectedSizeInBytes * 1.2)));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)expectedPositionCount);
    }

    private Page copyPositions(Page page, List<Integer> positions) {
        Block[] blocks = new Block[page.getChannelCount()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = page.getBlock(i).copyPositions(positions.stream().mapToInt(j -> j).toArray(), 0, positions.size());
        }
        return new Page(positions.size(), blocks);
    }

    private TestingPartitionedOutputBuffer createPartitionedOutputBuffer() {
        OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
        for (int partition = 0; partition < 16; ++partition) {
            buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
        }
        TestingPartitionedOutputBuffer buffer = this.createPartitionedBuffer(buffers.withNoMoreBufferIds(), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE));
        buffer.registerLifespanCompletionCallback(ignore -> {});
        return buffer;
    }

    private OptimizedPartitionedOutputOperator createOptimizedPartitionedOutputOperator(List<Type> types, boolean replicateAllRows) {
        TestingPartitionedOutputBuffer outputBuffer = this.createPartitionedOutputBuffer();
        LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new PrecomputedHashGenerator(0), 16);
        if (replicateAllRows) {
            List<Type> replicatedTypes = PageAssertions.updateBlockTypesWithHashBlockAndNullBlock(types, false, true);
            return this.createOptimizedPartitionedOutputOperator(replicatedTypes, (List<Integer>)ImmutableList.of((Object)0), (PartitionFunction)partitionFunction, outputBuffer, OptionalInt.of(replicatedTypes.size() - 1), MAX_MEMORY);
        }
        return this.createOptimizedPartitionedOutputOperator(types, (List<Integer>)ImmutableList.of((Object)0), (PartitionFunction)partitionFunction, outputBuffer, OptionalInt.empty(), MAX_MEMORY);
    }

    private OptimizedPartitionedOutputOperator createOptimizedPartitionedOutputOperator(List<Type> types, List<Integer> partitionChannel, PartitionFunction partitionFunction, PartitionedOutputBuffer buffer, OptionalInt nullChannel, DataSize maxMemory) {
        PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager(), CompressionCodec.NONE);
        OutputPartitioning outputPartitioning = new OutputPartitioning(partitionFunction, partitionChannel, (List)ImmutableList.of(Optional.empty()), false, nullChannel);
        OptimizedPartitionedOutputOperator.OptimizedPartitionedOutputFactory operatorFactory = new OptimizedPartitionedOutputOperator.OptimizedPartitionedOutputFactory((OutputBuffer)buffer, maxMemory);
        return (OptimizedPartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), types, Function.identity(), Optional.of(outputPartitioning), serdeFactory).createOperator(this.createDriverContext());
    }

    private DriverContext createDriverContext() {
        Session testSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        return TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)testSession).setMemoryPoolSize(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
    }

    private TestingPartitionedOutputBuffer createPartitionedBuffer(OutputBuffers buffers, DataSize dataSize) {
        return new TestingPartitionedOutputBuffer("task-instance-id", (StateMachine<BufferState>)new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), SCHEDULER);
    }

    private static Block createVariableWidthBlockOverSliceView(int entries) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(entries * 2);
        for (int i = 0; i < entries * 2; ++i) {
            dynamicSliceOutput.writeByte(i);
        }
        Slice slice = dynamicSliceOutput.slice().slice(entries, entries);
        int[] offsets = IntStream.range(0, entries + 1).toArray();
        return new VariableWidthBlock(entries, slice, offsets, Optional.empty());
    }

    private static class TestingPartitionedOutputBuffer
    extends PartitionedOutputBuffer {
        private final Map<Integer, List<Page>> pages = new HashMap<Integer, List<Page>>();

        public TestingPartitionedOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, OutputBuffers outputBuffers, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier, Executor notificationExecutor) {
            super(taskInstanceId, state, outputBuffers, maxBufferSize.toBytes(), systemMemoryContextSupplier, notificationExecutor);
        }

        public void enqueue(Lifespan lifespan, int partitionNumber, List<SerializedPage> pages) {
            this.pages.computeIfAbsent(partitionNumber, k -> new ArrayList());
            pages.stream().map(arg_0 -> ((PagesSerde)PAGES_SERDE).deserialize(arg_0)).forEach(this.pages.get(partitionNumber)::add);
        }

        public Map<Integer, List<Page>> getPages() {
            return this.pages;
        }
    }
}

