/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.scalar.BenchmarkJsonToArrayCast;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkJsonExtract {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    public static final ConnectorSession SESSION = new TestingConnectorSession((List)ImmutableList.of());
    private static final int POSITION_COUNT = 100000;
    private static final int ARRAY_SIZE = 20;
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private PageProcessor pageProcessor;
    private Page inputPage;
    private Map<String, Type> symbolTypes;
    private Map<VariableReferenceExpression, Integer> sourceLayout;
    @Param(value={"true", "false"})
    boolean isCanonicalizedJsonExtract;

    @Setup
    public void setup() {
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), VarcharType.VARCHAR.getDisplayName().toLowerCase(Locale.ENGLISH) + "0", (Type)VarcharType.VARCHAR);
        this.symbolTypes = ImmutableMap.of((Object)variable.getName(), (Object)VarcharType.VARCHAR);
        this.sourceLayout = ImmutableMap.of((Object)variable, (Object)0);
        this.inputPage = new Page(new Block[]{BenchmarkJsonExtract.createChannel()});
        ImmutableList projections = ImmutableList.of((Object)this.rowExpression("json_extract(varchar0, '$.key1')"), (Object)this.rowExpression("json_extract(varchar0, '$.key2')"));
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler);
        this.pageProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(TEST_SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
    }

    @Benchmark
    public List<Optional<Page>> computePage() {
        SqlFunctionProperties sqlFunctionProperties = SqlFunctionProperties.builder().setTimeZoneKey(TimeZoneKey.UTC_KEY).setLegacyTimestamp(true).setSessionStartTime(0L).setSessionLocale(Locale.ENGLISH).setSessionUser("user").setCanonicalizedJsonExtract(this.isCanonicalizedJsonExtract).build();
        return ImmutableList.copyOf((Iterator)this.pageProcessor.process(sqlFunctionProperties, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    private RowExpression rowExpression(String value) {
        Expression expression = FunctionAssertions.createExpression(TEST_SESSION, value, METADATA, TypeProvider.copyOf(this.symbolTypes));
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, (TypeProvider)TypeProvider.copyOf(this.symbolTypes), (Expression)expression, Collections.emptyMap(), (WarningCollector)WarningCollector.NOOP);
        RowExpression rowExpression = SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, this.sourceLayout, (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager(), (Session)TEST_SESSION);
        RowExpressionOptimizer optimizer = new RowExpressionOptimizer(METADATA);
        return optimizer.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED, TEST_SESSION.toConnectorSession());
    }

    private static Block createChannel() {
        BlockBuilder blockBuilder = JsonType.JSON.createBlockBuilder(null, 100000);
        for (int position = 0; position < 100000; ++position) {
            try (DynamicSliceOutput jsonSlice = new DynamicSliceOutput(400);){
                jsonSlice.appendByte(123);
                int k1Index = ThreadLocalRandom.current().nextInt(20);
                int k2Index = ThreadLocalRandom.current().nextInt(20);
                while (k2Index == k1Index) {
                    k2Index = ThreadLocalRandom.current().nextInt(20);
                }
                for (int i = 0; i < 20; ++i) {
                    String key = i == k1Index ? "key1" : (i == k2Index ? "key2" : BenchmarkJsonExtract.generateRandomKey(ThreadLocalRandom.current().nextInt(5) + 1));
                    jsonSlice.appendBytes("\"".getBytes());
                    jsonSlice.appendBytes(key.getBytes());
                    jsonSlice.appendBytes("\"".getBytes());
                    jsonSlice.appendByte(58);
                    String value = key.equals("key1") || key.equals("key2") || (ThreadLocalRandom.current().nextInt(10) & 1) == 0 ? BenchmarkJsonExtract.generateNestedJsonValue() : BenchmarkJsonExtract.generateRandomJsonValue();
                    jsonSlice.appendBytes(value.getBytes());
                    if (i >= 19) continue;
                    jsonSlice.appendByte(44);
                }
                jsonSlice.appendByte(125);
                JsonType.JSON.writeSlice(blockBuilder, jsonSlice.slice());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return blockBuilder.build();
    }

    private static String generateRandomJsonValue() {
        int length = ThreadLocalRandom.current().nextInt(10) + 1;
        StringBuilder builder = new StringBuilder(length + 2);
        builder.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = CHARACTERS.charAt(ThreadLocalRandom.current().nextInt(CHARACTERS.length()));
            if (c == '\"') {
                builder.append('\\');
            }
            builder.append(c);
        }
        builder.append('\"');
        return builder.toString();
    }

    private static String generateNestedJsonValue() {
        int size = ThreadLocalRandom.current().nextInt(5) + 1;
        StringBuilder builder = new StringBuilder(size * 10);
        builder.append('{');
        for (int i = 0; i < size; ++i) {
            String key = BenchmarkJsonExtract.generateRandomKey(ThreadLocalRandom.current().nextInt(5) + 2);
            builder.append("\"").append(key).append("\":");
            builder.append(BenchmarkJsonExtract.generateRandomJsonValue());
            if (i >= size - 1) continue;
            builder.append(",");
        }
        builder.append('}');
        return builder.toString();
    }

    private static String generateRandomKey(int len) {
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            builder.append(CHARACTERS.charAt(ThreadLocalRandom.current().nextInt(CHARACTERS.length())));
        }
        return builder.toString();
    }

    @Test
    public void verify() {
        BenchmarkJsonToArrayCast.BenchmarkData data = new BenchmarkJsonToArrayCast.BenchmarkData();
        data.setup();
        new BenchmarkJsonToArrayCast().benchmark(data);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkJsonToArrayCast.BenchmarkData data = new BenchmarkJsonToArrayCast.BenchmarkData();
        data.setup();
        new BenchmarkJsonToArrayCast().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkJsonExtract.class.getSimpleName() + ".*").warmupMode(WarmupMode.BULK_INDI).build();
        new Runner(options).run();
    }
}

