/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkStringConcat {
    private static final int NUM_ARGS = 250;

    @Benchmark
    @OperationsPerInvocation(value=250)
    public List<Optional<Page>> stringConcat(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkStringConcat().stringConcat(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.INDI).include(".*" + BenchmarkStringConcat.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String name = "concat";
        @Param(value={"all_non_empty", "half_empty"})
        private String config = "all_non_empty";
        @Param(value={"2", "10", "100"})
        private int argCount = 100;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            List<String> args = BenchmarkData.createRandomStringListFromSet(this.argCount);
            Block slices = BenchmarkData.createSliceArrayBlock(args);
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            ImmutableList.Builder types = ImmutableList.builder();
            for (int i = 0; i < args.size(); ++i) {
                types.add((Object)VarcharType.VARCHAR);
                if (this.config.equals("half_empty") && i % 2 == 0) {
                    argsBuilder.add((Object)new ConstantExpression((Object)Slices.utf8Slice((String)""), (Type)VarcharType.VARCHAR));
                    continue;
                }
                argsBuilder.add((Object)new ConstantExpression((Object)Slices.utf8Slice((String)args.get(i)), (Type)VarcharType.VARCHAR));
            }
            FunctionHandle functionHandle = metadata.getFunctionAndTypeManager().lookupFunction(this.name, TypeSignatureProvider.fromTypes((List)types.build()));
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < args.size(); ++i) {
                fields.add((Object)Expressions.field((int)i, (Type)VarcharType.VARCHAR));
            }
            ImmutableList.Builder exprBuilder = ImmutableList.builder();
            exprBuilder.add((Object)new CallExpression(this.name, functionHandle, (Type)VarcharType.VARCHAR, (List)argsBuilder.build()));
            ImmutableList projections = exprBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{slices});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }

        private static Block createSliceArrayBlock(List<String> keys) {
            Slice[] sliceArray = new Slice[keys.size() + 1];
            for (int i = 0; i < keys.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)keys.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }

        private static List<String> createRandomStringListFromSet(int keyCount) {
            Random random = new Random(0L);
            ArrayList<String> keyList = new ArrayList<String>();
            for (int i = 0; i < keyCount; ++i) {
                keyList.add(Integer.toString(random.nextInt(keyCount)));
            }
            return keyList;
        }
    }
}

