/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestArraySumFunction
extends AbstractTestFunctions {
    @Test
    public void testBigIntType() {
        this.assertFunction("array_sum(array[BIGINT '1', BIGINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[INTEGER '1', INTEGER '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[SMALLINT '1', SMALLINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[TINYINT '1', TINYINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[BIGINT '1', INTEGER '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[INTEGER '1', SMALLINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[SMALLINT '1', TINYINT '2'])", (Type)BigintType.BIGINT, 3L);
    }

    @Test
    public void testDoubleType() {
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', REAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[REAL '-2.0', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[BIGINT '-2', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[INTEGER '-2', REAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[SMALLINT '-2', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[TINYINT '-2', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
    }

    @Test
    public void testEdgeCases() {
        this.assertFunction("array_sum(null)", (Type)BigintType.BIGINT, null);
        this.assertFunction("array_sum(array[])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[NULL])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[NULL, NULL, NULL])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[3, NULL, 5])", (Type)BigintType.BIGINT, 8L);
        this.assertFunctionWithError("array_sum(array[NULL, double '1.2', double '2.3', NULL, -3])", (Type)DoubleType.DOUBLE, 0.5);
    }
}

