/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestArrayUnionFunction
extends AbstractTestFunctions {
    @Test
    public void testBigint() {
        this.assertFunction("ARRAY_UNION(ARRAY [cast(10 as bigint), NULL, cast(12 as bigint), NULL], ARRAY [NULL, cast(10 as bigint), NULL, NULL])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(10L, null, 12L));
    }

    public void testInteger() {
        this.assertFunction("ARRAY_UNION(ARRAY [12], ARRAY [10])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)12, (Object)10));
        this.assertFunction("ARRAY_UNION(ARRAY [1, 5], ARRAY [1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)5));
        this.assertFunction("ARRAY_UNION(ARRAY [1, 1, 2, 4], ARRAY [1, 1, 4, 4])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)4));
        this.assertFunction("ARRAY_UNION(ARRAY [2, 8], ARRAY [8, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)8, (Object)3));
        this.assertFunction("ARRAY_UNION(ARRAY [IF (RAND() < 1.0E0, 7, 1) , 2], ARRAY [7])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)7, (Object)2));
    }

    @Test
    public void testVarchar() {
        this.assertFunction("ARRAY_UNION(ARRAY ['foo', 'bar', 'baz'], ARRAY ['foo', 'test', 'bar'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"test"));
    }

    @Test
    public void testDouble() {
        this.assertFunction("ARRAY_UNION(ARRAY [1, 5], ARRAY [1.0E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)5.0));
        this.assertFunction("ARRAY_UNION(ARRAY [8.3E0, 1.6E0, 4.1E0, 5.2E0], ARRAY [4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)8.3, (Object)1.6, (Object)4.1, (Object)5.2, (Object)4.0, (Object)9.7, (Object)3.5));
        this.assertFunction("ARRAY_UNION(ARRAY [5.1E0, 7, 3.0E0, 4.8E0, 10], ARRAY [6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.1, (Object)7.0, (Object)3.0, (Object)4.8, (Object)10.0, (Object)6.5, (Object)1.9, (Object)3.9));
    }

    @Test
    public void testArrayOfArrays() {
        this.assertFunction("ARRAY_UNION(ARRAY [ARRAY [4, 5], ARRAY [6, 7]], ARRAY [ARRAY [4, 5], ARRAY [6, 8]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)4, (Object)5), (Object)ImmutableList.of((Object)6, (Object)7), (Object)ImmutableList.of((Object)6, (Object)8)));
    }

    @Test
    public void testNull() {
        this.assertFunction("ARRAY_UNION(ARRAY [NULL], ARRAY [NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Object[]{null}));
        this.assertFunction("ARRAY_UNION(ARRAY ['abc', NULL, 'xyz', NULL], ARRAY [NULL, 'abc', NULL, NULL])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList("abc", null, "xyz"));
    }

    @Test
    public void testIndeterminateRows() {
        this.assertFunction("array_union(ARRAY[(123, 'abc'), (123, NULL)], ARRAY[(123, 'abc'), (123, NULL)])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        this.assertFunction("array_union(ARRAY[(NULL, 'abc'), (123, null), (123, 'abc')], ARRAY[(456, 'def'),(NULL, 'abc')])", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3)))), ImmutableList.of(Arrays.asList(null, "abc"), Arrays.asList(123, null), Arrays.asList(123, "abc"), Arrays.asList(456, "def")));
    }

    @Test
    public void testIndeterminateArrays() {
        this.assertFunction("array_union(ARRAY[ARRAY[123, 456], ARRAY[123, NULL]], ARRAY[ARRAY[123, 456], ARRAY[123, NULL]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, null)));
        this.assertFunction("array_union(ARRAY[ARRAY[NULL, 456], ARRAY[123, 456]], ARRAY[ARRAY[123, 456],ARRAY[NULL, 456]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(null, 456), Arrays.asList(123, 456)));
    }
}

