/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.testng.annotations.Test;

public class TestKllSketchFunctions
extends AbstractTestFunctions {
    @Test
    public void testDoubles() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        DoubleStream.iterate(0.0, i -> i + 1.0).limit(100L).forEach(arg_0 -> ((KllItemsSketch)sketch).update(arg_0));
        String sketchProjection = this.getSketchProjection(sketch, "double");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.0 as DOUBLE)"), (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)"), (Type)DoubleType.DOUBLE, 49.0);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)", false), (Type)DoubleType.DOUBLE, 50.0);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(1.0 as DOUBLE)"), (Type)DoubleType.DOUBLE, 99.0);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(-1 as DOUBLE)"), (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(49 as DOUBLE)"), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(50 as DOUBLE)", false), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(99 as DOUBLE)"), (Type)DoubleType.DOUBLE, 1.0);
    }

    @Test
    public void testInts() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        LongStream.iterate(0L, i -> i + 1L).limit(100L).forEach(arg_0 -> ((KllItemsSketch)sketch).update(arg_0));
        String sketchProjection = this.getSketchProjection(sketch, "bigint");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.0 as DOUBLE)"), (Type)BigintType.BIGINT, 0L);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)"), (Type)BigintType.BIGINT, 49L);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)", false), (Type)BigintType.BIGINT, 50L);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(1.0 as DOUBLE)"), (Type)BigintType.BIGINT, 99L);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(-1 as BIGINT)"), (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(49 as BIGINT)"), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(50 as BIGINT)", false), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "CAST(99 as BIGINT)"), (Type)DoubleType.DOUBLE, 1.0);
    }

    @Test
    public void testStrings() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Arrays.stream("abcdefghijklmnopqrstuvwxyz".split("")).forEach(arg_0 -> ((KllItemsSketch)sketch).update(arg_0));
        String sketchProjection = this.getSketchProjection(sketch, "varchar");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.0 as DOUBLE)"), (Type)VarcharType.VARCHAR, "a");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)"), (Type)VarcharType.VARCHAR, "m");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)", false), (Type)VarcharType.VARCHAR, "n");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(1.0 as DOUBLE)"), (Type)VarcharType.VARCHAR, "z");
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "'1'"), (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "'m'"), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "'n'", false), (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "'z'"), (Type)DoubleType.DOUBLE, 1.0);
    }

    @Test
    public void testBooleans() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        LongStream.iterate(0L, i -> i + 1L).limit(100L).mapToObj(i -> i % 3L == 0L).forEach(arg_0 -> ((KllItemsSketch)sketch).update(arg_0));
        String sketchProjection = this.getSketchProjection(sketch, "boolean");
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)"), (Type)BooleanType.BOOLEAN, false);
        this.assertFunction(this.getProjection("sketch_kll_quantile", sketchProjection, "CAST(0.5 as DOUBLE)", false), (Type)BooleanType.BOOLEAN, false);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "false", false), (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "true", false), (Type)DoubleType.DOUBLE, 0.66);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "false"), (Type)DoubleType.DOUBLE, 0.66);
        this.assertFunction(this.getProjection("sketch_kll_rank", sketchProjection, "true"), (Type)DoubleType.DOUBLE, 1.0);
    }

    private String getProjection(String functionName, String sketch, Object ... args) {
        String otherArgs = Joiner.on((String)",").join(args);
        return String.format("%s(%s)", functionName, Joiner.on((String)",").join((Object)sketch, (Object)otherArgs, new Object[0]));
    }

    private String getSketchProjection(KllItemsSketch sketch, String type) {
        return this.getByteArrayProjection(sketch.toByteArray(), type);
    }

    private String getByteArrayProjection(byte[] arr, String type) {
        String sqlSerializedSketch = new SqlVarbinary(arr).toString().replaceAll("\\s+", " ");
        return String.format("CAST(X'%s' AS kllsketch(%s))", sqlSerializedSketch, type);
    }
}

