/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSpecInfo;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.resourcemanager.ResourceManagerInconsistentException;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestResourceManagerClusterStateProvider {
    @Test(timeOut=15000L)
    public void testQueryInfo() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        long query4Sequence = 0L;
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED), query1Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING), query2Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.FINISHED), query3Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FAILED), query4Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 2);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.RUNNING), query1Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.FINISHING), query2Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 2);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.FINISHED), query2Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 3);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED), query1Sequence++);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING), query2Sequence++);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.FINISHED), query3Sequence++);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FAILED), query4Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 8, 5);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        this.assertQueryInfos(provider.getClusterQueries(), 8, 5);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        this.assertQueryInfos(provider.getClusterQueries(), 0, 0);
    }

    @Test(timeOut=15000L)
    public void testOutOfOrderUpdatesIgnored() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED), 1L);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.FINISHED), 2L);
        this.assertQueryInfos(provider.getClusterQueries(), 2, 1);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.FINISHED), 0L);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING), 1L);
        this.assertQueryInfos(provider.getClusterQueries(), 2, 1);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.FINISHED), 2L);
        this.assertQueryInfos(provider.getClusterQueries(), 2, 2);
    }

    @Test(timeOut=15000L)
    public void testResourceGroups() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node3", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"50s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("local"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node1"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node2"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node3"));
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        long query4Sequence = 0L;
        long query5Sequence = 0L;
        long query6Sequence = 0L;
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED, "rg1", LocalMemoryManager.GENERAL_POOL), query1Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING, "rg2", LocalMemoryManager.GENERAL_POOL), query2Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.FINISHING, "rg3", LocalMemoryManager.GENERAL_POOL), query3Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FINISHED, "rg4", LocalMemoryManager.GENERAL_POOL), query4Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("5", QueryState.FAILED, "rg5", LocalMemoryManager.GENERAL_POOL), query5Sequence++);
        this.assertResourceGroups(provider, "node1", 0);
        this.assertResourceGroups(provider, "node2", 3);
        provider.registerQueryHeartbeat("node3", TestResourceManagerClusterStateProvider.createQueryInfo("6", QueryState.QUEUED, "rg6", LocalMemoryManager.GENERAL_POOL), query6Sequence++);
        this.assertResourceGroups(provider, "node1", 1);
        this.assertResourceGroups(provider, "node2", 4);
        this.assertResourceGroups(provider, "node3", 3);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        this.assertResourceGroups(provider, "node1", 0);
        this.assertResourceGroups(provider, "node2", 0);
        this.assertResourceGroups(provider, "node3", 0);
    }

    @Test(timeOut=15000L)
    public void testResourceGroupsMerged() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node3", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node4", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node5", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node6", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"50s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("local"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node1"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node2"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node3"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node4"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node5"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node6"));
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.WAITING_FOR_PREREQUISITES, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node1").isEmpty());
        this.assertResourceGroup(provider, "node2", "rg4", 0, 0, DataSize.valueOf((String)"1MB"));
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.QUEUED, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        this.assertResourceGroup(provider, "node1", "rg4", 1, 0, DataSize.valueOf((String)"1MB"));
        this.assertResourceGroup(provider, "node2", "rg4", 0, 0, DataSize.valueOf((String)"1MB"));
        this.assertResourceGroup(provider, "node3", "rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        provider.registerQueryHeartbeat("node3", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.RUNNING, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        this.assertResourceGroup(provider, "node1", "rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node2", "rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node3", "rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        provider.registerQueryHeartbeat("node4", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FINISHED, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        this.assertResourceGroup(provider, "node1", "rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node2", "rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node3", "rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        provider.registerQueryHeartbeat("node5", TestResourceManagerClusterStateProvider.createQueryInfo("5", QueryState.FAILED, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        this.assertResourceGroup(provider, "node1", "rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node2", "rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node3", "rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertResourceGroup(provider, "node5", "rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("6", QueryState.WAITING_FOR_PREREQUISITES, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("7", QueryState.WAITING_FOR_RESOURCES, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        provider.registerQueryHeartbeat("node3", TestResourceManagerClusterStateProvider.createQueryInfo("8", QueryState.DISPATCHING, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        provider.registerQueryHeartbeat("node4", TestResourceManagerClusterStateProvider.createQueryInfo("9", QueryState.PLANNING, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        provider.registerQueryHeartbeat("node5", TestResourceManagerClusterStateProvider.createQueryInfo("10", QueryState.STARTING, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        provider.registerQueryHeartbeat("node6", TestResourceManagerClusterStateProvider.createQueryInfo("11", QueryState.FINISHING, "rg4", LocalMemoryManager.GENERAL_POOL), 0L);
        this.assertResourceGroup(provider, "node1", "rg4", 1, 6, DataSize.valueOf((String)"7MB"));
        this.assertResourceGroup(provider, "node2", "rg4", 0, 5, DataSize.valueOf((String)"7MB"));
        this.assertResourceGroup(provider, "node3", "rg4", 1, 4, DataSize.valueOf((String)"7MB"));
        this.assertResourceGroup(provider, "node4", "rg4", 1, 5, DataSize.valueOf((String)"8MB"));
        this.assertResourceGroup(provider, "node5", "rg4", 1, 5, DataSize.valueOf((String)"8MB"));
        this.assertResourceGroup(provider, "node6", "rg4", 1, 5, DataSize.valueOf((String)"8MB"));
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node1").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node2").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node3").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node4").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node5").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node6").isEmpty());
    }

    @Test
    public void testNonLeafResourceGroupsMerged() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node3", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node4", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node5", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("node6", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"50s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("local"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node1"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node2"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node3"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node4"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node5"));
        provider.registerNodeHeartbeat(this.createCoordinatorNodeStatus("node6"));
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        long query4Sequence = 0L;
        long query5Sequence = 0L;
        long query6Sequence = 0L;
        long query7Sequence = 0L;
        long query8Sequence = 0L;
        long query9Sequence = 0L;
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.WAITING_FOR_PREREQUISITES, "root.rg4", LocalMemoryManager.GENERAL_POOL), query1Sequence++);
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node1").isEmpty());
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 0, DataSize.valueOf((String)"1MB"));
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.QUEUED, "root.rg4", LocalMemoryManager.GENERAL_POOL), query2Sequence++);
        this.assertResourceGroup(provider, "node1", "root.rg4", 1, 0, DataSize.valueOf((String)"1MB"));
        this.assertNonLeafResourceGroup(provider, "node1", "root", 0, 0, 1, 0);
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 0, DataSize.valueOf((String)"1MB"));
        this.assertNonLeafResourceGroup(provider, "node2", "root", 0, 0, 0, 0);
        this.assertResourceGroup(provider, "node3", "root.rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node3", "root", 0, 0, 1, 0);
        provider.registerQueryHeartbeat("node3", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.RUNNING, "root.rg4", LocalMemoryManager.GENERAL_POOL), query3Sequence++);
        this.assertResourceGroup(provider, "node1", "root.rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node1", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node2", "root", 0, 0, 0, 1);
        this.assertResourceGroup(provider, "node3", "root.rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node3", "root", 0, 0, 1, 0);
        this.assertResourceGroup(provider, "node4", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node4", "root", 0, 0, 1, 1);
        provider.registerQueryHeartbeat("node4", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FINISHED, "root.rg4", LocalMemoryManager.GENERAL_POOL), query4Sequence++);
        this.assertResourceGroup(provider, "node1", "root.rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node1", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node2", "root", 0, 0, 0, 1);
        this.assertResourceGroup(provider, "node3", "root.rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node3", "root", 0, 0, 1, 0);
        this.assertResourceGroup(provider, "node4", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node4", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node5", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node5", "root", 0, 0, 1, 1);
        provider.registerQueryHeartbeat("node5", TestResourceManagerClusterStateProvider.createQueryInfo("5", QueryState.FAILED, "root.rg4", LocalMemoryManager.GENERAL_POOL), query5Sequence++);
        this.assertResourceGroup(provider, "node1", "root.rg4", 1, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node1", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 1, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node2", "root", 0, 0, 0, 1);
        this.assertResourceGroup(provider, "node3", "root.rg4", 1, 0, DataSize.valueOf((String)"2MB"));
        this.assertNonLeafResourceGroup(provider, "node3", "root", 0, 0, 1, 0);
        this.assertResourceGroup(provider, "node4", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node4", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node5", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node5", "root", 0, 0, 1, 1);
        this.assertResourceGroup(provider, "node6", "root.rg4", 1, 1, DataSize.valueOf((String)"3MB"));
        this.assertNonLeafResourceGroup(provider, "node6", "root", 0, 0, 1, 1);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("6", QueryState.WAITING_FOR_PREREQUISITES, "root.rg4", LocalMemoryManager.GENERAL_POOL), query5Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("7", QueryState.WAITING_FOR_RESOURCES, "root.rg4", LocalMemoryManager.GENERAL_POOL), query5Sequence++);
        provider.registerQueryHeartbeat("node2", TestResourceManagerClusterStateProvider.createQueryInfo("8", QueryState.DISPATCHING, "root.rg4", LocalMemoryManager.GENERAL_POOL), query6Sequence++);
        provider.registerQueryHeartbeat("node3", TestResourceManagerClusterStateProvider.createQueryInfo("9", QueryState.PLANNING, "root.rg4", LocalMemoryManager.GENERAL_POOL), query7Sequence++);
        provider.registerQueryHeartbeat("node4", TestResourceManagerClusterStateProvider.createQueryInfo("10", QueryState.STARTING, "root.rg4", LocalMemoryManager.GENERAL_POOL), query8Sequence++);
        provider.registerQueryHeartbeat("node5", TestResourceManagerClusterStateProvider.createQueryInfo("11", QueryState.FINISHING, "root.rg4", LocalMemoryManager.GENERAL_POOL), query9Sequence++);
        this.assertResourceGroup(provider, "node1", "root.rg4", 1, 5, DataSize.valueOf((String)"6MB"));
        this.assertNonLeafResourceGroup(provider, "node1", "root", 0, 0, 1, 5);
        this.assertResourceGroup(provider, "node2", "root.rg4", 0, 5, DataSize.valueOf((String)"7MB"));
        this.assertNonLeafResourceGroup(provider, "node2", "root", 0, 0, 0, 5);
        this.assertResourceGroup(provider, "node3", "root.rg4", 1, 4, DataSize.valueOf((String)"7MB"));
        this.assertNonLeafResourceGroup(provider, "node3", "root", 0, 0, 1, 4);
        this.assertResourceGroup(provider, "node4", "root.rg4", 1, 5, DataSize.valueOf((String)"8MB"));
        this.assertNonLeafResourceGroup(provider, "node4", "root", 0, 0, 1, 5);
        this.assertResourceGroup(provider, "node5", "root.rg4", 1, 5, DataSize.valueOf((String)"8MB"));
        this.assertNonLeafResourceGroup(provider, "node5", "root", 0, 0, 1, 5);
        this.assertResourceGroup(provider, "node6", "root.rg4", 1, 6, DataSize.valueOf((String)"9MB"));
        this.assertNonLeafResourceGroup(provider, "node6", "root", 0, 0, 1, 6);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        nodeManager.refreshNodes();
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node1").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node2").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node3").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node4").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node5").isEmpty());
        Assert.assertTrue((boolean)provider.getClusterResourceGroups("node6").isEmpty());
    }

    @Test(timeOut=15000L)
    public void testClusterMemoryPoolInfo() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("nodeId1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("nodeId2", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("nodeId3", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode("nodeId4", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)});
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"4s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 0, 0, 0, 0, 0, Optional.empty());
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId", LocalMemoryManager.GENERAL_POOL, this.createMemoryPoolInfo(100, 2, 1)));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 0, 0, 100, 2, 1, Optional.empty());
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
        provider.registerQueryHeartbeat("nodeId1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED, "rg4", LocalMemoryManager.GENERAL_POOL), query1Sequence++);
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 1, 0, 100, 2, 1, Optional.of("1"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId2", LocalMemoryManager.GENERAL_POOL, this.createMemoryPoolInfo(1000, 20, 10)));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 1, 0, 1100, 22, 11, Optional.of("1"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId3", LocalMemoryManager.GENERAL_POOL, this.createMemoryPoolInfo(1, 2, 3)));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 1, 1, 1101, 24, 14, Optional.of("1"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId4", LocalMemoryManager.RESERVED_POOL, this.createMemoryPoolInfo(5, 3, 2)));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 1, 1, 1101, 24, 14, Optional.of("1"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 5, 3, 2, Optional.empty());
        provider.registerQueryHeartbeat("nodeId2", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING, "rg4", LocalMemoryManager.GENERAL_POOL, DataSize.valueOf((String)"25GB").toBytes()), query2Sequence++);
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 2, 1, 1101, 24, 14, Optional.of("2"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 5, 3, 2, Optional.empty());
        provider.registerQueryHeartbeat("nodeId1", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.RUNNING, "rg4", LocalMemoryManager.RESERVED_POOL, DataSize.valueOf((String)"50GB").toBytes()), query3Sequence++);
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 2, 1, 1101, 24, 14, Optional.of("2"));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 1, 0, 5, 3, 2, Optional.empty());
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.GENERAL_POOL, 0, 0, 0, 0, 0, Optional.empty());
        this.assertMemoryPoolMap(provider, 2, LocalMemoryManager.RESERVED_POOL, 0, 0, 0, 0, 0, Optional.empty());
    }

    @DataProvider(name="resourceRuntimeHeartbeat")
    public static Object[][] resourceRuntimeHeartbeatTestData() {
        return new Object[][]{{ImmutableMap.of((Object)"node1", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user1")).addRunningQueries(2).addQueuedQueries(3).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build()), (Object)"node2", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user2")).addRunningQueries(5).addQueuedQueries(100).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build())), 18}, {ImmutableMap.of((Object)"node1", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user1")).addRunningQueries(2).addQueuedQueries(3).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build()), (Object)"node2", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user1")).addRunningQueries(5).addQueuedQueries(100).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build())), 13}};
    }

    @Test(timeOut=15000L, dataProvider="resourceRuntimeHeartbeat")
    public void testAdjustedQueueSize(Map<String, List<ResourceGroupRuntimeInfo>> nodeHeartBeats, int expectedAdjustedQueueSize) throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeHeartBeats.keySet().stream().forEach(nodeIdentifier -> nodeManager.addNode(new ConnectorId("x"), new InternalNode[]{new InternalNode(nodeIdentifier, URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true)}));
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"4s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"20s"), true, Executors.newSingleThreadScheduledExecutor());
        nodeHeartBeats.entrySet().stream().forEach(entry -> provider.registerResourceGroupRuntimeHeartbeat((String)entry.getKey(), (List)entry.getValue()));
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertEquals((int)provider.getAdjustedQueueSize(), (int)expectedAdjustedQueueSize);
    }

    @Test(timeOut=20000L)
    public void testWorkerMemoryInfo() throws Exception {
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)new InMemoryNodeManager(), SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        this.assertWorkerMemoryInfo(provider, 0);
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId", LocalMemoryManager.GENERAL_POOL, this.createMemoryPoolInfo(100, 2, 1)));
        this.assertWorkerMemoryInfo(provider, 1);
        provider.registerNodeHeartbeat(this.createNodeStatus("nodeId2", LocalMemoryManager.GENERAL_POOL, this.createMemoryPoolInfo(200, 20, 10)));
        this.assertWorkerMemoryInfo(provider, 2);
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        this.assertWorkerMemoryInfo(provider, 0);
    }

    @Test(timeOut=15000L)
    public void testShuttingDownCoordinatorHeartbeat() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addShuttingDownNode(new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true));
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        Assert.assertEquals((Collection)provider.getClusterQueries(), (Collection)ImmutableList.of());
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        long query4Sequence = 0L;
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED), query1Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING), query2Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.FINISHED), query3Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FAILED), query4Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 2);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.RUNNING), query1Sequence++);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.FINISHING), query2Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 2);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.FINISHED), query2Sequence++);
        this.assertQueryInfos(provider.getClusterQueries(), 4, 3);
    }

    @Test
    public void testRunningTaskCount() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addShuttingDownNode(new InternalNode("node1", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true));
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"0s"), Duration.valueOf((String)"4s"), true, Executors.newSingleThreadScheduledExecutor());
        Assert.assertEquals((int)provider.getRunningTaskCount(), (int)0);
        long query1Sequence = 0L;
        long query2Sequence = 0L;
        long query3Sequence = 0L;
        long query4Sequence = 0L;
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("1", QueryState.QUEUED), query1Sequence++);
        Assert.assertEquals((int)provider.getRunningTaskCount(), (int)0);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("2", QueryState.RUNNING), query2Sequence++);
        Assert.assertEquals((int)provider.getRunningTaskCount(), (int)11);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("3", QueryState.FINISHED), query3Sequence++);
        Assert.assertEquals((int)provider.getRunningTaskCount(), (int)11);
        provider.registerQueryHeartbeat("node1", TestResourceManagerClusterStateProvider.createQueryInfo("4", QueryState.FAILED), query4Sequence++);
        Assert.assertEquals((int)provider.getRunningTaskCount(), (int)11);
    }

    @Test
    public void testResourceGroupStatsExpiry() throws Exception {
        ImmutableMap resourceGroupStates = ImmutableMap.of((Object)"node1", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user1")).addRunningQueries(2).addQueuedQueries(3).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build()), (Object)"node2", (Object)ImmutableList.of((Object)ResourceGroupRuntimeInfo.builder((ResourceGroupId)new ResourceGroupId("global-user2")).addRunningQueries(5).addQueuedQueries(100).setResourceGroupSpecInfo(new ResourceGroupSpecInfo(20)).build()));
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        ResourceManagerClusterStateProvider provider = new ResourceManagerClusterStateProvider((InternalNodeManager)nodeManager, SessionPropertyManager.createTestingSessionPropertyManager(), 10, Duration.valueOf((String)"4s"), Duration.valueOf((String)"8s"), Duration.valueOf((String)"5s"), Duration.valueOf((String)"10s"), Duration.valueOf((String)"10s"), true, Executors.newSingleThreadScheduledExecutor());
        resourceGroupStates.entrySet().stream().forEach(entry -> provider.registerResourceGroupRuntimeHeartbeat((String)entry.getKey(), (List)entry.getValue()));
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        Assert.assertEquals((int)provider.getAdjustedQueueSize(), (int)18);
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        provider.registerResourceGroupRuntimeHeartbeat("node1", (List)resourceGroupStates.get("node1"));
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        Assert.assertEquals((int)provider.getAdjustedQueueSize(), (int)3);
    }

    void assertWorkerMemoryInfo(ResourceManagerClusterStateProvider provider, int count) {
        Map workerMemoryInfo = provider.getWorkerMemoryInfo();
        Assert.assertNotNull((Object)workerMemoryInfo);
        Assert.assertEquals((int)workerMemoryInfo.size(), (int)count);
    }

    private NodeStatus createNodeStatus(String nodeId, MemoryPoolId memoryPoolId, MemoryPoolInfo memoryPoolInfo) {
        return new NodeStatus(nodeId, new NodeVersion("1"), "environment", false, new Duration(1.0, TimeUnit.SECONDS), "http://externalAddress", "http://internalAddress", new MemoryInfo(new DataSize(1.0, DataSize.Unit.MEGABYTE), (Map)ImmutableMap.of((Object)memoryPoolId, (Object)memoryPoolInfo)), 1, 1.0, 2.0, 1L, 2L, 3L);
    }

    private NodeStatus createCoordinatorNodeStatus(String nodeId) {
        return new NodeStatus(nodeId, new NodeVersion("1"), "environment", true, new Duration(1.0, TimeUnit.SECONDS), "http://exernalAddress", "http://internalAddress", new MemoryInfo(new DataSize(1.0, DataSize.Unit.MEGABYTE), (Map)ImmutableMap.of((Object)LocalMemoryManager.GENERAL_POOL, (Object)this.createMemoryPoolInfo(100, 2, 1))), 1, 1.0, 2.0, 1L, 2L, 3L);
    }

    private MemoryPoolInfo createMemoryPoolInfo(int maxBytes, int reservedBytes, int reservedRevocableBytes) {
        return new MemoryPoolInfo((long)maxBytes, (long)reservedBytes, (long)reservedRevocableBytes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
    }

    private void assertQueryInfos(List<BasicQueryInfo> queryInfos, int count, int numberDone) {
        Assert.assertNotNull(queryInfos);
        Assert.assertEquals((int)queryInfos.size(), (int)count);
        Assert.assertEquals((long)queryInfos.stream().filter(info -> info.getState().isDone()).count(), (long)numberDone);
    }

    private void assertResourceGroups(ResourceManagerClusterStateProvider provider, String excludingNode, int count) throws ResourceManagerInconsistentException {
        List resourceGroups = provider.getClusterResourceGroups(excludingNode);
        Assert.assertNotNull((Object)resourceGroups);
        Assert.assertEquals((int)resourceGroups.size(), (int)count);
    }

    private void assertResourceGroup(ResourceManagerClusterStateProvider provider, String excludingNode, String resourceGroupId, int queuedQueries, int runningQueries, DataSize userMemoryReservation) throws ResourceManagerInconsistentException {
        ResourceGroupId currResourceGroupId = new ResourceGroupId(Arrays.asList(resourceGroupId.split("\\.")));
        List list = provider.getClusterResourceGroups(excludingNode);
        Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = list.stream().filter(resourceGroupInfo -> currResourceGroupId.equals((Object)resourceGroupInfo.getResourceGroupId())).findFirst();
        Assert.assertTrue((boolean)resourceGroupRuntimeInfo.isPresent(), (String)("Resource group " + resourceGroupId + " not found"));
        ResourceGroupRuntimeInfo info = resourceGroupRuntimeInfo.get();
        ResourceGroupId rg = new ResourceGroupId(Arrays.asList(resourceGroupId.split("\\.")));
        Assert.assertEquals((int)info.getQueuedQueries(), (int)queuedQueries, (String)String.format("Expected %s queued queries, found %s", queuedQueries, info.getQueuedQueries()));
        Assert.assertEquals((int)info.getRunningQueries(), (int)runningQueries, (String)String.format("Expected %s running queries, found %s", runningQueries, info.getRunningQueries()));
        Assert.assertEquals((Object)info.getResourceGroupId(), (Object)rg, (String)String.format("Expected resource group id %s, found %s", resourceGroupId, info.getResourceGroupId()));
        Assert.assertEquals((long)info.getMemoryUsageBytes(), (long)userMemoryReservation.toBytes(), (String)String.format("Expected %s user memory reservation found %s", userMemoryReservation, DataSize.succinctBytes((long)info.getMemoryUsageBytes())));
    }

    private void assertNonLeafResourceGroup(ResourceManagerClusterStateProvider provider, String excludingNode, String resourceGroupId, int queuedQueries, int runningQueries, int descendantQueuedQueries, int descendantRunningQueries) throws ResourceManagerInconsistentException {
        Optional<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo = provider.getClusterResourceGroups(excludingNode).stream().filter(resourceGroupInfo -> new ResourceGroupId(resourceGroupId).equals((Object)resourceGroupInfo.getResourceGroupId())).findFirst();
        Assert.assertTrue((boolean)resourceGroupRuntimeInfo.isPresent(), (String)("Resource group " + resourceGroupId + " not found"));
        ResourceGroupRuntimeInfo info = resourceGroupRuntimeInfo.get();
        Assert.assertEquals((int)info.getQueuedQueries(), (int)queuedQueries, (String)String.format("Expected %s queued queries, found %s", queuedQueries, info.getQueuedQueries()));
        Assert.assertEquals((int)info.getRunningQueries(), (int)runningQueries, (String)String.format("Expected %s running queries, found %s", runningQueries, info.getRunningQueries()));
        Assert.assertEquals((int)info.getDescendantQueuedQueries(), (int)descendantQueuedQueries, (String)String.format("Expected %s descendant queued queries, found %s", descendantQueuedQueries, info.getDescendantQueuedQueries()));
        Assert.assertEquals((int)info.getDescendantRunningQueries(), (int)descendantRunningQueries, (String)String.format("Expected %s descendant running queries, found %s", descendantRunningQueries, info.getDescendantRunningQueries()));
        Assert.assertEquals((Object)info.getResourceGroupId(), (Object)new ResourceGroupId(resourceGroupId), (String)String.format("Expected resource group id %s, found %s", resourceGroupId, info.getResourceGroupId()));
    }

    private void assertMemoryPoolMap(ResourceManagerClusterStateProvider provider, int memoryPoolSize, MemoryPoolId memoryPoolId, int assignedQueries, int blockedNodes, int maxBytes, int reservedBytes, int reservedRevocableBytes, Optional<String> largestMemoryQuery) {
        Map memoryPoolMap = provider.getClusterMemoryPoolInfo();
        Assert.assertNotNull((Object)memoryPoolMap);
        Assert.assertEquals((int)memoryPoolMap.size(), (int)memoryPoolSize);
        ClusterMemoryPoolInfo clusterMemoryPoolInfo = (ClusterMemoryPoolInfo)memoryPoolMap.get(memoryPoolId);
        Assert.assertNotNull((Object)clusterMemoryPoolInfo);
        Assert.assertEquals((int)clusterMemoryPoolInfo.getAssignedQueries(), (int)assignedQueries);
        Assert.assertEquals((int)clusterMemoryPoolInfo.getBlockedNodes(), (int)blockedNodes);
        Assert.assertEquals((long)clusterMemoryPoolInfo.getMemoryPoolInfo().getMaxBytes(), (long)maxBytes);
        Assert.assertEquals((long)clusterMemoryPoolInfo.getMemoryPoolInfo().getReservedBytes(), (long)reservedBytes);
        Assert.assertEquals((long)clusterMemoryPoolInfo.getMemoryPoolInfo().getReservedRevocableBytes(), (long)reservedRevocableBytes);
        Assert.assertEquals(clusterMemoryPoolInfo.getLargestMemoryQuery().map(QueryId::getId), largestMemoryQuery);
    }

    private static BasicQueryInfo createQueryInfo(String queryId, QueryState state) {
        return TestResourceManagerClusterStateProvider.createQueryInfo(queryId, state, "global", LocalMemoryManager.GENERAL_POOL);
    }

    private static BasicQueryInfo createQueryInfo(String queryId, QueryState state, String resourceGroupId, MemoryPoolId memoryPool) {
        return TestResourceManagerClusterStateProvider.createQueryInfo(queryId, state, resourceGroupId, memoryPool, DataSize.valueOf((String)"24GB").toBytes());
    }

    private static BasicQueryInfo createQueryInfo(String queryId, QueryState state, String resourceGroupIdString, MemoryPoolId memoryPool, long totalMemoryReservation) {
        ResourceGroupId resourceGroupId = new ResourceGroupId(Arrays.asList(resourceGroupIdString.split("\\.")));
        return new BasicQueryInfo(new QueryId(queryId), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), Optional.of(resourceGroupId), state, memoryPool, true, URI.create("1"), "", new BasicQueryStats(new DateTime((Object)"1991-09-06T05:00").getMillis(), new DateTime((Object)"1991-09-06T05:01").getMillis(), Duration.valueOf((String)"6m"), Duration.valueOf((String)"8m"), Duration.valueOf((String)"7m"), Duration.valueOf((String)"34m"), Duration.valueOf((String)"10m"), 11, 12, 13, 14, 15, 100, DataSize.valueOf((String)"21GB"), 22L, 23.0, 24.0, DataSize.valueOf((String)"1MB"), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.valueOf((String)"25GB"), DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"27GB"), DataSize.valueOf((String)"28GB"), Duration.valueOf((String)"23m"), Duration.valueOf((String)"24m"), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"123MB"), OptionalDouble.of(20.0)), null, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
    }
}

