/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.resourcemanager.ResourceManagerResourceGroupService;
import com.facebook.presto.resourcemanager.TestingResourceManagerClient;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResourceManagerResourceGroupService {
    @Test
    public void testGetResourceGroupInfo() throws Exception {
        TestingResourceManagerClient resourceManagerClient = new TestingResourceManagerClient();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        ResourceManagerConfig resourceManagerConfig = new ResourceManagerConfig();
        ResourceManagerResourceGroupService service = new ResourceManagerResourceGroupService((addressSelectionContext, headers) -> resourceManagerClient, resourceManagerConfig, (InternalNodeManager)nodeManager);
        List resourceGroupInfos = service.getResourceGroupInfo();
        Assert.assertNotNull((Object)resourceGroupInfos);
        Assert.assertTrue((boolean)resourceGroupInfos.isEmpty());
        Assert.assertEquals((int)resourceManagerClient.getResourceGroupInfoCalls("local"), (int)1);
        resourceManagerClient.setResourceGroupRuntimeInfos((List<ResourceGroupRuntimeInfo>)ImmutableList.of((Object)new ResourceGroupRuntimeInfo(new ResourceGroupId("global"), 1L, 2, 3, 0, 1, Optional.empty())));
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        resourceGroupInfos = service.getResourceGroupInfo();
        Assert.assertNotNull((Object)resourceGroupInfos);
        Assert.assertEquals((int)resourceGroupInfos.size(), (int)1);
        Assert.assertEquals((int)resourceManagerClient.getResourceGroupInfoCalls("local"), (int)2);
    }
}

