/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.BasicPrincipal;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.testing.TestingConnectorContext;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAccessControlManager {
    private static final Principal PRINCIPAL = new BasicPrincipal("principal");
    private static final String USER_NAME = "user_name";
    private static final String QUERY_TOKEN_FIELD = "query_token";
    private static final String QUERY_ID = "query_id";

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Presto server is still initializing")
    public void testInitializing() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.checkCanSetUser(new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), "foo");
    }

    @Test
    public void testNoneSystemAccessControl() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), USER_NAME);
    }

    @Test
    public void testReadOnlySystemAccessControl() {
        Identity identity = new Identity(USER_NAME, Optional.of(PRINCIPAL));
        QualifiedObjectName tableName = new QualifiedObjectName("catalog", "schema", "table");
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        AccessControlContext context = new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty());
        accessControlManager.setSystemAccessControl("read-only", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(identity, context, Optional.of(PRINCIPAL), USER_NAME);
        accessControlManager.checkCanSetSystemSessionProperty(identity, context, "property");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanSetCatalogSessionProperty(transactionId, identity, context, "catalog", "property");
            accessControlManager.checkCanShowSchemas(transactionId, identity, context, "catalog");
            accessControlManager.checkCanShowTablesMetadata(transactionId, identity, context, new CatalogSchemaName("catalog", "schema"));
            accessControlManager.checkCanSelectFromColumns(transactionId, identity, context, tableName, (Set)ImmutableSet.of((Object)new Subfield("column")));
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, (Set)ImmutableSet.of((Object)"column"));
            ImmutableSet catalogs = ImmutableSet.of((Object)"catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(identity, context, (Set)catalogs), (Set)catalogs);
            ImmutableSet schemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, identity, context, "catalog", (Set)schemas), (Set)schemas);
            ImmutableSet tableNames = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, identity, context, "catalog", (Set)tableNames), (Set)tableNames);
        });
        try {
            TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(transactionId, identity, context, tableName));
            Assert.fail();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAccessControl() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.of(PRINCIPAL), USER_NAME);
        Assert.assertEquals((String)accessControlFactory.getCheckedUserName(), (String)USER_NAME);
        Assert.assertEquals(accessControlFactory.getCheckedPrincipal(), Optional.of(PRINCIPAL));
    }

    @Test
    public void testCheckQueryIntegrity() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        AccessControlContext context = new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty());
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        String testQuery = "test_query";
        ImmutableMap viewDefinitions = ImmutableMap.of();
        ImmutableMap materializedViewDefinitions = ImmutableMap.of();
        accessControlManager.checkQueryIntegrity(new Identity(USER_NAME, Optional.of(PRINCIPAL), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)QUERY_TOKEN_FIELD, (Object)testQuery), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty()), context, testQuery, (Map)viewDefinitions, (Map)materializedViewDefinitions);
        Assert.assertEquals((String)accessControlFactory.getCheckedUserName(), (String)USER_NAME);
        Assert.assertEquals(accessControlFactory.getCheckedPrincipal(), Optional.of(PRINCIPAL));
        Assert.assertEquals((String)accessControlFactory.getCheckedQuery(), (String)testQuery);
        Assert.assertThrows(AccessDeniedException.class, () -> TestAccessControlManager.lambda$testCheckQueryIntegrity$2(accessControlManager, testQuery, context, (Map)viewDefinitions, (Map)materializedViewDefinitions));
    }

    @Test
    public void testNoCatalogAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)new Subfield("column"))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from columns \\[column\\] in table or view schema.table")
    public void testDenyCatalogAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        ConnectorId connectorId = TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "catalog");
        accessControlManager.addCatalogAccessControl(connectorId, (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)new Subfield("column"))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from table secured_catalog.schema.table")
    public void testDenySystemAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "connector");
        accessControlManager.addCatalogAccessControl(new ConnectorId("connector"), (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), new QualifiedObjectName("secured_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)new Subfield("column"))));
    }

    @Test
    public void testColumnMaskOrdering() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        accessControlManager.addSystemAccessControlFactory(new SystemAccessControlFactory(){

            public String getName() {
                return "test";
            }

            public SystemAccessControl create(Map<String, String> config) {
                return new SystemAccessControl(){

                    public Map<ColumnMetadata, ViewExpression> getColumnMasks(Identity identity, AccessControlContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
                        ImmutableMap.Builder columnMaskBuilder = ImmutableMap.builder();
                        for (ColumnMetadata column : columns) {
                            columnMaskBuilder.put((Object)column, (Object)new ViewExpression("user", Optional.empty(), Optional.empty(), "system mask"));
                        }
                        return columnMaskBuilder.buildOrThrow();
                    }

                    public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
                    }

                    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query, Map<QualifiedObjectName, ViewDefinition> viewDefinitions, Map<QualifiedObjectName, MaterializedViewDefinition> materializedViewDefinitionMap) {
                    }

                    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
                    }
                };
            }
        });
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        ConnectorId connectorId = TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "catalog");
        accessControlManager.addCatalogAccessControl(connectorId, new ConnectorAccessControl(){

            public Map<ColumnMetadata, ViewExpression> getColumnMasks(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
                ImmutableMap.Builder columnMaskBuilder = ImmutableMap.builder();
                for (ColumnMetadata column : columns) {
                    columnMaskBuilder.put((Object)column, (Object)new ViewExpression("user", Optional.empty(), Optional.empty(), "connector mask"));
                }
                return columnMaskBuilder.buildOrThrow();
            }
        });
        PrestoException exception = (PrestoException)Assert.expectThrows(PrestoException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.getColumnMasks(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new AccessControlContext(new QueryId(QUERY_ID), Optional.empty(), Collections.emptySet(), Optional.empty(), WarningCollector.NOOP, new RuntimeStats(), Optional.empty(), Optional.empty(), Optional.empty()), new QualifiedObjectName("catalog", "schema", "table"), (List)ImmutableList.of((Object)ColumnMetadata.builder().setName("column").setType((Type)BigintType.BIGINT).build()))));
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.INVALID_COLUMN_MASK.toErrorCode());
        Assert.assertEquals((String)exception.getMessage(), (String)"Multiple masks for the same column found");
    }

    private static ConnectorId registerBogusConnector(CatalogManager catalogManager, TransactionManager transactionManager, AccessControl accessControl, String catalogName) {
        ConnectorId connectorId = new ConnectorId(catalogName);
        Connector connector = new TpchConnectorFactory().create(catalogName, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId);
        catalogManager.registerCatalog(new Catalog(catalogName, connectorId, connector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, accessControl, (List)ImmutableList.of()), systemId, (Connector)new SystemConnector(systemId, (InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, connectorId))));
        return connectorId;
    }

    private static /* synthetic */ void lambda$testCheckQueryIntegrity$2(AccessControlManager accessControlManager, String testQuery, AccessControlContext context, Map viewDefinitions, Map materializedViewDefinitions) throws Throwable {
        accessControlManager.checkQueryIntegrity(new Identity(USER_NAME, Optional.of(PRINCIPAL), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)QUERY_TOKEN_FIELD, (Object)(testQuery + " modified")), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty()), context, testQuery, viewDefinitions, materializedViewDefinitions);
    }

    private static class TestSystemAccessControlFactory
    implements SystemAccessControlFactory {
        private final String name;
        private Map<String, String> config;
        private Optional<Principal> checkedPrincipal;
        private String checkedUserName;
        private String checkedQuery;
        private Map<QualifiedObjectName, ViewDefinition> checkedViewDefinitions;
        private Map<QualifiedObjectName, MaterializedViewDefinition> checkedMaterializedViewDefinitions;

        public TestSystemAccessControlFactory(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Optional<Principal> getCheckedPrincipal() {
            return this.checkedPrincipal;
        }

        public String getCheckedUserName() {
            return this.checkedUserName;
        }

        public String getCheckedQuery() {
            return this.checkedQuery;
        }

        public String getName() {
            return this.name;
        }

        public SystemAccessControl create(Map<String, String> config) {
            this.config = config;
            return new SystemAccessControl(){

                public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
                    checkedPrincipal = principal;
                    checkedUserName = userName;
                }

                public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query, Map<QualifiedObjectName, ViewDefinition> viewDefinitions, Map<QualifiedObjectName, MaterializedViewDefinition> materializedViewDefinitions) {
                    if (!query.equals(identity.getExtraCredentials().get(TestAccessControlManager.QUERY_TOKEN_FIELD))) {
                        AccessDeniedException.denyQueryIntegrityCheck();
                    }
                    checkedUserName = identity.getUser();
                    checkedPrincipal = identity.getPrincipal();
                    checkedQuery = query;
                    checkedViewDefinitions = viewDefinitions;
                    checkedMaterializedViewDefinitions = materializedViewDefinitions;
                }

                public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
                }

                public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
                    throw new UnsupportedOperationException();
                }

                public void checkCanSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
                    if (table.getCatalogName().equals("secured_catalog")) {
                        AccessDeniedException.denySelectTable((String)table.toString());
                    }
                }

                public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
                    return catalogs;
                }
            };
        }
    }

    private static class DenyConnectorAccessControl
    implements ConnectorAccessControl {
        private DenyConnectorAccessControl() {
        }

        public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<Subfield> columnOrSubfieldNames) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), (Collection)((Collection)columnOrSubfieldNames.stream().map(subfield -> subfield.getRootName()).collect(ImmutableSet.toImmutableSet())));
        }

        public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName, String newSchemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, SchemaTableName newTableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanUpdateTableColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> updatedColumns) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName, SchemaTableName newViewName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> columnNames) {
            throw new UnsupportedOperationException();
        }

        public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String propertyName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropConstraint(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanAddConstraint(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }
    }
}

