/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestInternalCommunicationConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((InternalCommunicationConfig)ConfigAssertions.recordDefaults(InternalCommunicationConfig.class)).setHttpsRequired(false).setKeyStorePath(null).setKeyStorePassword(null).setTrustStorePath(null).setTrustStorePassword(null).setKerberosEnabled(false).setIncludedCipherSuites(null).setExcludeCipherSuites(null).setKerberosUseCanonicalHostname(true).setBinaryTransportEnabled(false).setMaxTaskUpdateSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setTaskCommunicationProtocol(InternalCommunicationConfig.CommunicationProtocol.HTTP).setServerInfoCommunicationProtocol(InternalCommunicationConfig.CommunicationProtocol.HTTP).setThriftTransportEnabled(false).setTaskInfoThriftTransportEnabled(false).setThriftProtocol(Protocol.BINARY).setMemoizeDeadNodesEnabled(false).setSharedSecret(null).setTaskUpdateRequestThriftSerdeEnabled(false).setTaskInfoResponseThriftSerdeEnabled(false).setInternalJwtEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"internal-communication.https.required", (Object)"true").put((Object)"internal-communication.https.keystore.path", (Object)"/a").put((Object)"internal-communication.https.trust-store-path", (Object)"/a").put((Object)"internal-communication.https.trust-store-password", (Object)"key").put((Object)"internal-communication.https.keystore.key", (Object)"key").put((Object)"internal-communication.https.included-cipher", (Object)"cipher").put((Object)"internal-communication.https.excluded-cipher", (Object)"").put((Object)"internal-communication.kerberos.enabled", (Object)"true").put((Object)"internal-communication.kerberos.use-canonical-hostname", (Object)"false").put((Object)"experimental.internal-communication.binary-transport-enabled", (Object)"true").put((Object)"experimental.internal-communication.max-task-update-size", (Object)"512MB").put((Object)"internal-communication.task-communication-protocol", (Object)"THRIFT").put((Object)"internal-communication.server-info-communication-protocol", (Object)"THRIFT").put((Object)"experimental.internal-communication.thrift-transport-enabled", (Object)"true").put((Object)"experimental.internal-communication.task-info-thrift-transport-enabled", (Object)"true").put((Object)"experimental.internal-communication.thrift-transport-protocol", (Object)"COMPACT").put((Object)"internal-communication.memoize-dead-nodes-enabled", (Object)"true").put((Object)"internal-communication.shared-secret", (Object)"secret").put((Object)"internal-communication.jwt.enabled", (Object)"true").put((Object)"experimental.internal-communication.task-update-request-thrift-serde-enabled", (Object)"true").put((Object)"experimental.internal-communication.task-info-response-thrift-serde-enabled", (Object)"true").build();
        InternalCommunicationConfig expected = new InternalCommunicationConfig().setHttpsRequired(true).setKeyStorePath("/a").setKeyStorePassword("key").setTrustStorePath("/a").setTrustStorePassword("key").setIncludedCipherSuites("cipher").setExcludeCipherSuites("").setKerberosEnabled(true).setKerberosUseCanonicalHostname(false).setBinaryTransportEnabled(true).setMaxTaskUpdateSize(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setTaskCommunicationProtocol(InternalCommunicationConfig.CommunicationProtocol.THRIFT).setServerInfoCommunicationProtocol(InternalCommunicationConfig.CommunicationProtocol.THRIFT).setThriftTransportEnabled(true).setTaskInfoThriftTransportEnabled(true).setThriftProtocol(Protocol.COMPACT).setMemoizeDeadNodesEnabled(true).setSharedSecret("secret").setInternalJwtEnabled(true).setTaskUpdateRequestThriftSerdeEnabled(true).setTaskInfoResponseThriftSerdeEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

