/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParseToJsonData {
    @Test
    public void testParseData() {
        this.assertParsingResult("map(map(bigint,bigint),bigint)", ImmutableMap.of((Object)ImmutableMap.of((Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L, (Object)6L), (Object)3L), "{\n  \"{\\n  \\\"1\\\" : 2,\\n  \\\"5\\\" : 6,\\n  \\\"3\\\" : 4\\n}\" : 3\n}");
        this.assertParsingResult("map(row(foo bigint,bar double),bigint)", ImmutableMap.of((Object)ImmutableList.of((Object)1L, (Object)2.0), (Object)3L, (Object)ImmutableList.of((Object)4L, (Object)5.0), (Object)6L), "{\n  \"[ 4, 5.0 ]\" : 6,\n  \"[ 1, 2.0 ]\" : 3\n}");
        this.assertParsingResult("map(array(bigint),bigint)", ImmutableMap.of((Object)ImmutableList.of((Object)1L, (Object)3L, (Object)2L, (Object)3L), (Object)3L), "{\n  \"[ 1, 3, 2, 3 ]\" : 3\n}");
        this.assertParsingResult("array(array(bigint))", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ImmutableList.of((Object)4L, (Object)5L, (Object)6L)), "[ \"[ 1, 2, 3 ]\", \"[ 4, 5, 6 ]\" ]");
        this.assertParsingResult("array(map(bigint,bigint))", ImmutableList.of((Object)ImmutableMap.of((Object)1L, (Object)2L, (Object)3L, (Object)4L), (Object)ImmutableMap.of((Object)5L, (Object)6L, (Object)7L, (Object)8L)), "[ \"{\\n  \\\"1\\\" : 2,\\n  \\\"3\\\" : 4\\n}\", \"{\\n  \\\"5\\\" : 6,\\n  \\\"7\\\" : 8\\n}\" ]");
        this.assertParsingResult("array(row(foo bigint,bar double))", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2.0), (Object)ImmutableList.of((Object)3L, (Object)4.0)), "[ \"[ 1, 2.0 ]\", \"[ 3, 4.0 ]\" ]");
        this.assertParsingResult("row(foo array(bigint),bar double)", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)3.0), "[ \"[ 1, 2 ]\", 3.0 ]");
        this.assertParsingResult("row(foo map(bigint,bigint),bar double)", ImmutableList.of((Object)ImmutableMap.of((Object)1L, (Object)2L), (Object)3.0), "[ \"{\\n  \\\"1\\\" : 2\\n}\", 3.0 ]");
        this.assertParsingResult("row(foo row(x bigint,y double),bar double)", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2.0), (Object)3.0), "[ \"[ 1, 2.0 ]\", 3.0 ]");
        this.assertParsingResult("map(row(x map(bigint,bigint), y varchar),bigint)", ImmutableMap.of((Object)ImmutableList.of((Object)ImmutableMap.of((Object)1L, (Object)2L), (Object)"{123: 2245}"), (Object)1L), "{\n  \"[ \\\"{\\\\n  \\\\\\\"1\\\\\\\" : 2\\\\n}\\\", \\\"{123: 2245}\\\" ]\" : 1\n}");
        this.assertNestedJson("map(json,bigint)", "{\"123\":\"456\"}");
        this.assertNestedJson("map(varchar,bigint)", "{\"12\":\"34\", \"56\":\"78\"}");
    }

    private void assertNestedJson(String type, String expected) {
        ImmutableMap data = ImmutableMap.of((Object)JsonCodec.jsonCodec(String.class).toJson((Object)expected), (Object)1L);
        Object parsedData = QueryResourceUtil.parseToJson((TypeSignature)TypeSignature.parseTypeSignature((String)type), (Object)data);
        Map fixedValue = (Map)JsonCodec.mapJsonCodec(String.class, String.class).fromJson((String)parsedData);
        Assert.assertEquals((String)((String)JsonCodec.jsonCodec(String.class).fromJson((String)fixedValue.keySet().iterator().next())), (String)expected);
    }

    private void assertParsingResult(String type, Object data, String expected) {
        Assert.assertEquals((Object)QueryResourceUtil.parseToJson((TypeSignature)TypeSignature.parseTypeSignature((String)type), (Object)data), (Object)expected);
    }
}

