/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.security.BasicPrincipal;
import com.facebook.presto.server.MockHttpServletRequest;
import com.facebook.presto.server.security.PrestoAuthenticatorManager;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.PrestoAuthenticator;
import com.facebook.presto.spi.security.PrestoAuthenticatorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCustomPrestoAuthenticator {
    private static final String TEST_HEADER = "test_header";
    private static final String TEST_HEADER_VALID_VALUE = "VALID";
    private static final String TEST_HEADER_INVALID_VALUE = "INVALID";
    private static final String TEST_FACTORY = "test_factory";
    private static final String TEST_USER = "TEST_USER";
    private static final String TEST_REMOTE_ADDRESS = "remoteAddress";

    @Test
    public void testPrestoAuthenticator() {
        SecurityConfig mockSecurityConfig = new SecurityConfig();
        mockSecurityConfig.setAuthenticationTypes((List)ImmutableList.of((Object)SecurityConfig.AuthenticationType.CUSTOM));
        PrestoAuthenticatorManager prestoAuthenticatorManager = new PrestoAuthenticatorManager(mockSecurityConfig);
        prestoAuthenticatorManager.addPrestoAuthenticatorFactory((PrestoAuthenticatorFactory)new TestingPrestoAuthenticatorFactory(TEST_FACTORY, TEST_HEADER_VALID_VALUE));
        prestoAuthenticatorManager.loadAuthenticator(TEST_FACTORY);
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.of((Object)TEST_HEADER, (Object)"VALID:TEST_USER"), TEST_REMOTE_ADDRESS, (Map<String, Object>)ImmutableMap.of());
        Optional<Principal> principal = this.checkAuthentication(prestoAuthenticatorManager.getAuthenticator(), request);
        Assert.assertTrue((boolean)principal.isPresent());
        Assert.assertEquals((String)principal.get().getName(), (String)TEST_USER);
        request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.of((Object)TEST_HEADER, (Object)"INVALID:TEST_USER"), TEST_REMOTE_ADDRESS, (Map<String, Object>)ImmutableMap.of());
        principal = this.checkAuthentication(prestoAuthenticatorManager.getAuthenticator(), request);
        Assert.assertFalse((boolean)principal.isPresent());
    }

    private Optional<Principal> checkAuthentication(PrestoAuthenticator authenticator, HttpServletRequest request) {
        try {
            Map<String, List<String>> headers = this.getHeadersMap(request);
            return Optional.of(authenticator.createAuthenticatedPrincipal(headers));
        }
        catch (AccessDeniedException e) {
            return Optional.empty();
        }
    }

    private Map<String, List<String>> getHeadersMap(HttpServletRequest request) {
        return (Map)Collections.list(request.getHeaderNames()).stream().collect(ImmutableMap.toImmutableMap(headerName -> headerName, headerName -> Collections.list(request.getHeaders(headerName))));
    }

    private static class TestingPrestoAuthenticatorFactory
    implements PrestoAuthenticatorFactory {
        private final String name;
        private final String validHeaderValue;

        TestingPrestoAuthenticatorFactory(String name, String validHeaderValue) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.validHeaderValue = Objects.requireNonNull(validHeaderValue, "validHeaderValue is null");
        }

        public String getName() {
            return this.name;
        }

        public PrestoAuthenticator create(Map<String, String> config) {
            return headers -> {
                String[] header = ((String)((List)headers.get(TestCustomPrestoAuthenticator.TEST_HEADER)).get(0)).split(":");
                if (header[0].equals(this.validHeaderValue)) {
                    return new BasicPrincipal(header[1]);
                }
                throw new AccessDeniedException("Authentication Failed!");
            };
        }
    }
}

