/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.TestingSpillContext;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestBinaryFileSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
    private BlockEncodingSerde blockEncodingSerde;
    private File spillPath = Files.createTempDir();
    private SpillerStats spillerStats;
    private FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private SpillerFactory factory;
    private PagesSerde pagesSerde;
    private AggregatedMemoryContext memoryContext;

    @BeforeMethod
    public void setUp() {
        this.blockEncodingSerde = new BlockEncodingManager();
        this.spillerStats = new SpillerStats();
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setSpillerSpillPaths(this.spillPath.getAbsolutePath());
        featuresConfig.setSpillMaxUsedSpaceThreshold(1.0);
        NodeSpillConfig nodeSpillConfig = new NodeSpillConfig();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.blockEncodingSerde, this.spillerStats, featuresConfig, nodeSpillConfig);
        this.factory = new GenericSpillerFactory((SingleStreamSpillerFactory)this.singleStreamSpillerFactory);
        PagesSerdeFactory pagesSerdeFactory = new PagesSerdeFactory(Objects.requireNonNull(this.blockEncodingSerde, "blockEncodingSerde is null"), nodeSpillConfig.getSpillCompressionCodec());
        this.pagesSerde = pagesSerdeFactory.createPagesSerde();
        this.memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.singleStreamSpillerFactory.destroy();
        MoreFiles.deleteRecursively((Path)this.spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testFileSpiller() throws Exception {
        try (Spiller spiller = this.factory.create(TYPES, (SpillContext)new TestingSpillContext(), this.memoryContext);){
            this.testSimpleSpiller(spiller);
        }
    }

    @Test
    public void testFileVarbinarySpiller() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        Page page = new Page(new Block[]{col1.build(), col2.build(), col3.build()});
        try (Spiller spiller = this.factory.create(TYPES, (SpillContext)new TestingSpillContext(), this.memoryContext);){
            this.testSpiller((List<Type>)types, spiller, new List[]{ImmutableList.of((Object)page)});
        }
    }

    private void testSimpleSpiller(Spiller spiller) throws ExecutionException, InterruptedException {
        RowPagesBuilder builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 0, 5, 10, 15);
        builder.pageBreak();
        builder.addSequencePage(10, 0, -5, -10, -15);
        List<Page> firstSpill = builder.build();
        builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 10, 15, 20, 25);
        builder.pageBreak();
        builder.addSequencePage(10, -10, -15, -20, -25);
        List<Page> secondSpill = builder.build();
        this.testSpiller(TYPES, spiller, firstSpill, secondSpill);
    }

    private void testSpiller(List<Type> types, Spiller spiller, List<Page> ... spills) throws ExecutionException, InterruptedException {
        long spilledBytesBefore = this.spillerStats.getTotalSpilledBytes();
        long spilledBytesReadBefore = this.spillerStats.getTotalSpilledBytesRead();
        long spilledBytes = 0L;
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)0L);
        for (List<Page> spill : spills) {
            spilledBytes += spill.stream().mapToLong(page -> this.pagesSerde.serialize(page).getSizeInBytes()).sum();
            spiller.spill(spill.iterator()).get();
        }
        Assert.assertEquals((long)(this.spillerStats.getTotalSpilledBytes() - spilledBytesBefore), (long)spilledBytes);
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)(spills.length * 4096));
        List actualSpills = spiller.getSpills();
        Assert.assertEquals((int)actualSpills.size(), (int)spills.length);
        long readSpilledBytes = 0L;
        for (int i = 0; i < actualSpills.size(); ++i) {
            ImmutableList actualSpill = ImmutableList.copyOf((Iterator)((Iterator)actualSpills.get(i)));
            List<Page> expectedSpill = spills[i];
            Assert.assertEquals((int)actualSpill.size(), (int)expectedSpill.size());
            for (int j = 0; j < actualSpill.size(); ++j) {
                Page actualSpillPage = (Page)actualSpill.get(j);
                PageAssertions.assertPageEquals(types, actualSpillPage, expectedSpill.get(j));
                readSpilledBytes += actualSpillPage.getSizeInBytes();
            }
        }
        Assert.assertEquals((long)(this.spillerStats.getTotalSpilledBytesRead() - spilledBytesReadBefore), (long)readSpilledBytes);
        spiller.close();
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)0L);
    }
}

