/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.CompressionCodec;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeSpillConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSpillConfig)ConfigAssertions.recordDefaults(NodeSpillConfig.class)).setMaxSpillPerNode(new DataSize(100.0, DataSize.Unit.GIGABYTE)).setMaxRevocableMemoryPerNode(new DataSize(16.0, DataSize.Unit.GIGABYTE)).setQueryMaxSpillPerNode(new DataSize(100.0, DataSize.Unit.GIGABYTE)).setSpillCompressionCodec(CompressionCodec.NONE).setSpillEncryptionEnabled(false).setTempStorageBufferSize(new DataSize(4.0, DataSize.Unit.KILOBYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"experimental.max-spill-per-node", (Object)"10MB").put((Object)"experimental.max-revocable-memory-per-node", (Object)"24MB").put((Object)"experimental.query-max-spill-per-node", (Object)"15 MB").put((Object)"experimental.spill-compression-codec", (Object)"LZ4").put((Object)"experimental.spill-encryption-enabled", (Object)"true").put((Object)"experimental.temp-storage-buffer-size", (Object)"24MB").build();
        NodeSpillConfig expected = new NodeSpillConfig().setMaxSpillPerNode(new DataSize(10.0, DataSize.Unit.MEGABYTE)).setMaxRevocableMemoryPerNode(new DataSize(24.0, DataSize.Unit.MEGABYTE)).setQueryMaxSpillPerNode(new DataSize(15.0, DataSize.Unit.MEGABYTE)).setSpillCompressionCodec(CompressionCodec.LZ4).setSpillEncryptionEnabled(true).setTempStorageBufferSize(new DataSize(24.0, DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

