/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.CompressionCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.buffer.TestingPagesSerdeFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.AesSpillCipher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSpillCipherPagesSerde {
    @Test
    public void test() {
        AesSpillCipher cipher = new AesSpillCipher();
        PagesSerde serde = new TestingPagesSerdeFactory(CompressionCodec.LZ4).createPagesSerdeForSpill(Optional.of(cipher));
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        Page emptyPage = new Page(new Block[]{VarcharType.VARCHAR.createBlockBuilder(null, 0).build()});
        PageAssertions.assertPageEquals((List<? extends Type>)types, serde.deserialize(serde.serialize(emptyPage)), emptyPage);
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 2);
        VarcharType.VARCHAR.writeString(blockBuilder, "hello");
        VarcharType.VARCHAR.writeString(blockBuilder, "world");
        Page helloWorldPage = new Page(new Block[]{blockBuilder.build()});
        SerializedPage serialized = serde.serialize(helloWorldPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, serde.deserialize(serialized), helloWorldPage);
        Assert.assertTrue((boolean)PageCodecMarker.ENCRYPTED.isSet(serialized.getPageCodecMarkers()), (String)"page should be encrypted");
        cipher.destroy();
        TestSpillCipherPagesSerde.assertFailure(() -> serde.serialize(helloWorldPage), "Spill cipher already destroyed");
        TestSpillCipherPagesSerde.assertFailure(() -> serde.deserialize(serialized), "Spill cipher already destroyed");
    }

    private static void assertFailure(Assert.ThrowingRunnable runnable, String expectedErrorMessage) {
        PrestoException exception = (PrestoException)Assert.expectThrows(PrestoException.class, (Assert.ThrowingRunnable)runnable);
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)exception.getMessage(), (String)expectedErrorMessage);
    }
}

