/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.type.LikeFunctions;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLikeFunctions
extends AbstractTestFunctions {
    private static Slice offsetHeapSlice(String value) {
        Slice source = Slices.utf8Slice((String)value);
        Slice result = Slices.allocate((int)(source.length() + 5));
        result.setBytes(2, source);
        return result.slice(2, source.length());
    }

    @Test
    public void testLikeBasic() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"f%b__"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foobar"), (Regex)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (Regex)regex));
        this.assertFunction("'foob' LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foob' LIKE 'f%b'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLikeChar() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"f%b__"));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foobar"), (Regex)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (Regex)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foob"), (Regex)regex));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (Regex)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)Slices.utf8Slice((String)"foob"), (Regex)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (Regex)regex));
        this.assertFunction("cast('foob' as char(6)) LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('foob' as char(7)) LIKE 'f%b__'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLikeSpacesInPattern() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"ala  "));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (Regex)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (Regex)regex));
        regex = LikeFunctions.castCharToLikePattern((Long)5L, (Slice)Slices.utf8Slice((String)"ala"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (Regex)regex));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineInPattern() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%o\nbar"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineBeforeMatch() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineNoWildcard() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"foo\nbar"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNoMatchAfterNewline() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"foo"));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineInMatch() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"f%b%"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineInSingleWildcardMatch() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"foo_bar"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeUtf8Pattern() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%\u540d\u8a89%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo"), (Regex)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeInvalidUtf8Value() {
        Slice value = Slices.wrappedBuffer((byte[])new byte[]{97, 98, 99, -1, 120, 121});
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)value, (Regex)regex));
    }

    @Test
    public void testBackslashesNoSpecialTreatment() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"), (Regex)regex));
    }

    @Test
    public void testSelfEscaping() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\\\abc\\%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc%"), (Regex)regex));
    }

    @Test
    public void testAlternateEscapedCharacters() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"xxx%x_abcxx"), (Slice)Slices.utf8Slice((String)"x"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"x%_abcx"), (Regex)regex));
    }

    @Test
    public void testInvalidLikePattern() {
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"#"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#abc"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"c#")));
    }

    @Test
    public void testIsLikePattern() {
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc"), null));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#_def"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc##def"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#%def"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc%def"), null));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef_"), null));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef##_"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"%abcdef#_"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"#"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#abc"), (Slice)Slices.utf8Slice((String)"#")));
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"#")));
    }

    @Test
    public void testUnescapeValidLikePattern() {
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc"), null), (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc#_"), (Slice)Slices.utf8Slice((String)"#")), (Object)Slices.utf8Slice((String)"abc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a##bc#_"), (Slice)Slices.utf8Slice((String)"#")), (Object)Slices.utf8Slice((String)"a#bc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a###_bc"), (Slice)Slices.utf8Slice((String)"#")), (Object)Slices.utf8Slice((String)"a#_bc"));
    }

    @Test
    public void testUnescapeInvalidLikePattern() {
        Assert.assertThrows(PrestoException.class, () -> LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc"), (Slice)Slices.utf8Slice((String)"ab")));
    }
}

