/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeUtils {
    @Test
    public void testMapFromProperties() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        propertyList.add(new Property(new Identifier("a"), (Expression)new StringLiteral("apple")));
        propertyList.add(new Property(new Identifier("b"), (Expression)new StringLiteral("ball")));
        Map stringExpressionMap = NodeUtils.mapFromProperties(propertyList);
        Assert.assertEquals((int)2, (int)stringExpressionMap.size());
        Assert.assertEquals((Object)new StringLiteral("apple"), stringExpressionMap.get("a"));
        Assert.assertEquals((Object)new StringLiteral("ball"), stringExpressionMap.get("b"));
    }

    @Test
    public void testDuplicateKeyFromProperties() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        propertyList.add(new Property(new Identifier("partitioned_by"), (Expression)new ArrayConstructor((List)ImmutableList.of((Object)new StringLiteral("ds")))));
        propertyList.add(new Property(new Identifier("partitioned_by"), (Expression)new ArrayConstructor((List)ImmutableList.of((Object)new StringLiteral("source")))));
        try {
            NodeUtils.mapFromProperties(propertyList);
            Assert.fail((String)"PrestoException not thrown for duplicate properties");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PrestoException), (String)String.format("Expected PrestoException but found %s", e));
            PrestoException prestoException = (PrestoException)((Object)e);
            Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)StandardErrorCode.SYNTAX_ERROR.toErrorCode());
            Assert.assertEquals((String)prestoException.getMessage(), (String)"Duplicate property found: partitioned_by=ARRAY['ds'] and partitioned_by=ARRAY['source']");
        }
    }
}

