/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.AbstractAnalyzerTest;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestColumnAndSubfieldAnalyzer
extends AbstractAnalyzerTest {
    @Test
    public void testCardinality() {
        this.assertTableColumns("SELECT cardinality(a) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
        this.assertTableColumns("SELECT transform(b.x, yo -> cardinality(yo)) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
    }

    public void testIsNull() {
        this.assertTableColumns("SELECT a IS NULL FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
        this.assertTableColumns("SELECT transform(b.x, yo -> yo IS NULL) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
    }

    public void testIsNotNull() {
        this.assertTableColumns("SELECT a IS NOT NULL FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
        this.assertTableColumns("SELECT transform(b.x, yo -> yo IS NOT NULL) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of()));
    }

    @Test
    public void testTransform() {
        this.assertTableColumns("SELECT transform(a, yo -> yo.x + yo.y) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"a.x", (Object)"a.y")));
        this.assertTableColumns("SELECT transform(a, yo -> yo) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"a")));
        this.assertTableColumns("SELECT transform(c.x, yo -> yo.x) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"c.x.x")));
        this.assertTableColumns("SELECT transform(c.x, yo -> yo[1]) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"c.x.x")));
        this.assertTableColumns("SELECT transform(b.x, yo -> transform(yo, yoo -> yoo.y)) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT transform(tbl.b.x, yo -> transform(yo, yoo -> yoo.y)) FROM tpch.s1.t11 tbl", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT transform(reverse(a), yo -> yo.x + yo.y) FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"a")));
    }

    @Test
    public void testSelect() {
        this.assertTableColumns("SELECT * FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c")));
        this.assertTableColumns("SELECT a, b FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"a", (Object)"b")));
        this.assertTableColumns("SELECT b.w, b.x.y FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b.w", (Object)"b.x.y")));
        this.assertTableColumns("SELECT b, b.x FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b", (Object)"b.x")));
        this.assertTableColumns("SELECT b[2][1], b[2].z FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b.x.y", (Object)"b.x.z")));
        this.assertTableColumns("SELECT b.x[0][6].y FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT b[2][0][6].y FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT b[2][0][6][1] FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT b.x[0][6] FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x")));
        this.assertTableColumns("SELECT b[2][0][6] FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"b.x")));
        this.assertTableColumns("SELECT a[0].x FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"a.x")));
        this.assertTableColumns("SELECT a[0] FROM tpch.s1.t11", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t11"), (Object)ImmutableSet.of((Object)"a")));
    }

    @Test
    public void testSelectSpecialCharacter() {
        this.assertTableColumns("SELECT * FROM tpch.s1.t12", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t12"), (Object)ImmutableSet.of((Object)"a.x", (Object)"a&^[x")));
    }

    @Test
    public void testSelectWithAlias() {
        this.assertTableColumns("SELECT g.b, g.b.x FROM tpch.s1.t10 g", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b", (Object)"b.x")));
        this.assertTableColumns("SELECT g.b AS col0, g.b.x AS col1 FROM tpch.s1.t10 g", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b", (Object)"b.x")));
        this.assertTableColumns("SELECT tpch.s1.t10.b, t10.b.x FROM tpch.s1.t10", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b", (Object)"b.x")));
    }

    @Test
    public void testNonSelect() {
        this.assertTableColumns("SELECT b.w FROM tpch.s1.t10 WHERE b.x.y = 1", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b.w", (Object)"b.x.y")));
        this.assertTableColumns("SELECT count(*) FROM tpch.s1.t10 GROUP BY b.x.y", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b.x.y")));
        this.assertTableColumns("SELECT b.x FROM tpch.s1.t10 GROUP BY 1", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b.x")));
    }

    @Test
    public void testUtillized() {
        this.assertUtilizedTableColumns("SELECT b.x FROM (SELECT * from tpch.s1.t10)", (Map<QualifiedObjectName, Set<String>>)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b", (Object)"b.x")));
    }

    private void assertTableColumns(@Language(value="SQL") String query, Map<QualifiedObjectName, Set<String>> expected, boolean utilized) {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("s1").setSystemProperty("check_access_control_with_subfields", "true").setSystemProperty("check_access_control_on_utilized_columns_only", utilized ? "true" : "false").build();
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().readOnly().execute(session, s -> {
            Analyzer analyzer = TestColumnAndSubfieldAnalyzer.createAnalyzer(s, this.metadata, WarningCollector.NOOP, query);
            Statement statement = SQL_PARSER.createStatement(query);
            Analysis analysis = analyzer.analyze(statement);
            Assert.assertEquals((Map)((Map)((Map)analysis.getAccessControlReferences().getTableColumnAndSubfieldReferencesForAccessControl().values().stream().findFirst().get()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableSet)((Set)entry.getValue()).stream().map(Subfield::toString).collect(ImmutableSet.toImmutableSet())))), (Map)expected);
        });
    }

    private void assertTableColumns(@Language(value="SQL") String query, Map<QualifiedObjectName, Set<String>> expected) {
        this.assertTableColumns(query, expected, false);
    }

    private void assertUtilizedTableColumns(@Language(value="SQL") String query, Map<QualifiedObjectName, Set<String>> expected) {
        this.assertTableColumns(query, expected, true);
    }
}

