/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestFunctionsConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FunctionsConfig)ConfigAssertions.recordDefaults(FunctionsConfig.class)).setLegacyArrayAgg(false).setUseAlternativeFunctionSignatures(false).setLegacyMapSubscript(false).setReduceAggForComplexTypesEnabled(true).setLegacyLogFunction(false).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setRegexLibrary(RegexLibrary.JONI).setKHyperLogLogAggregationGroupNumberLimit(0L).setLimitNumberOfGroupsForKHyperLogLogAggregations(true).setUseNewNanDefinition(true).setHistogramGroupImplementation(HistogramGroupImplementation.NEW).setArrayAggGroupImplementation(ArrayAggGroupImplementation.NEW).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.NEW).setLegacyRowFieldOrdinalAccess(false).setLegacyTimestamp(true).setParseDecimalLiteralsAsDouble(false).setFieldNamesInJsonCastEnabled(false).setWarnOnCommonNanPatterns(false).setLegacyCharToVarcharCoercion(false).setLegacyJsonCast(true).setCanonicalizedJsonExtract(false).setDefaultNamespacePrefix(BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE.toString()));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"deprecated.legacy-array-agg", (Object)"true").put((Object)"use-alternative-function-signatures", (Object)"true").put((Object)"deprecated.legacy-map-subscript", (Object)"true").put((Object)"reduce-agg-for-complex-types-enabled", (Object)"false").put((Object)"deprecated.legacy-log-function", (Object)"true").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"regex-library", (Object)"RE2J").put((Object)"khyperloglog-agg-group-limit", (Object)"1000").put((Object)"limit-khyperloglog-agg-group-number-enabled", (Object)"false").put((Object)"use-new-nan-definition", (Object)"false").put((Object)"histogram.implementation", (Object)"LEGACY").put((Object)"arrayagg.implementation", (Object)"LEGACY").put((Object)"multimapagg.implementation", (Object)"LEGACY").put((Object)"deprecated.legacy-row-field-ordinal-access", (Object)"true").put((Object)"deprecated.legacy-timestamp", (Object)"false").put((Object)"parse-decimal-literals-as-double", (Object)"true").put((Object)"field-names-in-json-cast-enabled", (Object)"true").put((Object)"warn-on-common-nan-patterns", (Object)"true").put((Object)"deprecated.legacy-char-to-varchar-coercion", (Object)"true").put((Object)"legacy-json-cast", (Object)"false").put((Object)"presto.default-namespace", (Object)"native.default").put((Object)"canonicalized-json-extract", (Object)"true").build();
        FunctionsConfig expected = new FunctionsConfig().setLegacyArrayAgg(true).setUseAlternativeFunctionSignatures(true).setLegacyMapSubscript(true).setReduceAggForComplexTypesEnabled(false).setLegacyLogFunction(true).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setRegexLibrary(RegexLibrary.RE2J).setKHyperLogLogAggregationGroupNumberLimit(1000L).setLimitNumberOfGroupsForKHyperLogLogAggregations(false).setUseNewNanDefinition(false).setHistogramGroupImplementation(HistogramGroupImplementation.LEGACY).setArrayAggGroupImplementation(ArrayAggGroupImplementation.LEGACY).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.LEGACY).setLegacyRowFieldOrdinalAccess(true).setLegacyTimestamp(false).setParseDecimalLiteralsAsDouble(true).setFieldNamesInJsonCastEnabled(true).setWarnOnCommonNanPatterns(true).setLegacyCharToVarcharCoercion(true).setLegacyJsonCast(false).setDefaultNamespacePrefix("native.default").setCanonicalizedJsonExtract(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

