/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AccessControlInfo;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.AbstractAnalyzerTest;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestUtilizedColumnsAnalyzer
extends AbstractAnalyzerTest {
    @Test
    public void testWildcardSelect() {
        this.assertUtilizedTableColumns("SELECT * FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT a + b FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT a + b FROM (SELECT * FROM t1))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testCountStar() {
        this.assertUtilizedTableColumns("SELECT count(*) FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of())));
    }

    @Test
    public void testRecursiveProjectionPruning() {
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT a, b FROM (SELECT a, b, c FROM t1))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testAliasing() {
        this.assertUtilizedTableColumns("SELECT x FROM (SELECT *, a as x FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT x FROM (SELECT *, a + b as x FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT x + 3 FROM (SELECT y + 2 as x FROM (SELECT z + 1 as y FROM (SELECT a as z FROM t1 WHERE b = 1)))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT mytable.a, mytable.b FROM (SELECT * FROM t1 WHERE t1.c = 1) mytable", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT x.a, y.b FROM t1 x, t1 y", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT count(x) FROM (SELECT a as x, * FROM t1) t WHERE t.b = 3", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT y FROM (SELECT x, y FROM t1 AS mytable (w, x, y, z))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c"))));
    }

    @Test
    public void testJoin() {
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT * FROM t1, t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT t2.a + y FROM t2 CROSS JOIN (SELECT *, c + d AS y FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mytable.a + myothertable.b AS f1, myothertable.z FROM t2 AS mytable CROSS JOIN (SELECT *, a + b AS x, c - 1 AS z FROM t1) myothertable", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT t1.a FROM t1 JOIN t2 ON t1.c = t2.b", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
        this.assertUtilizedTableColumns("SELECT t2.a FROM t2 FULL OUTER JOIN (SELECT a, b FROM t1 WHERE c > 0) mytable ON t2.a = mytable.a", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT w FROM (SELECT * FROM t1 LEFT JOIN t2 ON t1.a = t2.a AND t1.b = t2.b) AS t(u, v, w, x, y, z)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT t1.c FROM t1 JOIN t2 USING (a, b)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testGroupBy() {
        this.assertUtilizedTableColumns("SELECT a, b FROM (SELECT count(a) AS a, avg(b) AS b FROM t1 GROUP BY c)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT a, b FROM (SELECT count(a) AS a, avg(b) AS b FROM t1 GROUP BY (c * (SELECT max(a) FROM t2)))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT count(a) AS c FROM t1 WHERE b = 0 GROUP BY c HAVING max(d) > 10", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT count(a) FROM t1 GROUP BY b HAVING count(a) > (SELECT max(a) FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT a, b FROM (SELECT count(a) AS a, avg(b) AS b FROM t1 GROUP BY ROLLUP(c))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT a, b FROM (SELECT count(a) AS a, avg(b) AS b FROM t1 GROUP BY CUBE(c, d))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT x FROM (SELECT sum(c) AS x FROM t1 GROUP BY GROUPING SETS (a, b))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT x FROM (SELECT grouping(a, b) AS x FROM t1 GROUP BY GROUPING SETS (a, b))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT count(a), count(b), c FROM t1 WHERE b = 0 GROUP BY 3)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    public void testOrderBy() {
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT b, c FROM t1 WHERE b = 0 ORDER BY b)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT b, c FROM t1 WHERE b = 0 ORDER BY 2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"b", (Object)"c"))));
    }

    @Test
    public void testCTE() {
        this.assertUtilizedTableColumns("WITH mytable AS (SELECT * FROM t1) SELECT x FROM (SELECT a AS x FROM mytable)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("WITH mytable AS (SELECT a as x, b as y FROM t1 WHERE c = 0) SELECT x FROM mytable", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"))));
        this.assertUtilizedTableColumns("WITH mytable AS (SELECT * FROM t1) SELECT a FROM t2", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of(), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("WITH t AS (SELECT a, b FROM t1) SELECT 1 FROM t AS mytable JOIN t as myothertable ON mytable.a = myothertable.b", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testInsert() {
        this.assertUtilizedTableColumns("INSERT INTO t2 SELECT a, b FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testCTAS() {
        this.assertUtilizedTableColumns("CREATE TABLE foo AS SELECT a, b FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testSetOperations() {
        this.assertUtilizedTableColumns("SELECT a, b FROM t1 WHERE c = 0 EXCEPT SELECT * from t2", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1 WHERE t1.b = 0 INTERSECT SELECT * from t1 WHERE t1.c = 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT * FROM ((SELECT a, b FROM t1 WHERE c = 0) UNION (SELECT * FROM t2 WHERE b = 0))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a, b FROM (SELECT a, b, c, d FROM t1 UNION ALL SELECT a AS w, b AS x, a AS y, b AS z FROM t2) WHERE c = 0 and d = c", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testLateral() {
        this.assertUtilizedTableColumns("SELECT a, x FROM t1 CROSS JOIN LATERAL (SELECT b as x)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a FROM t1 CROSS JOIN LATERAL (SELECT b as x)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT * FROM t1 CROSS JOIN LATERAL (SELECT b FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a, x, y FROM t1 CROSS JOIN LATERAL (SELECT a + 1 as x) CROSS JOIN LATERAL (SELECT x + 2 as y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testSampledRelation() {
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1 TABLESAMPLE BERNOULLI (10))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testUnnest() {
        this.assertUtilizedTableColumns("SELECT a FROM t7 CROSS JOIN UNNEST (c) AS t(x)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT a, x FROM t7 CROSS JOIN UNNEST (c) AS t(x)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT a, x, y FROM t7 CROSS JOIN UNNEST (c, d) AS t(x, y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT a, y FROM t7 CROSS JOIN UNNEST (c, d) AS t(x, y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT y FROM (SELECT (SELECT ARRAY_AGG(a) FROM t1) x) CROSS JOIN UNNEST(x) AS t(y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testUnnestMap() {
        this.assertUtilizedTableColumns("SELECT t.x, t.y FROM (select * from t1) as cte1 CROSS JOIN UNNEST (MAP(array_agg(cte1.a), array_agg(cte1.a))) AS t(x, y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT cte1.a, t.y FROM (select * from t1) as cte1 CROSS JOIN UNNEST (MAP(array_agg(cte1.c), array_agg(cte1.c))) AS t(x, y)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT t.c3, cte1.x FROM t1 CROSS JOIN UNNEST (array_agg(t1.b),MAP(array_agg(t1.c), array_agg(t1.d))) AS t(c1 , c2, c3) inner join (select * from t13) as cte1 on cte1.x = t1.d", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"))));
        this.assertUtilizedTableColumns("SELECT t.c3, cte1.x FROM t1 CROSS JOIN UNNEST (MAP(array_agg(t1.b), array_agg(t1.b)), array_agg(t1.c), array_agg(t1.d)) AS t(c1 , c2, c3, c4) inner join (select * from t13) as cte1 on cte1.x = t1.d", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c", (Object)"d"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"))));
    }

    @Test
    public void testValues() {
        this.assertUtilizedTableColumns("SELECT * FROM (VALUES 1, 2, 3)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of()));
        this.assertUtilizedTableColumns("SELECT * FROM (VALUES array[2, 2]) a(x) CROSS JOIN UNNEST(x)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of()));
        this.assertUtilizedTableColumns("SELECT a, b FROM t1 CROSS JOIN (VALUES 1, 2, 3)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testInSubquery() {
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1 WHERE t1.b IN (SELECT b FROM t2))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1 WHERE t1.b IN (SELECT b FROM t2 WHERE t2.a = 0) AND t1.c = 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a, b FROM t1 WHERE t1.b IN (SELECT b FROM t2 WHERE t2.a NOT IN (SELECT x FROM t3) AND t1.c = 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t3"), (Object)ImmutableSet.of((Object)"x"))));
        this.assertUtilizedTableColumns("SELECT r1.a, r1.b FROM t1 as r1 WHERE r1.b IN (SELECT r2.c FROM t1 as r2 WHERE r2.d = 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT r1.a, r1.b, r2.a FROM t1 as r1 JOIN t2 as r2 ON r1.a = r2.a WHERE 0 IN (SELECT x FROM t3 r3 WHERE r2.a = r3.a)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t3"), (Object)ImmutableSet.of((Object)"a", (Object)"x"))));
    }

    @Test
    public void testExistsSubquery() {
        this.assertUtilizedTableColumns("SELECT a FROM t1 WHERE NOT EXISTS (SELECT * FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of())));
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT * FROM t1 WHERE EXISTS (SELECT * FROM t2 WHERE t2.b = t1.b))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
        this.assertUtilizedTableColumns("SELECT r1.a, r1.b FROM t2 r1, t1 WHERE EXISTS (SELECT r2.a, r2.b FROM t2 r2 WHERE r2.a = r1.b AND EXISTS (SELECT r3.a, r3.b FROM t2 r3 WHERE r3.a = r2.b AND r3.b = t1.c))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT EXISTS(SELECT * FROM t1) = EXISTS(SELECT * FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of(), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of())));
        this.assertUtilizedTableColumns("SELECT EXISTS(SELECT * FROM t1 WHERE t1.a = 0) = EXISTS(SELECT * FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of())));
    }

    @Test
    public void testScalarSubquery() {
        this.assertUtilizedTableColumns("SELECT a, (SELECT avg(a) FROM t2) FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT a, ((SELECT avg(a) FROM t2) * 5) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of(), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT a FROM (SELECT a, (SELECT avg(a) FROM t2) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of())));
        this.assertUtilizedTableColumns("SELECT count(a) FROM t1 GROUP BY (b * (SELECT avg(a) FROM t2))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT count(a) FROM t1 GROUP BY (b * (SELECT avg(c)))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT count(a) FROM t1 GROUP BY b HAVING count(a) > (SELECT avg(a) FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT count(r1.a) FROM t1 as r1 GROUP BY b HAVING count(r1.a) > (SELECT avg(r1.b))", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT t1.c FROM t1 WHERE t1.b >= ANY(SELECT max(t1.a) FROM t1 GROUP BY t1.b)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT a FROM t1 WHERE t1.b >= ALL(SELECT b FROM t2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
    }

    @Test
    public void testDerivedColumns() {
        this.assertUtilizedTableColumns("SELECT b_is_zero FROM (SELECT *, b = 0 AS b_is_zero FROM t1 WHERE a = 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("WITH mycte AS (SELECT *, b = 0 as b_is_zero FROM t1 WHERE a = 0) SELECT a FROM mycte", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testOrderByInAggregation() {
        this.assertUtilizedTableColumns("SELECT myarray FROM (SELECT array_agg(a ORDER BY b, c DESC) AS myarray FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    @Test
    public void testWindowFunction() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT sum(a) OVER (PARTITION BY b ORDER BY c) AS mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    @Test
    public void testAggregationFilter() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT sum(a) FILTER (WHERE b > 0) AS mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT count(*) FILTER (WHERE a > 5) FROM t1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT sum(a) FILTER (WHERE b IN (SELECT c FROM t1)) AS mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT sum(a) FILTER (WHERE b IN (SELECT b FROM t2)) AS mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"b"))));
    }

    @Test
    public void testLambdaExpressions() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT apply(0, x -> x + a) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT apply(sum(a), x -> x * x) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT apply(0, x -> x + a) FROM (SELECT * FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT transform(c, x -> x * b) as mycolumn FROM t7)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT map_filter(x, (k, v) -> k = a) FROM (SELECT a, b, MAP(c, d) as x FROM t7)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"c", (Object)"d"))));
        this.assertUtilizedTableColumns("SELECT reduce(c, a, (s, x) -> s + x, s -> b * s) FROM (SELECT * FROM t7)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    @Test
    public void testConditionals() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT if(false, a, (SELECT max(a) FROM t2)) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT CASE a WHEN 1 THEN 1 WHEN 2 THEN (SELECT max(a) FROM t2) ELSE 0 END as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT CASE WHEN a = 1 THEN 1 WHEN b = 2 THEN (SELECT max(a) FROM t2) ELSE 0 END as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT COALESCE(a, b, (SELECT max(a) FROM t2), (SELECT max(b) FROM t2)) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT NULLIF(a, (SELECT max(a) FROM t2)) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT TRY(a / (SELECT max(a) FROM t2)) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t2"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testConstructors() {
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT ARRAY[a, b] FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT a FROM t7 WHERE ARRAY[t7.b] = c", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t7"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
        this.assertUtilizedTableColumns("SELECT c FROM (SELECT ARRAY[a, b], c FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"c"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT MAP(array_agg(a), array_agg(b)) FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT * FROM (SELECT ROW(a, b) FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
    }

    @Test
    public void testDereference() {
        this.assertUtilizedTableColumns("SELECT b.x.y FROM t10", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t10"), (Object)ImmutableSet.of((Object)"b"))));
    }

    @Test
    public void testNoPruningWhenShortCircuited() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT if(false, a, b) as mycolumn FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT a as mycolumn FROM t1 WHERE b > 0 AND false AND c < 10)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    @Test
    public void testUDF() {
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT a as mycolumn FROM t1 WHERE unittest.memory.square(b) > 0)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b"))));
        this.assertUtilizedTableColumns("SELECT mycolumn FROM (SELECT a as mycolumn, unittest.memory.square(b) FROM t1)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testCteWithExpressionInSelect() {
        this.assertUtilizedTableColumns("with cte as (select x as c1, y as c2, z + 1 as c3 from t13) select c1, c3 from (select * from cte)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x", (Object)"z"))));
    }

    @Test
    public void testMultipleCtes() {
        this.assertUtilizedTableColumns("with cte1 as (select x as c1, y as c2, z + 1 as c3 from t13), cte2 as (select c1 + 1 as a, c3 as b from cte1) select a, b from (select * from cte2)", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x", (Object)"z"))));
        this.assertUtilizedTableColumns("with cte1 as (select x as c1, z + 1 as c2, y from t13), cte2 as (select c1 + 1 c3, c2 +1 as c4 from cte1) select c3 from cte2", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"))));
    }

    @Test
    public void testMultipleCtesUsingSameTable() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1, y as c2, z + 1 as c3 from t13), cte2 as (with cte1 AS (select y +1 as c1 from t13) select * from cte1) SELECT cte1.c1, cte2.c1 from cte1 join cte2 on cte1.c1=cte2.c1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x", (Object)"y"))));
    }

    @Test
    public void testMultipleCtesSameNameSameTable() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1 from t13), cte2 as (with cte1 as (select x + 1 as c2, y + 1 as c3, z as c4 from t13) select * from cte1) select cte1.c1, cte2.c3 from cte1 join cte2 on true", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"))));
    }

    @Test
    public void testMultipleCtesSameNameDifferentTable() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1 from t13), cte2 as (with cte1 as (select a + 1 as c2, b + 1 as c3, c as c4 from t1) select * from cte1) select cte1.c1 from cte1 join cte2 on true", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a"))));
    }

    @Test
    public void testMultipleCtesDifferentNameSameTable() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1 from t13), cte2 as (with cte3 as (select x + 1 as c2, y + 1 as c3, z as c4 from t13) select * from cte3) select cte1.c1, cte2.c3 from cte1 join cte2 on true", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x", (Object)"y"))));
    }

    @Test
    public void testMultipleCtesDifferentNameDifferentTable() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1 from t13), cte2 as (with cte3 as (select a + 1 as c2, b + 1 as c3, c as c4 from t1) select * from cte3) select cte1.c1 from cte1 join cte2 on true", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of())));
    }

    @Test
    public void testMultipleCtesSameNameDifferentTableMultipleColumnsUtilized() {
        this.assertUtilizedTableColumns("with cte1 as (select x + 1 as c1 from t13), cte2 as (with cte1 as (select a + 1 as c2, b + 1 as c3, c as c4 from t1) select * from cte1) select cte1.c1, cte2.c4 from cte1 join cte2 on true", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"x"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"))));
    }

    public void testInvokerView() {
        this.assertUtilizedTableColumns("SELECT view_invoker1.a, view_invoker1.c, view_invoker2.y FROM view_invoker1 left join view_invoker2 on view_invoker2.y = view_invoker1.c", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.view_invoker1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.view_invoker2"), (Object)ImmutableSet.of((Object)"y"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"y"))));
        this.assertUtilizedTableColumns("SELECT view_invoker_with_cte1.c1, view_invoker_with_cte1.c3 FROM view_invoker_with_cte1", (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.view_invoker_with_cte1"), (Object)ImmutableSet.of((Object)"c1", (Object)"c3"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"))));
    }

    public void testDefinerView() {
        String query = "SELECT view_definer1.a, view_definer1.c, view_invoker2.y FROM view_definer1 left join view_invoker2 on view_invoker2.y = view_definer1.c";
        this.assertUtilizedTableColumns(query, (Map<String, Map<QualifiedObjectName, Set<String>>>)ImmutableMap.of((Object)"ViewAccessControl:different_user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.t1"), (Object)ImmutableSet.of((Object)"a", (Object)"c")), (Object)"AllowAllAccessControl:user", (Object)ImmutableMap.of((Object)QualifiedObjectName.valueOf((String)"tpch.s1.view_invoker2"), (Object)ImmutableSet.of((Object)"y"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.view_definer1"), (Object)ImmutableSet.of((Object)"a", (Object)"c"), (Object)QualifiedObjectName.valueOf((String)"tpch.s1.t13"), (Object)ImmutableSet.of((Object)"y"))));
    }

    private String extractAccessControlInfo(AccessControlInfo accessControlInfo) {
        return accessControlInfo.getAccessControl().getClass().getSimpleName() + ":" + accessControlInfo.getIdentity().getUser();
    }

    private void assertUtilizedTableColumns(@Language(value="SQL") String query, Map<String, Map<QualifiedObjectName, Set<String>>> expected) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().readUncommitted().readOnly().execute(CLIENT_SESSION, session -> {
            Analyzer analyzer = TestUtilizedColumnsAnalyzer.createAnalyzer(session, this.metadata, WarningCollector.NOOP, query);
            Statement statement = SQL_PARSER.createStatement(query);
            Analysis analysis = analyzer.analyze(statement);
            Assert.assertEquals(analysis.getUtilizedTableColumnReferences().entrySet().stream().collect(Collectors.toMap(entry -> this.extractAccessControlInfo((AccessControlInfo)entry.getKey()), Map.Entry::getValue)), (Map)expected);
        });
    }
}

