/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.expressions;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.nodeManager.PluginNodeManager;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.sql.planner.ExpressionOptimizerContext;
import com.facebook.presto.spi.sql.planner.ExpressionOptimizerFactory;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.expressions.ExpressionOptimizerManager;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestExpressionOptimizerManager {
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator((Metadata)METADATA);
    private File directory;
    private ExpressionOptimizerManager manager;

    @BeforeMethod
    public void setUp() throws Exception {
        this.directory = Files.createTempDirectory("test-optimizers", new FileAttribute[0]).toFile();
        this.directory.deleteOnExit();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        PluginNodeManager pluginNodeManager = new PluginNodeManager((InternalNodeManager)nodeManager);
        this.manager = new ExpressionOptimizerManager(pluginNodeManager, METADATA.getFunctionAndTypeManager(), this.directory);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        MoreFiles.deleteRecursively((Path)this.directory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testBasicIntegration() throws Exception {
        this.createPropertiesFile("foo.properties", (Map<String, String>)ImmutableMap.of((Object)"expression-manager-factory.name", (Object)"foo"));
        this.createPropertiesFile("bar.properties", (Map<String, String>)ImmutableMap.of((Object)"expression-manager-factory.name", (Object)"bar"));
        this.manager.addExpressionOptimizerFactory(this.getExpressionOptimizerFactory("foo"));
        this.manager.addExpressionOptimizerFactory(this.getExpressionOptimizerFactory("bar"));
        this.manager.loadExpressionOptimizerFactories();
        this.assertOptimizedExpression("1+1", "2", (Map<String, String>)ImmutableMap.of());
        this.assertOptimizedExpression("1+1", "2", (Map<String, String>)ImmutableMap.of((Object)"expression_optimizer_name", (Object)"default"));
        this.assertOptimizedExpression("1+1", "'foo'", (Map<String, String>)ImmutableMap.of((Object)"expression_optimizer_name", (Object)"foo"));
        this.assertOptimizedExpression("1+1", "'bar'", (Map<String, String>)ImmutableMap.of((Object)"expression_optimizer_name", (Object)"bar"));
    }

    @Test
    public void testNoNewOptimizerNameCalledDefault() throws Exception {
        this.createPropertiesFile("default.properties", (Map<String, String>)ImmutableMap.of((Object)"expression-manager-factory.name", (Object)"default"));
        this.manager.addExpressionOptimizerFactory(this.getExpressionOptimizerFactory("default"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.manager.loadExpressionOptimizerFactories());
    }

    @Test
    public void testNoFactoryName() throws Exception {
        this.createPropertiesFile("foo.properties", (Map<String, String>)ImmutableMap.of());
        this.manager.addExpressionOptimizerFactory(this.getExpressionOptimizerFactory("foo"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.manager.loadExpressionOptimizerFactories());
    }

    @Test
    public void testNoFactoryRegistered() throws Exception {
        this.createPropertiesFile("foo.properties", (Map<String, String>)ImmutableMap.of((Object)"expression-manager-factory.name", (Object)"foo"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.manager.loadExpressionOptimizerFactories());
    }

    private void assertOptimizedExpression(String originalExpression, String optimizedExpression, Map<String, String> systemProperties) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder();
        systemProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        Session session = sessionBuilder.build();
        Assert.assertEquals((Object)this.manager.getExpressionOptimizer(session.toConnectorSession()).optimize(TestExpressionOptimizerManager.expression(originalExpression), ExpressionOptimizer.Level.OPTIMIZED, session.toConnectorSession()), (Object)TestExpressionOptimizerManager.expression(optimizedExpression));
    }

    private static RowExpression expression(String expression) {
        return TRANSLATOR.translate(expression, (Map<String, Type>)ImmutableMap.of());
    }

    private void createPropertiesFile(String fileName, Map<String, String> propertiesMap) throws IOException {
        File newProperties = new File(this.directory, fileName);
        newProperties.deleteOnExit();
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        properties.store(Files.newOutputStream(newProperties.toPath(), new OpenOption[0]), null);
    }

    public ExpressionOptimizerFactory getExpressionOptimizerFactory(final String name) {
        return new ExpressionOptimizerFactory(){

            public ExpressionOptimizer createOptimizer(Map<String, String> config, ExpressionOptimizerContext context) {
                return (expression, level, session, variableResolver) -> Expressions.constant((Object)Slices.utf8Slice((String)name), (Type)METADATA.getType(TypeSignature.parseTypeSignature((String)String.format("varchar(%s)", name.length()))));
            }

            public String getName() {
                return name;
            }
        };
    }
}

