/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestAccessControlFiltersMasks
extends BasePlanTest {
    private static final String CATALOG = "local";
    private static final String USER = "user";
    private static final String RUN_AS_USER = "run-as-user";
    private LocalQueryRunner runner;
    private TestingAccessControlManager accessControl;

    @BeforeClass
    public void init() {
        this.runner = this.getQueryRunner();
        this.accessControl = this.getQueryRunner().getAccessControl();
    }

    @Test
    public void testBasicRowFilter() {
        this.executeExclusively(() -> {
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey < 10"));
            this.assertPlan("SELECT * FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERKEY < 10", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
            this.accessControl.reset();
        });
    }

    @Test
    public void testMultipleIdentityFilters() {
        this.executeExclusively(() -> {
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey = 1"));
            this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "orders"), USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey IN (SELECT orderkey FROM orders)"));
            this.assertPlan("SELECT count(*) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.node(SemiJoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY = 1", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S_ORDERKEY = 1", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"S_ORDERKEY", (Object)"orderkey")))))));
            this.accessControl.reset();
        });
    }

    @Test
    public void testBasicColumnMask() {
        this.executeExclusively(() -> {
            this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "NULL"));
            this.assertPlan("SELECT custkey FROM orders WHERE orderkey = 1", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"custkey_0", (Object)PlanMatchPattern.expression("NULL")), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))));
            this.accessControl.reset();
        });
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.runner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.runner.getExclusiveLock().unlock();
        }
    }
}

