/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestEffectivePredicateExtractor {
    private static final TableHandle DUAL_TABLE_HANDLE = new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
    private static final TableHandle DUAL_TABLE_HANDLE_WITH_LAYOUT = new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE));
    private static final VariableReferenceExpression AV = new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression BV = new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression CV = new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression DV = new VariableReferenceExpression(Optional.empty(), "d", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression EV = new VariableReferenceExpression(Optional.empty(), "e", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression FV = new VariableReferenceExpression(Optional.empty(), "f", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression GV = new VariableReferenceExpression(Optional.empty(), "g", (Type)BigintType.BIGINT);
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final LogicalRowExpressions logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.metadata.getFunctionAndTypeManager()), (StandardFunctionResolution)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), (FunctionMetadataManager)this.metadata.getFunctionAndTypeManager());
    private final EffectivePredicateExtractor effectivePredicateExtractor = new EffectivePredicateExtractor(new RowExpressionDomainTranslator(this.metadata), this.metadata.getFunctionAndTypeManager());
    private Map<VariableReferenceExpression, ColumnHandle> scanAssignments;
    private TableScanNode baseTableScan;

    @BeforeClass
    public void setUp() {
        this.scanAssignments = ImmutableMap.builder().put((Object)AV, (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)BV, (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)CV, (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)DV, (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)EV, (Object)new TestingMetadata.TestingColumnHandle("e")).put((Object)FV, (Object)new TestingMetadata.TestingColumnHandle("f")).build();
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV, (Object)DV, (Object)EV, (Object)FV)));
        this.baseTableScan = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), TupleDomain.all(), Optional.empty());
    }

    @Test
    public void testAggregation() {
        AggregationNode node = new AggregationNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)DV), this.equals((RowExpression)BV, (RowExpression)EV), this.equals((RowExpression)CV, (RowExpression)FV), this.lessThan((RowExpression)DV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)CV, (RowExpression)DV), this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(2L)), this.equals((RowExpression)EV, (RowExpression)FV)})), (Map)ImmutableMap.of((Object)CV, (Object)AggregationNodeUtils.count((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager()), (Object)DV, (Object)AggregationNodeUtils.count((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty(), Optional.empty());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)BV, (RowExpression)AV), this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(2L)), this.equals((RowExpression)BV, (RowExpression)CV)));
    }

    @Test
    public void testGroupByEmpty() {
        AggregationNode node = new AggregationNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT), (Map)ImmutableMap.of(), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty(), Optional.empty());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.TRUE_CONSTANT);
    }

    @Test
    public void testFilter() {
        FilterNode node = TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)AV, (RowExpression)Expressions.call((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (String)"rand", (Type)DoubleType.DOUBLE, (List)ImmutableList.of())), this.lessThan((RowExpression)BV, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)BV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testProject() {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), PlanBuilder.assignment(DV, (RowExpression)AV, EV, (RowExpression)CV));
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)DV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)DV, (RowExpression)EV)));
    }

    @Test
    public void testProjectOverFilterWithNoReferencedAssignments() {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)Expressions.call((String)"mod", (FunctionHandle)this.metadata.getFunctionAndTypeManager().lookupFunction("mod", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)CV, (Object)TestEffectivePredicateExtractor.bigintLiteral(5L))), TestEffectivePredicateExtractor.bigintLiteral(-1L)), this.equals((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), PlanBuilder.assignment(DV, (RowExpression)AV));
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.TRUE_CONSTANT);
    }

    @Test
    public void testTopN() {
        TopNNode node = new TopNNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, new OrderingScheme((List)ImmutableList.of((Object)new Ordering(AV, SortOrder.ASC_NULLS_FIRST))), TopNNode.Step.PARTIAL);
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testLimit() {
        LimitNode node = new LimitNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, LimitNode.Step.FINAL);
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testSort() {
        SortNode node = new SortNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new OrderingScheme((List)ImmutableList.of((Object)new Ordering(AV, SortOrder.ASC_NULLS_LAST))), false, (List)ImmutableList.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testWindow() {
        WindowNode node = new WindowNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new DataOrganizationSpecification((List)ImmutableList.of((Object)AV), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(AV, SortOrder.ASC_NULLS_LAST))))), (Map)ImmutableMap.of(), Optional.empty(), (Set)ImmutableSet.of(), 0);
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)AV, (RowExpression)BV), this.equals((RowExpression)BV, (RowExpression)CV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testTableScan() {
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV, (Object)DV)));
        TableScanNode node = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), TupleDomain.all(), Optional.empty());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.TRUE_CONSTANT);
        node = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE_WITH_LAYOUT, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.none(), TupleDomain.all(), Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.FALSE_CONSTANT);
        node = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE_WITH_LAYOUT, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(AV), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), TupleDomain.all(), Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), (RowExpression)AV)));
        node = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE_WITH_LAYOUT, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(AV), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)this.scanAssignments.get(BV), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), TupleDomain.all(), Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), (RowExpression)BV), this.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), (RowExpression)AV)));
        node = new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), TupleDomain.all(), Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.TRUE_CONSTANT);
    }

    @Test
    public void testUnion() {
        UnionNode node = new UnionNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L))), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(100L))}))), (List)ImmutableList.of((Object)AV), (Map)ImmutableMap.of((Object)AV, (Object)ImmutableList.of((Object)BV, (Object)CV, (Object)EV)));
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new EquiJoinClause(AV, DV));
        criteriaBuilder.add((Object)new EquiJoinClause(BV, EV));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)GV, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.of(this.lessThanOrEqual((RowExpression)BV, (RowExpression)EV)), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L)), this.equals((RowExpression)AV, (RowExpression)DV), this.equals((RowExpression)BV, (RowExpression)EV), this.lessThanOrEqual((RowExpression)BV, (RowExpression)EV)));
    }

    @Test
    public void testInnerJoinPropagatesPredicatesViaEquiConditions() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, this.equals((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)));
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)rightScan, (List)ImmutableList.of((Object)new EquiJoinClause(AV, DV)), (List)ImmutableList.builder().addAll((Iterable)rightScan.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)DV, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoinWithFalseFilter() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)leftScan, (PlanNode)rightScan, (List)ImmutableList.of((Object)new EquiJoinClause(AV, DV)), (List)ImmutableList.builder().addAll((Iterable)leftScan.getOutputVariables()).addAll((Iterable)rightScan.getOutputVariables()).build(), Optional.of(LogicalRowExpressions.FALSE_CONSTANT), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)LogicalRowExpressions.FALSE_CONSTANT);
    }

    @Test
    public void testLeftJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new EquiJoinClause(AV, DV));
        criteriaBuilder.add((Object)new EquiJoinClause(BV, EV));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)GV, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)DV, (RowExpression)EV), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{TestEffectivePredicateExtractor.isNull((RowExpression)DV), TestEffectivePredicateExtractor.isNull((RowExpression)EV)})}), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.isNull((RowExpression)FV)}), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)DV), TestEffectivePredicateExtractor.isNull((RowExpression)DV)}), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)BV, (RowExpression)EV), TestEffectivePredicateExtractor.isNull((RowExpression)EV)})));
    }

    @Test
    public void testLeftJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new EquiJoinClause(AV, DV));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)GV, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)DV), TestEffectivePredicateExtractor.isNull((RowExpression)DV)})));
    }

    @Test
    public void testRightJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new EquiJoinClause(AV, DV));
        criteriaBuilder.add((Object)new EquiJoinClause(BV, EV));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)BV, (RowExpression)AV), this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.equals((RowExpression)GV, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)BV, (RowExpression)AV), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{TestEffectivePredicateExtractor.isNull((RowExpression)BV), TestEffectivePredicateExtractor.isNull((RowExpression)AV)})}), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.lessThan((RowExpression)CV, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.isNull((RowExpression)CV)}), this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L)), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)DV), TestEffectivePredicateExtractor.isNull((RowExpression)AV)}), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)BV, (RowExpression)EV), TestEffectivePredicateExtractor.isNull((RowExpression)BV)})));
    }

    @Test
    public void testRightJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new EquiJoinClause(AV, DV));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)AV, (Object)BV, (Object)CV)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)DV, (Object)EV, (Object)FV)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(this.equals((RowExpression)DV, (RowExpression)EV), this.lessThan((RowExpression)FV, TestEffectivePredicateExtractor.bigintLiteral(100L)), LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.equals((RowExpression)AV, (RowExpression)DV), TestEffectivePredicateExtractor.isNull((RowExpression)AV)})));
    }

    @Test
    public void testSemiJoin() {
        SemiJoinNode node = new SemiJoinNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(5L))), AV, BV, CV, Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        RowExpression effectivePredicate = this.effectivePredicateExtractor.extract((PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.greaterThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(10L)), this.lessThan((RowExpression)AV, TestEffectivePredicateExtractor.bigintLiteral(100L))})));
    }

    private static TableScanNode tableScanNode(Map<VariableReferenceExpression, ColumnHandle> scanAssignments) {
        return new TableScanNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(scanAssignments.keySet()), scanAssignments, TupleDomain.all(), TupleDomain.all(), Optional.empty());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static FilterNode filter(PlanNode source, RowExpression predicate) {
        return new FilterNode(Optional.empty(), TestEffectivePredicateExtractor.newId(), source, predicate);
    }

    private static RowExpression bigintLiteral(long number) {
        return Expressions.constant((Object)number, (Type)BigintType.BIGINT);
    }

    private RowExpression equals(RowExpression expression1, RowExpression expression2) {
        return this.compare(OperatorType.EQUAL, expression1, expression2);
    }

    private RowExpression lessThan(RowExpression expression1, RowExpression expression2) {
        return this.compare(OperatorType.LESS_THAN, expression1, expression2);
    }

    private RowExpression lessThanOrEqual(RowExpression expression1, RowExpression expression2) {
        return this.compare(OperatorType.LESS_THAN_OR_EQUAL, expression1, expression2);
    }

    private RowExpression greaterThan(RowExpression expression1, RowExpression expression2) {
        return this.compare(OperatorType.GREATER_THAN, expression1, expression2);
    }

    private RowExpression compare(OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call((String)type.getFunctionName().getObjectName(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().resolveOperator(type, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private static RowExpression isNull(RowExpression expression) {
        return Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{expression});
    }

    private Set<RowExpression> normalizeConjuncts(RowExpression ... conjuncts) {
        return this.normalizeConjuncts(Arrays.asList(conjuncts));
    }

    private Set<RowExpression> normalizeConjuncts(Collection<RowExpression> conjuncts) {
        return this.normalizeConjuncts(this.logicalRowExpressions.combineConjuncts(conjuncts));
    }

    private Set<RowExpression> normalizeConjuncts(RowExpression predicate) {
        EqualityInference inference = EqualityInference.createEqualityInference((Metadata)this.metadata, (RowExpression[])new RowExpression[]{predicate});
        HashSet<RowExpression> rewrittenSet = new HashSet<RowExpression>();
        for (RowExpression expression : EqualityInference.Builder.nonInferableConjuncts((Metadata)this.metadata, (RowExpression)predicate)) {
            RowExpression rewritten = inference.rewriteExpression(expression, Predicates.alwaysTrue());
            Preconditions.checkState((rewritten != null ? 1 : 0) != 0, (Object)"Rewrite with full symbol scope should always be possible");
            rewrittenSet.add(rewritten);
        }
        rewrittenSet.addAll(inference.generateEqualitiesPartitionedBy(Predicates.alwaysTrue()).getScopeEqualities());
        return rewrittenSet;
    }
}

