/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.spi.plan.AbstractJoinNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.LocalDynamicFilter;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.testng.annotations.Test;

public class TestLocalDynamicFilter
extends BasePlanTest {
    public TestLocalDynamicFilter() {
        super((Map<String, String>)ImmutableMap.of((Object)"force_single_node_output", (Object)"false", (Object)"join_distribution_type", (Object)"BROADCAST", (Object)"enable_dynamic_filtering", (Object)"true"));
    }

    @Test
    public void testSimple() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
    }

    @Test
    public void testMultipleProbeVariables() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a1", (Type)IntegerType.INTEGER), OperatorType.EQUAL), (Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a2", (Type)IntegerType.INTEGER), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a1", (Type)IntegerType.INTEGER), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L), (Object)new VariableReferenceExpression(Optional.empty(), "a2", (Type)IntegerType.INTEGER), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
    }

    @Test
    public void testMultiplePartitions() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L)))));
    }

    @Test
    public void testNone() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.none((Type)IntegerType.INTEGER))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), (Object)Domain.none((Type)IntegerType.INTEGER))));
    }

    @Test
    public void testMultipleColumns() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), OperatorType.EQUAL), (Object)"456", (Object)new DynamicFilters.DynamicFilterPlaceholder("456", (RowExpression)new VariableReferenceExpression(Optional.empty(), "b", (Type)IntegerType.INTEGER), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0, (Object)"456", (Object)1), 1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0, (Object)"456", (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)"456", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new VariableReferenceExpression(Optional.empty(), "b", (Type)IntegerType.INTEGER), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
    }

    @Test
    public void testMultiplePartitionsAndColumns() throws ExecutionException, InterruptedException {
        LocalDynamicFilter filter = new LocalDynamicFilter((Multimap)ImmutableMultimap.of((Object)"123", (Object)new DynamicFilters.DynamicFilterPlaceholder("123", (RowExpression)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), OperatorType.EQUAL), (Object)"456", (Object)new DynamicFilters.DynamicFilterPlaceholder("456", (RowExpression)new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT), OperatorType.EQUAL)), (Map)ImmutableMap.of((Object)"123", (Object)0, (Object)"456", (Object)1), 2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)"123", (Object)0, (Object)"456", (Object)1));
        Consumer consumer = filter.getTupleDomainConsumer();
        ListenableFuture result = filter.getResultFuture();
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)"456", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L))));
        org.testng.Assert.assertFalse((boolean)result.isDone());
        consumer.accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"123", (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L), (Object)"456", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)200L))));
        Assert.assertEquals((Object)result.get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)IntegerType.INTEGER), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L)), (Object)new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)100L, (Object)200L)))));
    }

    @Test
    public void testCreateSingleColumn() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, orders WHERE lineitem.orderkey = orders.orderkey AND orders.custkey < 10", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        LocalDynamicFilter filter = (LocalDynamicFilter)LocalDynamicFilter.create((AbstractJoinNode)joinNode, (int)1).orElseThrow(NoSuchElementException::new);
        String filterId = (String)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
        VariableReferenceExpression probeVariable = ((EquiJoinClause)Iterables.getOnlyElement((Iterable)joinNode.getCriteria())).getLeft();
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L))));
        Assert.assertEquals((Object)filter.getResultFuture().get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)probeVariable, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)3L))));
    }

    @Test
    public void testCreateDistributedJoin() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", "PARTITIONED").build();
        SubPlan subplan = this.subplan("SELECT count() FROM nation, region WHERE nation.regionkey = region.regionkey AND region.comment = 'abc'", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false, session);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        org.testng.Assert.assertFalse((boolean)joinNode.getDynamicFilters().isEmpty());
        Assert.assertEquals((Object)LocalDynamicFilter.create((AbstractJoinNode)joinNode, (int)1), Optional.empty());
    }

    @Test
    public void testCreateMultipleCriteria() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, partsupp WHERE lineitem.partkey = partsupp.partkey AND lineitem.suppkey = partsupp.suppkey AND partsupp.availqty < 10", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false);
        JoinNode joinNode = (JoinNode)this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findOnlyElement();
        LocalDynamicFilter filter = (LocalDynamicFilter)LocalDynamicFilter.create((AbstractJoinNode)joinNode, (int)1).orElseThrow(NoSuchElementException::new);
        List filterIds = (List)filter.getBuildChannels().entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((String)filterIds.get(0)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)4L), (Object)((String)filterIds.get(1)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))));
        TupleDomain expected = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "partkey", (Type)BigintType.BIGINT), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)4L), (Object)new VariableReferenceExpression(Optional.empty(), "suppkey", (Type)BigintType.BIGINT), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)));
        Assert.assertEquals((Object)filter.getResultFuture().get(), (Object)expected);
    }

    @Test
    public void testCreateMultipleJoins() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("SELECT count() FROM lineitem, orders, part WHERE lineitem.orderkey = orders.orderkey AND lineitem.partkey = part.partkey AND orders.custkey < 10 AND part.name = 'abc'", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, false);
        List joinNodes = this.searchJoins(((SubPlan)subplan.getChildren().get(0)).getFragment()).findAll();
        Assert.assertEquals((int)joinNodes.size(), (int)2);
        for (JoinNode joinNode : joinNodes) {
            LocalDynamicFilter filter = (LocalDynamicFilter)LocalDynamicFilter.create((AbstractJoinNode)joinNode, (int)1).orElseThrow(NoSuchElementException::new);
            String filterId = (String)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
            VariableReferenceExpression probeVariable = ((EquiJoinClause)Iterables.getOnlyElement((Iterable)joinNode.getCriteria())).getLeft();
            filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L))));
            Assert.assertEquals((Object)filter.getResultFuture().get(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)probeVariable, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L))));
        }
    }

    @Test
    public void testCreateProbeSideUnion() throws ExecutionException, InterruptedException {
        SubPlan subplan = this.subplan("WITH union_table(key) AS ((SELECT partkey FROM part) UNION (SELECT suppkey FROM supplier)) SELECT count() FROM union_table, nation WHERE union_table.key = nation.nationkey AND nation.comment = 'abc'", Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, true);
        JoinNode joinNode = (JoinNode)this.searchJoins(subplan.getFragment()).findOnlyElement();
        LocalDynamicFilter filter = (LocalDynamicFilter)LocalDynamicFilter.create((AbstractJoinNode)joinNode, (int)1).orElseThrow(NoSuchElementException::new);
        String filterId = (String)Iterables.getOnlyElement(filter.getBuildChannels().keySet());
        filter.getTupleDomainConsumer().accept(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L))));
        TupleDomain expected = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "partkey", (Type)BigintType.BIGINT), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L), (Object)new VariableReferenceExpression(Optional.empty(), "suppkey", (Type)BigintType.BIGINT), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)7L)));
        Assert.assertEquals((Object)filter.getResultFuture().get(), (Object)expected);
    }

    private PlanNodeSearcher searchJoins(PlanFragment fragment) {
        return PlanNodeSearcher.searchFrom((PlanNode)fragment.getRoot()).where(node -> node instanceof JoinNode);
    }
}

