/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DesugarTryExpressionRewriter;
import com.facebook.presto.sql.planner.NullabilityAnalyzer;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.LambdaCaptureDesugaringRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNullabilityAnalyzer {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator(METADATA);
    private static final TypeProvider TYPES = TypeProvider.viewOf((Map)new ImmutableMap.Builder().put((Object)"a", (Object)BigintType.BIGINT).put((Object)"b", (Object)new ArrayType((Type)BigintType.BIGINT)).put((Object)"c", (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"field_1", (Type)BigintType.BIGINT)))).build());
    private static final NullabilityAnalyzer analyzer = new NullabilityAnalyzer(METADATA.getFunctionAndTypeManager());

    @Test
    void test() {
        this.assertNullability("TRY_CAST(JSON '123' AS VARCHAR)", true);
        this.assertNullability("TRY_CAST(a AS VARCHAR)", true);
        this.assertNullability("CAST(a AS VARCHAR)", true);
        this.assertNullability("TRY_CAST('123' AS VARCHAR)", false);
        this.assertNullability("CAST('123' AS VARCHAR)", false);
        this.assertNullability("a = 1", false);
        this.assertNullability("(a/9+1)*5-10 > 10", false);
        this.assertNullability("1", false);
        this.assertNullability("a", false);
        this.assertNullability("TRY(a + 1)", true);
        this.assertNullability("IF(a > 10, 1)", true);
        this.assertNullability("a IN (1, NULL)", true);
        this.assertNullability("CASE WHEN a> 10 THEN 1 END", true);
        this.assertNullability("c.field_1", true);
        this.assertNullability("b[0]", true);
        this.assertNullability("a BETWEEN 1 AND 2", false);
        this.assertNullability("1 = TRY(a + 1)", true);
    }

    private void assertNullability(String expression, boolean mayReturnNullForNotNullInput) {
        Expression rawExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expression, new ParsingOptions()));
        Expression desugaredExpression = new TestingDesugarExpressions(TYPES.allVariables()).rewrite(rawExpression);
        RowExpression rowExpression = TRANSLATOR.translate(desugaredExpression, TYPES);
        Assert.assertEquals((boolean)analyzer.mayReturnNullOnNonNullInput(rowExpression), (boolean)mayReturnNullForNotNullInput);
    }

    private static class TestingDesugarExpressions {
        private final VariableAllocator variableAllocator;

        public TestingDesugarExpressions(Collection<VariableReferenceExpression> variables) {
            this.variableAllocator = new VariableAllocator(variables);
        }

        public Expression rewrite(Expression expression) {
            expression = DesugarTryExpressionRewriter.rewrite((Expression)expression);
            expression = LambdaCaptureDesugaringRewriter.rewrite((Expression)expression, (VariableAllocator)this.variableAllocator);
            return expression;
        }
    }
}

