/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableExtractor {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator(METADATA);
    private static final TypeProvider SYMBOL_TYPES = TypeProvider.fromVariables((Collection)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT)));

    @Test
    public void testSimple() {
        TestVariableExtractor.assertVariables("a > b");
        TestVariableExtractor.assertVariables("a + b > c");
        TestVariableExtractor.assertVariables("sin(a) - b");
        TestVariableExtractor.assertVariables("sin(a) + cos(a) - b");
        TestVariableExtractor.assertVariables("sin(a) + cos(a) + a - b");
        TestVariableExtractor.assertVariables("COALESCE(a, b, 1)");
        TestVariableExtractor.assertVariables("a IN (a, b, c)");
        TestVariableExtractor.assertVariables("transform(sequence(1, 5), a -> a + b)");
        TestVariableExtractor.assertVariables("bigint '1'");
    }

    private static void assertVariables(String expression) {
        Expression expected = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(expression, new ParsingOptions()));
        RowExpression actual = TRANSLATOR.translate(expected, SYMBOL_TYPES);
        Assert.assertEquals((Set)VariablesExtractor.extractUnique((Expression)expected, (TypeProvider)SYMBOL_TYPES), (Set)VariablesExtractor.extractUnique((RowExpression)actual));
        Assert.assertEquals((Collection)((Collection)VariablesExtractor.extractAll((Expression)expected, (TypeProvider)SYMBOL_TYPES).stream().sorted().collect(ImmutableList.toImmutableList())), (Collection)((Collection)VariablesExtractor.extractAll((RowExpression)actual).stream().sorted().collect(ImmutableList.toImmutableList())));
    }
}

