/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.ShortDecimalType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestWindowFrameRange
extends BasePlanTest {
    @Test
    public void testFramePrecedingWithSortKeyCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE x PRECEDING) FROM (VALUES (1, 1.1), (2, 2.2)) T(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), FunctionAndTypeManager.createTestFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), QualifiedObjectName.valueOf((String)"presto.default.array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})), PlanMatchPattern.windowFrame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.PRECEDING, Optional.of("frame_start_value"), Optional.of(new ShortDecimalType(12, 1)), Optional.of("key_for_frame_start_comparison"), Optional.of(new ShortDecimalType(12, 1)), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_comparison", (Object)PlanMatchPattern.expression("CAST(key AS decimal(12, 1))"), (Object)"key", (Object)PlanMatchPattern.expression("key"), (Object)"frame_start_value", (Object)PlanMatchPattern.expression("CAST(key AS decimal(10, 0)) - x")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new DecimalLiteral("11")), (Object)ImmutableList.of((Object)new LongLiteral("2"), (Object)new DecimalLiteral("22"))))))));
        this.assertPlan(sql, Optimizer.PlanStage.OPTIMIZED, pattern);
    }

    @Test
    public void testFrameFollowingWithOffsetCoercion() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN CURRENT ROW AND x FOLLOWING) FROM (VALUES (1.1, 1), (2.2, 2)) T(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), FunctionAndTypeManager.createTestFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), QualifiedObjectName.valueOf((String)"presto.default.array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)2, (int)1)})), PlanMatchPattern.windowFrame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), WindowNode.Frame.BoundType.FOLLOWING, Optional.of("frame_end_value"), Optional.of(new ShortDecimalType(12, 1)), Optional.of("key_for_frame_end_comparison"), Optional.of(new ShortDecimalType(12, 1)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_end_comparison", (Object)PlanMatchPattern.expression("CAST(key AS decimal(12, 1))"), (Object)"key", (Object)PlanMatchPattern.expression("key"), (Object)"frame_end_value", (Object)PlanMatchPattern.expression("key + CAST(x AS decimal(10, 0))")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DecimalLiteral("11"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new DecimalLiteral("22"), (Object)new LongLiteral("2"))))))));
        this.assertPlan(sql, Optimizer.PlanStage.OPTIMIZED, pattern);
    }

    @Test
    public void testFramePrecedingFollowingNoCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN x PRECEDING AND y FOLLOWING) FROM (VALUES (1, 1, 1), (2, 2, 2)) T(key, x, y)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), FunctionAndTypeManager.createTestFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), QualifiedObjectName.valueOf((String)"presto.default.array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})), PlanMatchPattern.windowFrame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.PRECEDING, Optional.of("frame_start_value"), Optional.of(IntegerType.INTEGER), Optional.of("key"), Optional.of(IntegerType.INTEGER), WindowNode.Frame.BoundType.FOLLOWING, Optional.of("frame_end_value"), Optional.of(IntegerType.INTEGER), Optional.of("key"), Optional.of(IntegerType.INTEGER))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"presto", (String[])new String[]{"default", "$operator$add"}), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("y"))))), PlanMatchPattern.filter("IF((y >= CAST(0 AS INTEGER)), true, CAST(presto.default.fail(CAST('Window frame offset value must not be negative or null' AS varchar)) AS boolean))", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"presto", (String[])new String[]{"default", "$operator$subtract"}), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("x"))))), PlanMatchPattern.filter("IF((x >= CAST(0 AS INTEGER)), true, CAST(presto.default.fail(CAST('Window frame offset value must not be negative or null' AS varchar)) AS boolean))", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("1"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("2"), (Object)new LongLiteral("2"), (Object)new LongLiteral("2")))))))))));
        this.assertPlan(sql, Optimizer.PlanStage.CREATED, pattern);
    }
}

