/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.Preconditions;

public class AggregationStepMatcher
implements Matcher {
    private final AggregationNode.Step step;

    public AggregationStepMatcher(AggregationNode.Step step) {
        this.step = step;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof AggregationNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        AggregationNode aggregationNode = (AggregationNode)node;
        if (aggregationNode.getStep() != this.step) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }
}

