/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import java.util.Objects;
import java.util.Optional;

public class AliasMatcher
implements Matcher {
    private final Optional<String> alias;
    private final RvalueMatcher matcher;

    AliasMatcher(Optional<String> alias, RvalueMatcher matcher) {
        this.alias = Objects.requireNonNull(alias, "alias is null");
        this.matcher = Objects.requireNonNull(matcher, "matcher is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<VariableReferenceExpression> variable = this.matcher.getAssignedVariable(node, session, metadata, symbolAliases);
        if (variable.isPresent() && this.alias.isPresent()) {
            return MatchResult.match(this.alias.get(), ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)variable.get()));
        }
        return new MatchResult(variable.isPresent());
    }

    public String toString() {
        if (this.alias.isPresent()) {
            return String.format("bind %s -> %s", this.alias.get(), this.matcher);
        }
        return String.format("bind %s", this.matcher);
    }
}

